topic "Advanced Find and Replace";
[l288;i1120;a17;O9;~~~.1408;2 $$1,0#10431211400427159095818037425705:param]
[a83;*R6 $$2,5#31310162474203024125188417583966:caption]
[H4;b83;*4 $$3,5#07864147445237544204411237157677:title]
[i288;O9;C2 $$4,6#40027414424643823182269349404212:item]
[b42;a42;ph2 $$5,5#45413000475342174754091244180557:text]
[l288;b17;a17;2 $$6,6#27521748481378242620020725143825:desc]
[l321;C@5;1 $$7,7#20902679421464641399138805415013:code]
[b2503;2 $$8,0#65142375456100023862071332075487:separator]
[*@(0.0.255)2 $$9,0#83433469410354161042741608181528:base]
[C2 $$10,0#37138531426314131251341829483380:class]
[l288;a17;*1 $$11,11#70004532496200323422659154056402:requirement]
[i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam]
[b167;C2 $$13,13#92430459443460461911108080531343:item1]
[i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2]
[*@2$(0.128.128)2 $$15,15#34511555403152284025741354420178:NewsDate]
[l321;*C$7;2 $$16,16#03451589433145915344929335295360:result]
[l321;b83;a83;*C$7;2 $$17,17#07531550463529505371228428965313:result`-line]
[l160;*C+117 $$18,5#88603949442205825958800053222425:package`-title]
[2 $$19,0#53580023442335529039900623488521:gap]
[C2 $$20,20#70211524482531209251820423858195:class`-nested]
[b50;2 $$21,21#03324558446220344731010354752573:Par]
[2 $$0,0#00000000000000000000000000000000:Default]
[{_}%EN-US 
[s2; Advanced Find and Replace&]
[s3; Table of contents&]
[s0; &]
[s0; [^topic`:`/`/ide`/app`/AdvancedReplace`_en`-us`#1^ 1. Introduction]&]
[s0; &]
[s3;:1: 1. Introduction&]
[s5; TheIDE find and replace in the block, using wildcards, has some 
specific features available that make it suitable for some lightweight 
text transformations.&]
[s5; ([/ Note: TheIDE also supports normal regular expressions in addition 
to wildcards.)]&]
[s5; Now first thing to mention is that you can search and replace 
for line ending character using [* `\n] and for tabulator using 
[* `\t] (use `\`\n and `\`\t for escaping). So to put several lines 
into single line, use&]
[s0;l128; search:-|[* `\n]&]
[s0;l128; replace:-|[@(128) (nothing)]&]
[s5; Or to replace `',`' with tabulator, use&]
[s0;l128; search:-|,&]
[s0;l128; replace:-|[* `\t]&]
[s5; When search`&replace is case`-insensitive, it is often useful 
when replace follows the case of source. This option is activated 
by `"Mimic case`" switch. Consider&]
[s0; &]
[s7; Foo&]
[s7; FOO&]
[s7; foo&]
[s7; FoO&]
[s0; &]
[s0;= 
@@image:1977&848
(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)
&]
[s0; &]
[s7; Bar&]
[s7; BAR&]
[s7; bar&]
[s7; Bar&]
[s0; &]
[s5; Note that in the last line, the last letter is not uppercased 
`- replaced text can have different length, so the result of 
operation is determined by checking the first two characters 
only, resulting in lower`-case, upper`-case or init`-caps scenarios.&]
[s5; For more interesting things to happen, you can activate wildcards:&]
[s0; &]
[s0;= 
@@image:1977&848
(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)
&]
[s0; &]
[s5; Wildcards allow matching numbers, identifiers, spaces or any 
text. You can get help about wildcards and insert wildcards by 
clicking small arrow in the right part of Find field:&]
[s0; &]
[s0;= 
@@image:2922&1023
(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)
&]
[s0;= &]
[s5; Note that pattern matching is done on per`-line basis (`'One 
or more any characters`' do not include line`-ending). When pattern 
is matched, it is possible to use matched wildcards in replace 
text. Again, you can get the list of replacement placeholders 
by clicking small arrow in the right part of Find field:&]
[s0; &]
[s0;= 
@@image:2625&2160
(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)
&]
[s0; &]
[s5; Now for some practical examples. Suppose you want to `'extract`' 
only identifiers inside THISBACK(). You can do that using&]
[s0; &]
[s7;~~~32; out.Escape(`"EditFile(...)`", THISBACK(MacroEditFile));&]
[s7; out.Escape(`"SaveCurrentFile()`", THISBACK(MacroSaveCurrentFile));&]
[s7; out.Escape(`"CloseFile()`",THISBACK(MacroCloseFile));&]
[s0; &]
[s0;l128;~~~32; search:-|[* `*THISBACK(`$)`*`\n]&]
[s0;l128;~~~32; replace:-|[* `$`\n]&]
[s0; &]
[s7; MacroEditFile&]
[s7; MacroSaveCurrentFile&]
[s7; MacroCloseFile&]
[s7; &]
[s5; You can use positional replace wildcards to change the order 
of identifiers, e.g.&]
[s0; &]
[s7;~~~32; out.Escape(`"EditFile(...)`", THISBACK(MacroEditFile));&]
[s7; out.Escape(`"SaveCurrentFile()`", THISBACK(MacroSaveCurrentFile));&]
[s7; out.Escape(`"CloseFile()`",THISBACK(MacroCloseFile));&]
[s7; &]
[s0;l128;~~~384; [/ search:-|][* `*`"`$`*THISBACK(`$)`*`\n]&]
[s0;l128;~~~384; [/ replace:-|][* `*`"`@4`*THISBACK(`@2)`*`\n]&]
[s0; &]
[s7; out.Escape(`"MacroEditFile(...)`", THISBACK(EditFile));&]
[s7; out.Escape(`"MacroSaveCurrentFile()`", THISBACK(SaveCurrentFile));&]
[s7; out.Escape(`"MacroCloseFile()`",THISBACK(CloseFile));&]
[s7; &]
[s5; In replace wildcard, it is also possible to specify that the 
text is converted to upper`-case, lower`-case or init`-caps (first 
letter upper`-case, rest lowercase):&]
[s0; &]
[s7;~~~32; out.Escape(`"EditFile(...)`", THISBACK(MacroEditFile));&]
[s7; out.Escape(`"SaveCurrentFile()`", THISBACK(MacroSaveCurrentFile));&]
[s7; out.Escape(`"CloseFile()`",THISBACK(MacroCloseFile));&]
[s7; &]
[s0;l128; search:-|[* THISBACK(`$)]&]
[s0;l128; replace:-|[* THISBACK(`$`+)]&]
[s0; &]
[s7; out.Escape(`"EditFile(...)`", THISBACK(MACROEDITFILE));&]
[s7; out.Escape(`"SaveCurrentFile()`", THISBACK(MACROSAVECURRENTFILE));&]
[s7; out.Escape(`"CloseFile()`",THISBACK(MACROCLOSEFILE));&]
[s7; &]
[s5; Finally, it it also possible to insert the replace index (either 
0 or 1 based) into replace text (here combined with init`-caps):&]
[s0; &]
[s7;~~~32; out.Escape(`"EditFile(...)`", THISBACK(MacroEditFile));&]
[s7; out.Escape(`"SaveCurrentFile()`", THISBACK(MacroSaveCurrentFile));&]
[s7; out.Escape(`"CloseFile()`",THISBACK(MacroCloseFile));&]
[s7; &]
[s0;l128;~~~384; [/ search:-|][* THISBACK(`$)]&]
[s0;l128;~~~384; [/ replace:-|][* THISBACK(`$!`@#)]&]
[s0; &]
[s7; out.Escape(`"EditFile(...)`", THISBACK(Macroeditfile1));&]
[s7; out.Escape(`"SaveCurrentFile()`", THISBACK(Macrosavecurrentfile2));&]
[s7; out.Escape(`"CloseFile()`",THISBACK(Macroclosefile3));&]
[s7; &]
[s0; ]]