/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.SystemScreen;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class UninstallFailureScreen
extends SystemScreen {
    private JTextPane txaInfo;
    private JScrollPane scpInfo;
    private boolean failure;

    public boolean isPreviousVisible() {
        return false;
    }

    public boolean isHidden() {
        return InstallerUtil.isWindows();
    }

    public void activated() {
        this.failure = this.checkFailure();
        if (this.failure) {
            super.activated();
        } else {
            this.getContext().goForward(1, true, true);
        }
    }

    public void deactivated() {
        if (this.failure) {
            System.exit(1);
        } else {
            super.deactivated();
        }
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        this.setupControls();
        if (this.checkFailure()) {
            console.println(this.getMessage("UninstallFailureLabel"));
            console.println(this.txaInfo.getText());
            System.exit(1);
        }
        return true;
    }

    protected void setupControls() {
        super.setupControls();
        this.txaInfo = new JTextPane();
        this.txaInfo.setEditable(false);
        this.scpInfo = new JScrollPane(this.txaInfo);
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        String string = this.getMessage("UninstallFailureLabel");
        if (string.trim().length() > 0) {
            this.addDisplayTextArea(string, jPanel, gridBagConstraints);
        }
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.bottom = 10;
        jPanel.add((Component)this.scpInfo, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    public String getTitle() {
        return this.getMessage("UninstallFailureTitle");
    }

    public String getSubTitle() {
        return MessageFormat.format(this.getMessage("UninstallFailureSubTitle"), this.getApplicationName());
    }

    private boolean checkFailure() {
        String string;
        if (InstallerUtil.isWindows()) {
            return false;
        }
        List list = FileInstaller.getInstance().deleteUndeleted();
        StringBuffer stringBuffer = new StringBuffer();
        if (list.size() > 0) {
            this.addFailureText(list, stringBuffer);
        }
        if ((string = stringBuffer.toString()).length() > 0) {
            this.txaInfo.setText(string);
            return true;
        }
        return false;
    }

    private void addFailureText(List list, StringBuffer stringBuffer) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            stringBuffer.append(file.getPath());
            stringBuffer.append("\n");
        }
    }
}

