/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.exe4j.runtime.util.ReadIOException;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.AbstractInstallFilesAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public class InstallFilesAction
extends AbstractInstallFilesAction {
    private static InstallFilesAction firstExecutedAction = null;
    private boolean installRuntime = true;
    private boolean updateBundledJre = true;
    private boolean validateApplicationId = false;
    private boolean checkFreeSpace = true;
    private ScriptProperty sizeCalculatorScript;
    private boolean saveDownloadedFiles = false;

    public ScriptProperty getSizeCalculatorScript() {
        return this.sizeCalculatorScript;
    }

    public void setSizeCalculatorScript(ScriptProperty scriptProperty) {
        this.sizeCalculatorScript = scriptProperty;
    }

    public boolean isSaveDownloadedFiles() {
        return this.saveDownloadedFiles;
    }

    public void setSaveDownloadedFiles(boolean bl) {
        this.saveDownloadedFiles = bl;
    }

    public boolean isInstallRuntime() {
        return this.installRuntime;
    }

    public void setInstallRuntime(boolean bl) {
        this.installRuntime = bl;
    }

    public boolean isUpdateBundledJre() {
        return this.updateBundledJre;
    }

    public void setUpdateBundledJre(boolean bl) {
        this.updateBundledJre = bl;
    }

    public boolean isValidateApplicationId() {
        return this.validateApplicationId;
    }

    public void setValidateApplicationId(boolean bl) {
        this.validateApplicationId = bl;
    }

    public boolean isCheckFreeSpace() {
        return this.checkFreeSpace;
    }

    public void setCheckFreeSpace(boolean bl) {
        this.checkFreeSpace = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        String string;
        if (firstExecutedAction != this && firstExecutedAction != null) {
            Logger.getInstance().info(this, "Another install files action has already run.");
            return true;
        }
        firstExecutedAction = this;
        this.log();
        ProgressInterface progressInterface = this.getProgressInterface(installerContext);
        File file = ContentInstaller.validateInstallationDir(installerContext.getInstallationDirectory(), this.isValidateApplicationId(), this.isCheckFreeSpace(), false, installerContext.isUnattended(), true);
        if (file == null) {
            throw new UserCanceledException();
        }
        installerContext.setInstallationDirectory(file);
        if (!Boolean.getBoolean("install4j.keepServicesRunning")) {
            ServiceHandler.stopServices(installerContext, false);
        }
        String string2 = string = InstallerConfig.getCurrentInstance().isAddOnInstaller() ? "AppRunningErrorAddOn" : "AppRunningError";
        if (this.installRuntime && !RunningProcessChecker.checkDefaultRunningLauncher(string)) {
            throw new UserCanceledException();
        }
        try {
            FileInstaller.getInstance().setLogDir(installerContext.getDestinationFile(".install4j"));
            FileInstaller.getInstance().resetCurrentRebootRequired();
            try {
                ContentInstaller.getInstance().doStandardInstallation(installerContext, progressInterface, this);
            }
            catch (ReadIOException readIOException) {
                Logger.getInstance().error(this, "content corrupted.");
                Logger.getInstance().log(readIOException.getCause());
                boolean bl = false;
                return bl;
            }
            finally {
                if (this.isTriggerReboot() && this.isDelay() && FileInstaller.getInstance().isCurrentRebootRequired()) {
                    installerContext.triggerReboot(true);
                }
            }
            this.writeResponseFile(ContextImpl.getContextInt(installerContext));
            if (installerContext.isCancelling()) {
                throw new UserCanceledException();
            }
        }
        catch (IOException iOException) {
            installerContext.handleCriticalException(iOException);
            return false;
        }
        progressInterface.setDetailMessage("");
        return true;
    }

    public void rollback(InstallerContext installerContext) {
        super.rollback(installerContext);
        ContentInstaller.getInstance().rollback();
    }

    public void writeResponseFile(ContextInt contextInt) throws IOException {
        File file = contextInt.getRuntimeDirectory();
        if (file.exists() && InstallerConfig.isInstaller() && !Boolean.getBoolean("install4j.dontStoreInstallationLog")) {
            String string = "";
            if (InstallerConfig.getCurrentInstance().isAddOnInstaller()) {
                string = "." + InstallerConfig.getCurrentInstance().getProjectCrc();
            }
            File file2 = new File(file, "response.varfile" + string);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(InstallerVariables.getResponseFileContent(null));
            fileOutputStream.close();
            FileInstaller.getInstance().registerUninstallFile(file2);
        }
    }

    private void log() {
        List list = InstallerConfig.getCurrentInstance().getComponents();
        for (int i = 0; i < list.size(); ++i) {
            ComponentConfig componentConfig = (ComponentConfig)list.get(i);
            Logger.getInstance().info(this, "Component " + componentConfig);
        }
    }

    public static boolean hasRun() {
        return firstExecutedAction != null;
    }
}

