/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger;

import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRepresentation;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.support.RestParameter;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.support.MediaTypeUtils;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.smartbear.swagger.SwaggerImporter;
import com.smartbear.swagger.SwaggerUtils;
import io.swagger.inflector.examples.ExampleBuilder;
import io.swagger.inflector.examples.XmlExampleSerializer;
import io.swagger.inflector.examples.models.Example;
import io.swagger.inflector.examples.models.ObjectExample;
import io.swagger.inflector.processors.JsonNodeExampleSerializer;
import io.swagger.models.ComposedModel;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Swagger2Importer
implements SwaggerImporter {
    private static final String SAMPLE_GENERATION_FAILED_MESSAGE = "Failed to create the sample. The '%s' media type is incorrect.";
    private static Logger logger = LogManager.getLogger(Swagger2Importer.class);
    private static ObjectMapper yamlMapper = Yaml.mapper();
    private static ObjectMapper jsonMapper = Json.mapper();
    private final WsdlProject project;
    private final String defaultMediaType;
    private Swagger swagger;

    public Swagger2Importer(String defaultMediaType) {
        this(null, defaultMediaType);
    }

    public Swagger2Importer(WsdlProject project, String defaultMediaType) {
        this.project = project;
        this.defaultMediaType = defaultMediaType;
    }

    public Swagger2Importer(WsdlProject project) {
        this(project, "application/json");
    }

    @Override
    public RestService[] importSwagger(String url) {
        return this.importSwagger(url, null);
    }

    @Override
    public RestService[] importSwagger(String url, String apiKey, boolean disableLogger) {
        ArrayList<RestService> result = new ArrayList<RestService>();
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("swaggerUrl", url);
        if (url.startsWith("file:")) {
            try {
                url = new File(new URL(url).toURI()).getAbsolutePath();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        logger.info(String.format("Importing swagger %s", url));
        this.swagger = SwaggerUtils.getSwagger(url, null, true, disableLogger);
        if (this.swagger == null) {
            return new RestService[]{null};
        }
        if (this.swagger.getPaths() == null) {
            return new RestService[]{null};
        }
        RestService restService = this.createRestService(this.swagger, url);
        this.swagger.getPaths().forEach((key, value) -> this.importPath(restService, (String)key, (Path)value, (Map<String, Object>)context));
        result.add(restService);
        this.ensureEndpoint(restService, url);
        return result.toArray(new RestService[result.size()]);
    }

    @Override
    public RestService[] importSwagger(String url, String apiKey) {
        return this.importSwagger(url, apiKey, false);
    }

    private void ensureEndpoint(RestService restService, String url) {
        int ix;
        if (restService != null && restService.getEndpoints().length == 0 && (ix = url.indexOf("://")) > 0) {
            url = (ix = url.indexOf("/", ix + 3)) == -1 ? url : url.substring(0, ix);
            restService.addEndpoint(url);
        }
    }

    private RestResource importPath(RestService restService, String path, Path resource, Map<String, Object> context) {
        if (restService == null) {
            return null;
        }
        RestResource restResource = restService.addNewResource(path, path);
        List parameters = resource.getParameters();
        if (parameters != null) {
            parameters.forEach(parameter -> {
                if (parameter instanceof BodyParameter) {
                    resource.getOperations().forEach(operation -> {
                        boolean matched = false;
                        for (Parameter existingParameter : operation.getParameters()) {
                            if (parameter.getIn() == null || !parameter.getIn().equals(existingParameter.getIn()) || !parameter.getName().equals(existingParameter.getName())) continue;
                            matched = true;
                            break;
                        }
                        if (!matched) {
                            operation.getParameters().add(parameter);
                        }
                    });
                } else {
                    this.addParameter((Parameter)parameter, restResource);
                }
            });
        }
        if (resource.getGet() != null) {
            this.addOperation(restResource, resource.getGet(), RestRequestInterface.HttpMethod.GET);
        }
        if (resource.getPost() != null) {
            this.addOperation(restResource, resource.getPost(), RestRequestInterface.HttpMethod.POST);
        }
        if (resource.getPut() != null) {
            this.addOperation(restResource, resource.getPut(), RestRequestInterface.HttpMethod.PUT);
        }
        if (resource.getDelete() != null) {
            this.addOperation(restResource, resource.getDelete(), RestRequestInterface.HttpMethod.DELETE);
        }
        if (resource.getPatch() != null) {
            this.addOperation(restResource, resource.getPatch(), RestRequestInterface.HttpMethod.PATCH);
        }
        if (resource.getOptions() != null) {
            this.addOperation(restResource, resource.getOptions(), RestRequestInterface.HttpMethod.OPTIONS);
        }
        return restResource;
    }

    private void addOperation(RestResource resource, Operation operation, RestRequestInterface.HttpMethod httpMethod) {
        List consumes;
        List produces;
        Map responses;
        String operationName = operation.getOperationId();
        if (StringUtils.isNullOrEmpty(operationName)) {
            operationName = httpMethod.toString();
        }
        RestMethod method = resource.addNewMethod(operationName);
        method.setMethod(httpMethod);
        String description = StringUtils.emptyIfNull(operation.getDescription()) + System.getProperty("line.separator") + StringUtils.emptyIfNull(operation.getSummary());
        method.setDescription(description);
        List parameters = operation.getParameters();
        if (parameters != null) {
            parameters.forEach(parameter -> {
                if (parameter instanceof BodyParameter) {
                    this.addBodyParameter((BodyParameter)parameter, operation, method);
                } else if (parameter instanceof PathParameter) {
                    this.addParameter((Parameter)parameter, method.getResource());
                } else {
                    this.addParameter((Parameter)parameter, method);
                }
            });
        }
        if (method.getRequestList().isEmpty()) {
            method.addNewRequest("Request 1");
        }
        if ((responses = operation.getResponses()) != null) {
            responses.forEach((responseCode, response) -> this.addResponse((String)responseCode, (Response)response, operation, method));
        }
        if (method.getRepresentations(RestRepresentation.Type.RESPONSE, null) != null && method.getRepresentations(RestRepresentation.Type.RESPONSE, null).length == 0 && (produces = operation.getProduces()) != null) {
            produces.forEach(mediaType -> method.addNewRepresentation(RestRepresentation.Type.RESPONSE).setMediaType((String)mediaType));
        }
        if ((consumes = operation.getConsumes()) != null) {
            consumes.forEach(mediaType -> method.addNewRepresentation(RestRepresentation.Type.REQUEST).setMediaType((String)mediaType));
        }
    }

    private void addParameter(Parameter parameter, MutableTestPropertyHolder propertyHolder) {
        String parameterName = parameter.getName();
        if (StringUtils.isNullOrEmpty(parameterName) && parameter instanceof RefParameter) {
            parameterName = ((RefParameter)parameter).get$ref();
        }
        if (StringUtils.isNullOrEmpty(parameterName)) {
            logger.warn("Can not import property without name or ref [" + parameter.toString() + "]");
        } else {
            RestParameter restParameter = (RestParameter)((Object)propertyHolder.addProperty(parameterName));
            try {
                restParameter.setStyle(this.getParameterStyle(parameter));
            }
            catch (IllegalArgumentException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            restParameter.setDescription(parameter.getDescription());
            restParameter.setRequired(parameter.getRequired());
            if (parameter instanceof AbstractSerializableParameter && ((AbstractSerializableParameter)parameter).getDefaultValue() != null) {
                String defaultValue = ((AbstractSerializableParameter)parameter).getDefaultValue().toString();
                restParameter.setDefaultValue(defaultValue);
                restParameter.setValue(defaultValue);
            }
        }
    }

    private void addBodyParameter(BodyParameter bodyParameter, Operation operation, RestMethod method) {
        List consumes = operation.getConsumes();
        if (consumes == null || consumes.isEmpty()) {
            consumes = this.swagger.getConsumes();
        }
        if (consumes != null) {
            consumes.forEach(mediaType -> {
                RestRepresentation representation = method.addNewRepresentation(RestRepresentation.Type.REQUEST);
                representation.setMediaType((String)mediaType);
                RestRequest request = method.addNewRequest("Request " + (method.getRequestList().size() + 1));
                request.setMediaType((String)mediaType);
                Model bodyParameterModel = bodyParameter.getSchema();
                if (bodyParameterModel != null) {
                    Example output;
                    ObjectProperty objectProperty = new ObjectProperty(bodyParameterModel.getProperties());
                    if (bodyParameterModel instanceof RefModel) {
                        RefModel refModel = (RefModel)bodyParameterModel;
                        Model modelDefinition = (Model)this.swagger.getDefinitions().get(refModel.getSimpleRef());
                        if (modelDefinition instanceof ComposedModel) {
                            objectProperty = null;
                        } else if (modelDefinition != null) {
                            objectProperty = new ObjectProperty(modelDefinition.getProperties());
                            objectProperty.name(refModel.getSimpleRef());
                        }
                    }
                    Example example = output = objectProperty != null ? ExampleBuilder.fromProperty((Property)objectProperty, (Map)this.swagger.getDefinitions()) : ExampleBuilder.fromModel(null, (Model)bodyParameterModel, (Map)this.swagger.getDefinitions(), new HashSet());
                    if (output != null) {
                        request.setRequestContent(this.serializeExample((String)mediaType, output));
                    }
                }
            });
        }
    }

    private RestParamsPropertyHolder.ParameterStyle getParameterStyle(Parameter parameter) {
        String parameterLocation;
        String string = parameterLocation = parameter.getIn() == null ? "query" : parameter.getIn();
        if (parameter.getIn().equals("body")) {
            return null;
        }
        if (parameterLocation.equals("path")) {
            parameterLocation = "template";
        } else if (parameterLocation.equals("formData")) {
            parameterLocation = "query";
        }
        return RestParamsPropertyHolder.ParameterStyle.valueOf(parameterLocation.toUpperCase());
    }

    private void addResponse(String responseCode, Response response, Operation operation, RestMethod method) {
        List produces = operation.getProduces();
        if (produces == null || produces.isEmpty()) {
            operation.setProduces(this.swagger.getProduces());
            produces = operation.getProduces();
        }
        if (produces == null || produces.isEmpty()) {
            RestRepresentation representation = method.addNewRepresentation(RestRepresentation.Type.RESPONSE);
            ArrayList<String> statusList = new ArrayList<String>();
            if (!responseCode.equals("default")) {
                statusList.add(responseCode);
            }
            representation.setStatus(statusList);
            representation.setMediaType(this.defaultMediaType);
            Map responseExamples = response.getExamples();
            if (responseExamples != null && !responseExamples.isEmpty()) {
                representation.setMediaType((String)responseExamples.keySet().iterator().next());
            }
        } else {
            produces.forEach(mediaType -> {
                RestRepresentation representation = method.addNewRepresentation(RestRepresentation.Type.RESPONSE);
                representation.setMediaType((String)mediaType);
                ArrayList<String> statusList = new ArrayList<String>();
                if (!responseCode.equals("default")) {
                    statusList.add(responseCode);
                }
                representation.setStatus(statusList);
            });
        }
    }

    private String serializeExample(String mediaType, Example output) {
        String sampleValue = null;
        ObjectMapper mapper = null;
        String subtype = "";
        try {
            subtype = MediaTypeUtils.getSubtype(mediaType);
            String suffix = MediaTypeUtils.getSuffix(mediaType);
            if (StringUtils.hasContent(suffix)) {
                subtype = suffix;
            }
        }
        catch (IllegalArgumentException e) {
            logger.warn(String.format(SAMPLE_GENERATION_FAILED_MESSAGE, mediaType));
        }
        switch (subtype.toLowerCase()) {
            case "xml": {
                sampleValue = XmlUtils.prettyPrintXml(new XmlExampleSerializer().serialize(output));
                if (XmlUtils.seemsToBeXml(sampleValue)) break;
                return "";
            }
            case "yaml": {
                mapper = yamlMapper;
                break;
            }
            case "json": {
                mapper = jsonMapper;
                break;
            }
            case "plain": {
                if (output instanceof ObjectExample) break;
                sampleValue = output.asString();
            }
        }
        if (mapper != null) {
            try {
                sampleValue = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)output);
            }
            catch (JsonProcessingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return sampleValue;
    }

    private RestService createRestService(Swagger swagger, String url) {
        String name;
        Info swaggerInfo = swagger.getInfo();
        String string = name = swaggerInfo != null && swaggerInfo.getTitle() != null ? swaggerInfo.getTitle() : null;
        if (name == null) {
            if (url.toLowerCase().startsWith("http://") || url.toLowerCase().startsWith("https://")) {
                try {
                    name = new URL(url).getHost();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            } else {
                int ix = url.lastIndexOf(47);
                name = ix == -1 || ix == url.length() - 1 ? url : url.substring(ix + 1);
            }
        }
        RestService restService = (RestService)this.project.addNewInterface(name, "rest");
        String expandedUrl = PathUtils.expandPath(url, this.project);
        if (new File(expandedUrl).exists()) {
            try {
                expandedUrl = new File(expandedUrl).toURI().toURL().toString();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        if (swaggerInfo != null) {
            restService.setDescription(swaggerInfo.getDescription());
        }
        if (!StringUtils.isNullOrEmpty(swagger.getHost())) {
            List schemes = swagger.getSchemes();
            if (schemes != null) {
                schemes.forEach(currentSchema -> {
                    String scheme = currentSchema.toValue().toLowerCase();
                    if (scheme.startsWith("http")) {
                        restService.addEndpoint(scheme + "://" + swagger.getHost());
                    }
                });
            }
            if (restService.getEndpoints().length == 0) {
                if (url.toLowerCase().startsWith("http") && url.indexOf(58) > 0) {
                    restService.addEndpoint(url.substring(0, url.indexOf(58)).toLowerCase() + "://" + swagger.getHost());
                } else {
                    restService.addEndpoint("http://" + swagger.getHost());
                }
            }
        }
        if (swagger.getBasePath() != null) {
            restService.setBasePath(swagger.getBasePath());
            if (restService.getBasePath().endsWith("/")) {
                restService.setBasePath(restService.getBasePath().substring(0, restService.getBasePath().length() - 1));
            }
        }
        return restService;
    }

    public WsdlProject getProject() {
        return this.project;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    static {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer((JsonSerializer)new JsonNodeExampleSerializer());
        yamlMapper.registerModule((Module)simpleModule);
        jsonMapper.registerModule((Module)simpleModule);
    }
}

