/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRepresentation;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.smartbear.swagger.ExportSwaggerAction;
import com.smartbear.swagger.SwaggerExporter;
import io.swagger.models.Info;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class Swagger2Exporter
implements SwaggerExporter {
    private final WsdlProject project;
    private Swagger swagger = null;

    public Swagger2Exporter(WsdlProject project) {
        this.project = project;
    }

    @Override
    public String exportToFileSystem(String fileName, String apiVersion, String format, RestService[] services, String basePath) {
        if (!ExportSwaggerAction.shouldOverwriteFileIfExists(fileName, null)) {
            return null;
        }
        this.swagger = new Swagger();
        this.swagger.setBasePath(basePath);
        Info info = new Info();
        this.swagger.setInfo(info);
        info.setVersion(apiVersion);
        info.setTitle(services[0].getName());
        for (RestService service : services) {
            for (RestResource resource : service.getAllResources()) {
                Path p = new Path();
                for (RestMethod restMethod : resource.getRestMethodList()) {
                    Operation operation = new Operation();
                    operation.setOperationId(restMethod.getResource().getName());
                    for (RestRepresentation representation : restMethod.getRepresentations()) {
                        RestRepresentation.Type type = representation.getType();
                        if (type == RestRepresentation.Type.RESPONSE || type == RestRepresentation.Type.FAULT) {
                            List<?> statuses = representation.getStatus();
                            if (statuses == null) continue;
                            for (Object status : statuses) {
                                operation.addResponse(String.valueOf(status), new Response());
                            }
                            continue;
                        }
                        if (type != RestRepresentation.Type.REQUEST || representation.getMediaType() == null) continue;
                        operation.addConsumes(representation.getMediaType());
                    }
                    Map responses = operation.getResponses();
                    if (responses != null && responses.isEmpty()) {
                        operation.addResponse("200", new Response());
                    }
                    RestRequestInterface.HttpMethod method = restMethod.getMethod();
                    p.set(method.name().toLowerCase(), operation);
                    this.addParametersToOperation(restMethod.getOverlayParams(), operation);
                    if (method != RestRequestInterface.HttpMethod.POST && method != RestRequestInterface.HttpMethod.PUT) continue;
                    BodyParameter param = new BodyParameter();
                    operation.addParameter((Parameter)param);
                    param.setName("body");
                    param.setDescription("Request body");
                    param.setRequired(true);
                }
                this.swagger.path(resource.getFullPath(), p);
            }
        }
        ObjectMapper mapper = format.equals("yaml") ? Yaml.mapper() : Json.mapper();
        try {
            mapper.writeValue((Writer)new FileWriter(fileName), (Object)this.swagger);
        }
        catch (IOException e) {
            SoapUI.logError(e);
        }
        return fileName;
    }

    @Override
    public String getOasVersion() {
        return this.swagger == null ? null : this.swagger.getSwagger();
    }

    private void addParametersToOperation(RestParamsPropertyHolder params, Operation op) {
        block25: for (String name : params.getPropertyNames()) {
            RestParamProperty param = params.getProperty(name);
            if (this.operationHasParameter(op, name)) continue;
            HeaderParameter p = null;
            switch (param.getStyle()) {
                case HEADER: {
                    p = new HeaderParameter();
                    break;
                }
                case QUERY: {
                    p = new QueryParameter();
                    break;
                }
                case TEMPLATE: {
                    p = new PathParameter();
                }
            }
            if (p == null) continue;
            op.addParameter((Parameter)p);
            p.setName(param.getName());
            p.setRequired(p instanceof PathParameter || param.getRequired());
            p.setDescription(param.getDescription());
            switch (param.getType().getLocalPart()) {
                case "byte": {
                    p.setType("byte");
                    continue block25;
                }
                case "dateTime": {
                    p.setType("Date");
                    continue block25;
                }
                case "float": {
                    p.setType("float");
                    continue block25;
                }
                case "double": {
                    p.setType("double");
                    continue block25;
                }
                case "long": {
                    p.setType("long");
                    continue block25;
                }
                case "short": 
                case "int": 
                case "integer": {
                    p.setType("int");
                    continue block25;
                }
                case "boolean": {
                    p.setType("boolean");
                    continue block25;
                }
                default: {
                    p.setType("string");
                }
            }
        }
    }

    boolean operationHasParameter(Operation operation, String name) {
        if (operation != null) {
            for (Parameter parameter : operation.getParameters()) {
                if (!parameter.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }
}

