/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger;

import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormOptionsField;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.smartbear.analytics.Analytics;
import com.smartbear.swagger.Swagger2Exporter;
import java.io.File;
import java.util.List;

public class ExportSwaggerAction
extends AbstractSoapUIAction<WsdlProject> {
    private static final String INFO_MESSAGE_NOTHING_CREATED = "Failed to create the Swagger definition file.";
    private static final String INFO_MESSAGE_LISTING_HAS_BEEN_CREATED = "The Swagger definition has been created at [%s]";
    private static final String CONFIRM_DIALOG_QUESTION = "%s already exists.\\nDo you want to replace it?";
    private static final String CONFIRM_DIALOG_TITLE = "Export Swagger/OpenAPI Definition";
    public static final String SWAGGER_EXTENSION = ".swagger";
    public static final String JSON_EXTENSION = ".json";
    public static final String YAML_EXTENSION = ".yaml";
    private static final String BASE_PATH = Form.class.getName() + "Base Path";
    private static final String TARGET_PATH = Form.class.getName() + "Target File";
    private static final String FORMAT = Form.class.getName() + "Format";
    private static final String VERSION = Form.class.getName() + "API Version";
    private static final String SWAGGER_VERSION = Form.class.getName() + "Swagger Version";
    private static final String SWAGGER_2_0 = "Swagger 2.0";
    private static final String OPEN_API_3_0 = "OpenAPI 3.0";
    private XFormDialog dialog;

    public ExportSwaggerAction() {
        super(CONFIRM_DIALOG_TITLE, "Creates a Swagger/OpenAPI definition for selected REST APIs");
    }

    @Override
    public void perform(WsdlProject project, Object param) {
        if (project.getInterfaces("rest").isEmpty()) {
            UISupport.showErrorMessage("Project is missing REST APIs");
            return;
        }
        XmlBeansSettingsImpl settings = project.getSettings();
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.setValue("Format", settings.getString(FORMAT, "json"));
            this.dialog.setValue("API Version", settings.getString(VERSION, SWAGGER_2_0));
            this.dialog.setValue("Base Path", settings.getString(BASE_PATH, ""));
            this.dialog.setValue("Swagger Version", SWAGGER_2_0);
        }
        XFormOptionsField apis = (XFormOptionsField)this.dialog.getFormField("APIs");
        List<AbstractInterface<?>> restServices = project.getInterfaces("rest");
        apis.setOptions(ModelSupport.getNames(restServices));
        while (this.dialog.show()) {
            try {
                Object[] options = ((XFormOptionsField)this.dialog.getFormField("APIs")).getSelectedOptions();
                if (options.length == 0) {
                    throw new Exception("You must select at least one REST API ");
                }
                RestService[] services = new RestService[options.length];
                for (int c = 0; c < options.length; ++c) {
                    services[c] = (RestService)project.getInterfaceByName(String.valueOf(options[c]));
                    if (services[c].getEndpoints().length != 0) continue;
                    throw new Exception("Selected APIs must contain at least one endpoint");
                }
                if (services.length == 0) {
                    throw new Exception("You must select at least one REST API to export");
                }
                String swaggerVersion = this.dialog.getValue("Swagger Version");
                String format = this.dialog.getValue("Format");
                String version = this.dialog.getValue("API Version");
                if (StringUtils.isNullOrEmpty(version)) {
                    version = "1.0";
                }
                Swagger2Exporter exporter = null;
                String target = null;
                if (swaggerVersion.equals(SWAGGER_2_0)) {
                    exporter = new Swagger2Exporter(project);
                    target = this.dialog.getValue("Target File");
                }
                if (exporter == null) {
                    return;
                }
                String path = exporter.exportToFileSystem(target, version, format, services, this.dialog.getValue("Base Path"));
                if (path == null) {
                    UISupport.showInfoMessage(INFO_MESSAGE_NOTHING_CREATED);
                } else {
                    String message = String.format(INFO_MESSAGE_LISTING_HAS_BEEN_CREATED, path);
                    UISupport.showInfoMessage(message);
                }
                settings.setString(BASE_PATH, this.dialog.getValue("Base Path"));
                settings.setString(TARGET_PATH, this.dialog.getValue("Target File"));
                settings.setString(FORMAT, this.dialog.getValue("Format"));
                settings.setString(VERSION, this.dialog.getValue("API Version"));
                settings.setString(SWAGGER_VERSION, this.dialog.getValue("Swagger Version"));
                Analytics.trackAction((String)"ExportSwagger", (String[])new String[]{"Type", "Swagger", "ExportedDefinitionType", "Swagger", "Version", this.dialog.getValue("Swagger Version"), "Format", this.dialog.getValue("Format")});
                break;
            }
            catch (Exception ex) {
                UISupport.showErrorMessage(ex);
            }
        }
    }

    public static boolean shouldOverwriteFileIfExists(String fileName, String folderName) {
        File apiFile = new File(fileName);
        if (folderName != null) {
            apiFile = new File(folderName + File.separatorChar + fileName);
        }
        if (apiFile.exists()) {
            return UISupport.confirm(String.format(CONFIRM_DIALOG_QUESTION, apiFile.getName()), CONFIRM_DIALOG_TITLE);
        }
        return true;
    }

    @AForm(name="Export Swagger Definition", description="Creates a Swagger definition for selected REST APIs in this project")
    public static interface Form {
        @AField(name="APIs", description="Select which REST APIs to include in the Swagger definition", type=AField.AFieldType.MULTILIST)
        public static final String APIS = "APIs";
        @AField(name="Target File", description="File to save the Swagger/OpenAPI definition", type=AField.AFieldType.FILE)
        public static final String FILE = "Target File";
        @AField(name="API Version", description="API Version", type=AField.AFieldType.STRING)
        public static final String VERSION = "API Version";
        @AField(name="Base Path", description="Base Path that the Swagger definition will be hosted on", type=AField.AFieldType.STRING)
        public static final String BASEPATH = "Base Path";
        @AField(name="Swagger Version", description="Select Swagger version", type=AField.AFieldType.RADIOGROUP, values={"Swagger 2.0"})
        public static final String SWAGGER_VERSION = "Swagger Version";
        @AField(name="Format", description="Select Swagger format", type=AField.AFieldType.RADIOGROUP, values={"json", "yaml"})
        public static final String FORMAT = "Format";
    }
}

