/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.integrations.swaggerhub.engine;

import com.smartbear.integrations.swaggerhub.engine.ApiDescriptor;
import groovy.json.JsonSlurper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApisJsonImporter {
    static final Pattern OWNER_PATTERN = Pattern.compile("api\\.swaggerhub\\.com\\/apis\\/(.*?)\\/");

    public List<ApiDescriptor> importApis(String json) {
        Object apisJson = new JsonSlurper().parseText(json);
        ArrayList<ApiDescriptor> result = new ArrayList<ApiDescriptor>();
        if (!(apisJson instanceof Map)) {
            return result;
        }
        Map apisJsomMap = (Map)apisJson;
        Object apis = apisJsomMap.get("apis");
        if (!(apis instanceof List)) {
            return result;
        }
        List listApis = (List)apis;
        for (Object api : listApis) {
            if (!(api instanceof Map)) continue;
            Map apiMap = (Map)api;
            ApiDescriptor descriptor = new ApiDescriptor();
            descriptor.name = (String)apiMap.get("name");
            descriptor.description = (String)apiMap.get("description");
            Object properties = apiMap.get("properties");
            List listProperties = (List)properties;
            for (Object property : listProperties) {
                Map mapProperty = (Map)property;
                String type = (String)mapProperty.get("type");
                String value = (String)mapProperty.get("value");
                if ("Swagger".equals(type)) {
                    String url;
                    descriptor.swaggerUrl = url = (String)mapProperty.get("url");
                    Matcher matcher = OWNER_PATTERN.matcher(url);
                    if (!matcher.find()) continue;
                    descriptor.owner = matcher.group(1);
                    continue;
                }
                if ("X-Versions".equals(type)) {
                    descriptor.versions = value.split(",");
                    continue;
                }
                if ("X-Private".equals(type)) {
                    descriptor.isPrivate = Boolean.parseBoolean(value);
                    continue;
                }
                if ("X-OASVersion".equals(type)) {
                    descriptor.oasVersion = value;
                    continue;
                }
                if ("X-Published".equals(type)) {
                    descriptor.isPublished = Boolean.parseBoolean(value);
                    continue;
                }
                if (!"X-Version".equals(type)) continue;
                descriptor.defaultVersion = value;
            }
            result.add(descriptor);
        }
        return result;
    }
}

