/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.integrations.swaggerhub.component;

import com.eviware.soapui.support.StringUtils;
import com.smartbear.integrations.swaggerhub.engine.ApiDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.scene.control.ComboBox;

public class SwaggerHubAPITableModel {
    private StringProperty name;
    private StringProperty descr;
    private StringProperty oasVersion;
    private ObjectProperty versions;
    private ApiDescriptor descriptor;
    private StringProperty visibility;
    private StringProperty owner;
    private ComboBox<String> versionCombo;

    public SwaggerHubAPITableModel(ApiDescriptor descriptor) {
        this.name = new SimpleStringProperty(descriptor.name);
        this.descr = new SimpleStringProperty(descriptor.description);
        this.oasVersion = new SimpleStringProperty(descriptor.oasVersion);
        this.visibility = descriptor.isPrivate ? new SimpleStringProperty("Private") : new SimpleStringProperty("Public");
        this.versionCombo = new ComboBox(FXCollections.observableArrayList(this.formatVersion(descriptor.versions)));
        if (StringUtils.hasContent(descriptor.defaultVersion)) {
            for (String version : this.versionCombo.getItems()) {
                if (!version.equals(descriptor.defaultVersion)) continue;
                this.versionCombo.getSelectionModel().select((Object)version);
                break;
            }
        } else {
            this.versionCombo.getSelectionModel().selectFirst();
        }
        this.versions = new SimpleObjectProperty(this.versionCombo);
        this.owner = StringUtils.hasContent(descriptor.owner) ? new SimpleStringProperty(descriptor.owner) : new SimpleStringProperty("Unknown");
        this.descriptor = descriptor;
    }

    public String getName() {
        return (String)this.name.get();
    }

    public String getDescr() {
        return (String)this.descr.get();
    }

    public String getOasVersion() {
        return (String)this.oasVersion.get();
    }

    public Object getVersions() {
        return this.versions.get();
    }

    public ApiDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ComboBox getVersionCombo() {
        return this.versionCombo;
    }

    private List<String> formatVersion(String[] versions) {
        ArrayList<String> temp = new ArrayList<String>(Arrays.asList(versions));
        ArrayList<String> result = new ArrayList<String>();
        for (String version : temp) {
            if (version.startsWith("*-")) {
                result.add(version.substring(2).trim());
                continue;
            }
            if (version.startsWith("-") || version.startsWith("*")) {
                result.add(version.substring(1).trim());
                continue;
            }
            result.add(version);
        }
        return result;
    }

    public String getVisibility() {
        return (String)this.visibility.get();
    }

    public String getOwner() {
        return (String)this.owner.get();
    }
}

