/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.AbstractAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class SaveXmlTextAreaAction
extends AbstractAction {
    private final RSyntaxTextArea textArea;
    private String dialogTitle;
    private static final Logger log = LogManager.getLogger(SaveXmlTextAreaAction.class);

    public SaveXmlTextAreaAction(RSyntaxTextArea editArea, String dialogTitle) {
        super("Save as..");
        this.textArea = editArea;
        this.dialogTitle = dialogTitle;
        if (UISupport.isMac()) {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu S"));
        } else {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("ctrl S"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        File file = UISupport.getFileDialogs().saveAs(this, this.dialogTitle, ".xml", "XML Files (*.xml)", null);
        if (file == null) {
            return;
        }
        OutputStreamWriter writer = null;
        try {
            try {
                XmlObject xml = XmlUtils.createXmlObject(this.textArea.getText());
                xml.save(file);
            }
            catch (XmlException e1) {
                writer = new FileWriter(file);
                writer.write(this.textArea.getText());
                writer.close();
            }
            log.info("XML written to [" + file.getAbsolutePath() + "]");
        }
        catch (IOException e1) {
            UISupport.showErrorMessage("Error saving xml to file: " + e1.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e1) {
                    SoapUI.logError(e1);
                }
            }
        }
    }
}

