/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml.actions;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class FormatXmlAction
extends AbstractAction {
    private static final Logger log = LogManager.getLogger(FormatXmlAction.class);
    private final RSyntaxTextArea textArea;

    public FormatXmlAction(RSyntaxTextArea editArea) {
        this(editArea, "Format XML");
    }

    public FormatXmlAction(RSyntaxTextArea editArea, String title) {
        super(title);
        this.putValue("SmallIcon", UISupport.createImageIcon("/format_request.gif"));
        this.putValue("ShortDescription", "Pretty-prints the xml");
        if (UISupport.isMac()) {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("shift meta F"));
        } else {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt F"));
        }
        this.textArea = editArea;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.textArea.setText(XmlUtils.prettyPrintXml(this.textArea.getText()));
            this.textArea.setCaretPosition(0);
        }
        catch (Exception e1) {
            log.error(e1.getMessage());
        }
    }
}

