/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;

public class JXButtonPanel
extends JPanel {
    private boolean isCyclic;
    private boolean isGroupSelectionFollowFocus;

    public JXButtonPanel() {
        this.init();
    }

    public JXButtonPanel(LayoutManager layout) {
        super(layout);
        this.init();
    }

    public JXButtonPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.init();
    }

    public JXButtonPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.init();
    }

    private void init() {
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new JXButtonPanelFocusTraversalPolicy());
        ActionHandler actionHandler = new ActionHandler();
        this.registerKeyboardAction(actionHandler, "moveSelectionForward", KeyStroke.getKeyStroke(39, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionForward", KeyStroke.getKeyStroke(40, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionBackward", KeyStroke.getKeyStroke(37, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionBackward", KeyStroke.getKeyStroke(38, 0), 1);
        this.setGroupSelectionFollowFocus(true);
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void setCyclic(boolean isCyclic) {
        this.isCyclic = isCyclic;
    }

    public boolean isGroupSelectionFollowFocus() {
        return this.isGroupSelectionFollowFocus;
    }

    public void setGroupSelectionFollowFocus(boolean groupSelectionFollowFocus) {
        this.isGroupSelectionFollowFocus = groupSelectionFollowFocus;
    }

    private static ButtonGroup getButtonGroup(AbstractButton button) {
        ButtonModel model = button.getModel();
        if (model instanceof DefaultButtonModel) {
            return ((DefaultButtonModel)model).getGroup();
        }
        return null;
    }

    private class ActionHandler
    implements ActionListener {
        private static final String FORWARD = "moveSelectionForward";
        private static final String BACKWARD = "moveSelectionBackward";

        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FocusTraversalPolicy ftp = JXButtonPanel.this.getFocusTraversalPolicy();
            if (ftp instanceof JXButtonPanelFocusTraversalPolicy) {
                Component next;
                JXButtonPanelFocusTraversalPolicy xftp = (JXButtonPanelFocusTraversalPolicy)ftp;
                String actionCommand = e.getActionCommand();
                Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                xftp.setAlternativeFocusMode(true);
                if (FORWARD.equals(actionCommand)) {
                    next = xftp.getComponentAfter(JXButtonPanel.this, fo);
                } else if (BACKWARD.equals(actionCommand)) {
                    next = xftp.getComponentBefore(JXButtonPanel.this, fo);
                } else {
                    throw new AssertionError((Object)("Unexpected action command: " + actionCommand));
                }
                xftp.setAlternativeFocusMode(false);
                if (fo instanceof AbstractButton) {
                    AbstractButton b = (AbstractButton)fo;
                    b.getModel().setPressed(false);
                }
                if (next != null && fo instanceof AbstractButton && next instanceof AbstractButton) {
                    AbstractButton nextButton;
                    ButtonGroup group = JXButtonPanel.getButtonGroup((AbstractButton)fo);
                    if (group != JXButtonPanel.getButtonGroup(nextButton = (AbstractButton)next)) {
                        return;
                    }
                    if (JXButtonPanel.this.isGroupSelectionFollowFocus() && group != null && group.getSelection() != null && !nextButton.isSelected()) {
                        nextButton.setSelected(true);
                    }
                    next.requestFocusInWindow();
                }
            }
        }
    }

    private class JXButtonPanelFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private boolean isAlternativeFocusMode;

        private JXButtonPanelFocusTraversalPolicy() {
        }

        public boolean isAlternativeFocusMode() {
            return this.isAlternativeFocusMode;
        }

        public void setAlternativeFocusMode(boolean alternativeFocusMode) {
            this.isAlternativeFocusMode = alternativeFocusMode;
        }

        @Override
        protected boolean accept(Component c) {
            AbstractButton button;
            ButtonGroup group;
            if (!this.isAlternativeFocusMode() && c instanceof AbstractButton && (group = JXButtonPanel.getButtonGroup(button = (AbstractButton)c)) != null && group.getSelection() != null && !button.isSelected()) {
                return false;
            }
            return super.accept(c);
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            Component componentAfter = super.getComponentAfter(aContainer, aComponent);
            if (!this.isAlternativeFocusMode()) {
                return componentAfter;
            }
            if (JXButtonPanel.this.isCyclic()) {
                return componentAfter == null ? this.getFirstComponent(aContainer) : componentAfter;
            }
            if (aComponent == this.getLastComponent(aContainer)) {
                return aComponent;
            }
            return componentAfter;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            Component componentBefore = super.getComponentBefore(aContainer, aComponent);
            if (!this.isAlternativeFocusMode()) {
                return componentBefore;
            }
            if (JXButtonPanel.this.isCyclic()) {
                return componentBefore == null ? this.getLastComponent(aContainer) : componentBefore;
            }
            if (aComponent == this.getFirstComponent(aContainer)) {
                return aComponent;
            }
            return componentBefore;
        }
    }
}

