/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.swing;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionSupport;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public abstract class AbstractTableMouseListener
extends MouseAdapter {
    private boolean enablePopup;
    private JPopupMenu menu;

    protected abstract ActionList getActionsForRow(JTable var1, int var2);

    public AbstractTableMouseListener() {
        this(true);
    }

    public AbstractTableMouseListener(boolean enablePopup) {
        this.enablePopup = enablePopup;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        JTable list = (JTable)e.getSource();
        int selectedIndex = list.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        ActionList actions = this.getActionsForRow(list, selectedIndex);
        if (actions != null) {
            actions.performDefaultAction(new ActionEvent(this, 0, null));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void showPopup(MouseEvent e) {
        ActionList actions;
        if (!this.enablePopup) {
            return;
        }
        JTable list = (JTable)e.getSource();
        int row = list.rowAtPoint(e.getPoint());
        if (row == -1) {
            return;
        }
        if (list.getSelectedRow() != row) {
            list.setRowSelectionInterval(row, row);
        }
        if ((actions = this.getActionsForRow(list, row)) == null || actions.getActionCount() == 0) {
            return;
        }
        JPopupMenu popup = this.menu == null ? ActionSupport.buildPopup(actions) : this.menu;
        UISupport.showPopup(popup, list, e.getPoint());
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.menu = menu;
    }
}

