/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.propertyexpansion;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionImpl;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.tree.nodes.PropertyModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.propertyexpansion.PropertyExpansionTarget;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.text.JTextComponent;

public final class PropertyExpansionDropTarget
implements DropTargetListener {
    private final PropertyExpansionTarget target;

    public PropertyExpansionDropTarget(PropertyExpansionTarget target) {
        this.target = target;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (!this.isAcceptable(dtde.getTransferable())) {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dtde) {
        if (dtde.getDropTargetContext().getComponent() instanceof JTextComponent) {
            ((JTextComponent)dtde.getDropTargetContext().getComponent()).getCaret().setVisible(false);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        JTextComponent textField;
        int pos;
        if (!this.isAcceptable(dtde.getTransferable())) {
            dtde.rejectDrag();
        }
        if (dtde.getDropTargetContext().getComponent() instanceof JTextComponent && (pos = (textField = (JTextComponent)dtde.getDropTargetContext().getComponent()).viewToModel(dtde.getLocation())) != -1) {
            textField.setCaretPosition(pos);
            textField.getCaret().setVisible(true);
        }
        dtde.acceptDrag(dtde.getDropAction());
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (!this.isAcceptable(dtde.getTransferable())) {
            dtde.rejectDrop();
        } else {
            try {
                Transferable transferable = dtde.getTransferable();
                Object transferData = transferable.getTransferData(transferable.getTransferDataFlavors()[0]);
                if (transferData instanceof PropertyModelItem) {
                    dtde.acceptDrop(dtde.getDropAction());
                    PropertyModelItem modelItem = (PropertyModelItem)transferData;
                    String xpath = modelItem.getXPath();
                    if (xpath == null && XmlUtils.seemsToBeXml(modelItem.getProperty().getValue()) && (xpath = UISupport.selectXPath("Create PropertyExpansion", "Select XPath below", modelItem.getProperty().getValue(), null)) != null) {
                        xpath = PropertyExpansionUtils.shortenXPathForPropertyExpansion(xpath, modelItem.getProperty().getValue());
                    }
                    this.target.insertPropertyExpansion(new PropertyExpansionImpl(modelItem.getProperty(), xpath), dtde.getLocation());
                    dtde.dropComplete(true);
                }
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
            if (dtde.getDropTargetContext().getComponent() instanceof JTextComponent) {
                ((JTextComponent)dtde.getDropTargetContext().getComponent()).getCaret().setVisible(false);
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public boolean isAcceptable(Transferable transferable) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor flavor = flavors[i];
            if (!flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
            try {
                Object modelItem = transferable.getTransferData(flavor);
                if (!(modelItem instanceof PropertyModelItem)) continue;
                return PropertyExpansionUtils.canExpandProperty(this.target.getContextModelItem(), ((PropertyModelItem)modelItem).getProperty());
            }
            catch (Exception ex) {
                SoapUI.logError(ex);
            }
        }
        return false;
    }
}

