/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.log;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.settings.UISettings;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;

public final class LogDisablingTestMonitorListener
extends TestMonitorListenerAdapter {
    private Set<LoadTestRunner> loadTestRunners = new HashSet<LoadTestRunner>();
    private Set<SecurityTestRunner> securityTestRunners = new HashSet<SecurityTestRunner>();

    @Override
    public void loadTestStarted(LoadTestRunner runner) {
        if (this.loadTestRunners.isEmpty()) {
            LogManager.getLogger(SoapUI.class).info("Disabling logs during loadtests");
            Configurator.setLevel((String)"org.apache.http.wire", (Level)Level.OFF);
            if (!SoapUI.getSettings().getBoolean(UISettings.DONT_DISABLE_GROOVY_LOG)) {
                Configurator.setLevel((String)"groovy.log", (Level)Level.OFF);
            }
        }
        this.loadTestRunners.add(runner);
    }

    @Override
    public void loadTestFinished(LoadTestRunner runner) {
        this.loadTestRunners.remove(runner);
        if (this.loadTestRunners.isEmpty()) {
            Configurator.setLevel((String)"org.apache.http.wire", (Level)Level.DEBUG);
            Configurator.setLevel((String)"groovy.log", (Level)Level.DEBUG);
            LogManager.getLogger(SoapUI.class).info("Enabled logs after loadtests");
        }
    }

    @Override
    public void securityTestStarted(SecurityTestRunner runner) {
        if (this.securityTestRunners.isEmpty()) {
            // empty if block
        }
        this.securityTestRunners.add(runner);
    }

    @Override
    public void securityTestFinished(SecurityTestRunner runner) {
        this.securityTestRunners.remove(runner);
        if (this.securityTestRunners.isEmpty()) {
            // empty if block
        }
    }
}

