/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.log;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.UISupport;
import com.smartbear.soapui.core.Logging;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.commons.collections.list.TreeList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class JLogList
extends JPanel {
    private static final String INTERNAL_LOG_NAME = "InternalLog";
    private long maxRows = 1000L;
    private JList logList;
    private final LogListModel model;
    private List<Logger> loggers = new ArrayList<Logger>();
    private InternalLogAppender internalLogAppender = new InternalLogAppender();
    private boolean tailing = true;
    private BlockingQueue<Object> linesToAdd = new LinkedBlockingQueue<Object>();
    private JCheckBoxMenuItem enableMenuItem;
    private final String title;

    public JLogList(String title) {
        super(new BorderLayout());
        this.title = title;
        this.model = new LogListModel();
        this.logList = new JList(this.model);
        this.logList.setToolTipText(title);
        this.logList.setCellRenderer(new LogAreaCellRenderer());
        this.logList.setPrototypeCellValue("Testing 123");
        this.logList.setFixedCellWidth(-1);
        JPopupMenu listPopup = new JPopupMenu();
        listPopup.add(new ClearAction());
        EnableAction enableAction = new EnableAction();
        this.enableMenuItem = new JCheckBoxMenuItem(enableAction);
        this.enableMenuItem.setSelected(true);
        listPopup.add(this.enableMenuItem);
        listPopup.addSeparator();
        listPopup.add(new CopyAction());
        listPopup.add(new SetMaxRowsAction());
        listPopup.addSeparator();
        listPopup.add(new ExportToFileAction());
        this.logList.setComponentPopupMenu(listPopup);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JScrollPane scrollPane = new JScrollPane(this.logList);
        UISupport.addPreviewCorner(scrollPane, true);
        this.add((Component)scrollPane, "Center");
        SimpleAttributeSet requestAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(requestAttributes, Color.BLUE);
        SimpleAttributeSet responseAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(responseAttributes, Color.GREEN);
        try {
            this.maxRows = Long.parseLong(SoapUI.getSettings().getString("JLogList#" + title, "1000"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void clear() {
        this.model.clear();
    }

    public JList getLogList() {
        return this.logList;
    }

    public long getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(long maxRows) {
        this.maxRows = maxRows;
    }

    public void addLine(Object line) {
        if (!this.isEnabled()) {
            return;
        }
        if (line instanceof LogEvent) {
            LogEvent ev = (LogEvent)line;
            LoggingEventWrapper eventWrapper = new LoggingEventWrapper(ev);
            this.appendTimeStampBeforeRequestOrResponseLine(eventWrapper);
            this.linesToAdd.add(eventWrapper);
            if (ev.getThrown() != null) {
                Throwable t = ev.getThrown();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                StringTokenizer st = new StringTokenizer(sw.toString(), "\r\n");
                while (st.hasMoreElements()) {
                    this.linesToAdd.add("   " + st.nextElement());
                }
            }
        } else {
            this.linesToAdd.add(line);
        }
        this.model.ensureUpdateIsStarted();
    }

    private void appendTimeStampBeforeRequestOrResponseLine(LoggingEventWrapper eventWrapper) {
        if (eventWrapper.loggingEvent.getLoggerName().equals("org.apache.http.wire")) {
            if (Logging.HTTP_CLIENT_WIRE_LOG_TIMESTAMP_MARKER_OUTGOING.equals((Object)eventWrapper.loggingEvent.getMarker())) {
                this.appendMessageSeparator();
                this.linesToAdd.add(JLogList.formatTimestamp(eventWrapper.loggingEvent.getTimeMillis()) + ": " + eventWrapper.getLevel() + ": http-outgoing >> ");
            } else if (Logging.HTTP_CLIENT_WIRE_LOG_TIMESTAMP_MARKER_INCOMING.equals((Object)eventWrapper.loggingEvent.getMarker())) {
                this.appendMessageSeparator();
                this.linesToAdd.add(JLogList.formatTimestamp(eventWrapper.loggingEvent.getTimeMillis()) + ": " + eventWrapper.getLevel() + ": http-incoming << ");
            }
        }
    }

    private void appendMessageSeparator() {
        if (this.model.getSize() != 0 || this.linesToAdd.size() != 0) {
            this.linesToAdd.add("");
        }
    }

    private static String formatTimestamp(long timeStamp) {
        return String.valueOf(new Date(timeStamp));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.logList.setEnabled(enabled);
        this.enableMenuItem.setSelected(enabled);
    }

    public void addLogger(String loggerName, boolean addAppender) {
        Logger logger = LogManager.getLogger((String)loggerName);
        if (addAppender) {
            Logging.addAppender(loggerName, (Appender)this.internalLogAppender);
        }
        this.loggers.add(logger);
    }

    public Logger[] getLoggers() {
        return this.loggers.toArray(new Logger[this.loggers.size()]);
    }

    public void setLevel(Level level) {
        for (Logger logger : this.loggers) {
            Configurator.setLevel((String)logger.getName(), (Level)level);
        }
    }

    public Logger getLogger(String loggerName) {
        for (Logger logger : this.loggers) {
            if (!logger.getName().equals(loggerName)) continue;
            return logger;
        }
        return null;
    }

    public boolean monitors(String loggerName) {
        for (Logger logger : this.loggers) {
            if (!loggerName.startsWith(logger.getName())) continue;
            return true;
        }
        return false;
    }

    public void removeLogger(String loggerName) {
        for (Logger logger : this.loggers) {
            if (!loggerName.equals(logger.getName())) continue;
            Logging.removeAppender(loggerName, (Appender)this.internalLogAppender);
        }
    }

    public void saveToFile(File file) {
        try {
            PrintWriter writer = new PrintWriter(file);
            for (int c = 0; c < this.model.getSize(); ++c) {
                writer.println(this.model.getElementAt(c));
            }
            writer.close();
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
        }
    }

    public boolean isTailing() {
        return this.tailing;
    }

    public void setTailing(boolean tail) {
        this.tailing = tail;
    }

    private final class LogListModel
    extends AbstractListModel {
        private final List<Object> lines = Collections.synchronizedList(new TreeList());
        private ListUpdater updater = new ListUpdater();

        private LogListModel() {
        }

        @Override
        public int getSize() {
            return this.lines.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.lines.get(index);
        }

        public void clear() {
            final int size = this.lines.size();
            if (size == 0) {
                return;
            }
            this.lines.clear();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LogListModel.this.fireIntervalRemoved(LogListModel.this, 0, size - 1);
                }
            });
        }

        public void ensureUpdateIsStarted() {
            this.updater.ensureUpdateIsStarted();
        }

        private class ListUpdater
        implements Runnable {
            private volatile boolean updating;

            private ListUpdater() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String originalThreadName = Thread.currentThread().getName();
                Thread.currentThread().setName("LogList Updater for " + JLogList.this.title);
                this.setUpdating(true);
                try {
                    Object line;
                    while ((line = this.getNextLine()) != null) {
                        try {
                            ArrayList<Object> linesToAddNow = new ArrayList<Object>();
                            linesToAddNow.add(line);
                            while ((line = JLogList.this.linesToAdd.poll()) != null) {
                                linesToAddNow.add(line);
                            }
                            int oldSize = LogListModel.this.lines.size();
                            LogListModel.this.lines.addAll(linesToAddNow);
                            this.updateJList(oldSize);
                        }
                        catch (Exception e) {
                            SoapUI.logError(e);
                        }
                    }
                }
                finally {
                    ListUpdater listUpdater = this;
                    synchronized (listUpdater) {
                        this.updating = false;
                        if (!JLogList.this.linesToAdd.isEmpty()) {
                            this.ensureUpdateIsStarted();
                        }
                    }
                    Thread.currentThread().setName(originalThreadName);
                }
            }

            public synchronized void ensureUpdateIsStarted() {
                if (!this.updating) {
                    this.setUpdating(true);
                    SoapUI.getThreadPool().submit(this);
                }
            }

            private Object getNextLine() {
                try {
                    return JLogList.this.linesToAdd.poll(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    return null;
                }
            }

            private void updateJList(final int oldSize) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            LogListModel.this.fireIntervalAdded(LogListModel.this, oldSize, LogListModel.this.lines.size() - 1);
                            int linesToRemove = LogListModel.this.lines.size() - (int)JLogList.this.maxRows;
                            if (linesToRemove > 0) {
                                for (int i = 0; i < linesToRemove; ++i) {
                                    LogListModel.this.lines.remove(0);
                                }
                                LogListModel.this.fireIntervalRemoved(LogListModel.this, 0, linesToRemove);
                            }
                            if (JLogList.this.tailing) {
                                JLogList.this.logList.ensureIndexIsVisible(LogListModel.this.lines.size() - 1);
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }

            private synchronized void setUpdating(boolean updating) {
                this.updating = updating;
            }
        }
    }

    private class InternalLogAppender
    extends AbstractAppender {
        InternalLogAppender() {
            super(JLogList.INTERNAL_LOG_NAME, null, (Layout)PatternLayout.createDefaultLayout());
        }

        public void append(LogEvent event) {
            JLogList.this.addLine(event);
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }

    private static class LogAreaCellRenderer
    extends DefaultListCellRenderer {
        private Map<Level, Color> levelColors = new HashMap<Level, Color>();

        private LogAreaCellRenderer() {
            this.levelColors.put(Level.ERROR, new Color(192, 0, 0));
            this.levelColors.put(Level.INFO, new Color(0, 92, 0));
            this.levelColors.put(Level.WARN, Color.ORANGE.darker().darker());
            this.levelColors.put(Level.DEBUG, new Color(0, 0, 128));
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String toolTip;
            JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof LoggingEventWrapper) {
                LoggingEventWrapper eventWrapper = (LoggingEventWrapper)value;
                if (!isSelected && this.levelColors.containsKey(eventWrapper.getLevel())) {
                    component.setForeground(this.levelColors.get(eventWrapper.getLevel()));
                }
            }
            if ((toolTip = component.getText()) != null && toolTip.length() > 1000) {
                toolTip = toolTip.substring(0, 1000);
            }
            component.setToolTipText(toolTip);
            return component;
        }
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super("Clear");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JLogList.this.model.clear();
        }
    }

    private class EnableAction
    extends AbstractAction {
        public EnableAction() {
            super("Enable");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JLogList.this.setEnabled(JLogList.this.enableMenuItem.isSelected());
        }
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy to clipboard");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringBuilder buf = new StringBuilder();
            int[] selectedIndices = JLogList.this.logList.getSelectedIndices();
            if (selectedIndices.length == 0) {
                for (int c = 0; c < JLogList.this.logList.getModel().getSize(); ++c) {
                    buf.append(JLogList.this.logList.getModel().getElementAt(c).toString());
                    buf.append("\r\n");
                }
            } else {
                for (int selectedIndex : selectedIndices) {
                    buf.append(JLogList.this.logList.getModel().getElementAt(selectedIndex).toString());
                    buf.append("\r\n");
                }
            }
            StringSelection selection = new StringSelection(buf.toString());
            clipboard.setContents(selection, selection);
        }
    }

    private class SetMaxRowsAction
    extends AbstractAction {
        public SetMaxRowsAction() {
            super("Set Max Rows");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String val = UISupport.prompt("Set maximum number of log rows to keep", "Set Max Rows", String.valueOf(JLogList.this.maxRows));
            if (val != null) {
                try {
                    JLogList.this.maxRows = Long.parseLong(val);
                    SoapUI.getSettings().setString("JLogList#" + JLogList.this.title, val);
                }
                catch (NumberFormatException e1) {
                    UISupport.beep();
                }
            }
        }
    }

    private class ExportToFileAction
    extends AbstractAction {
        public ExportToFileAction() {
            super("Export to File");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JLogList.this.model.getSize() == 0) {
                UISupport.showErrorMessage("Log is empty; nothing to export");
                return;
            }
            File file = UISupport.getFileDialogs().saveAs(JLogList.this, "Save Log [] to File", "*.log", "*.log", null);
            if (file != null) {
                JLogList.this.saveToFile(file);
            }
        }
    }

    private static final class LoggingEventWrapper {
        private final LogEvent loggingEvent;
        private String str;

        public LoggingEventWrapper(LogEvent loggingEvent) {
            this.loggingEvent = loggingEvent;
        }

        public Level getLevel() {
            return this.loggingEvent.getLevel();
        }

        public String toString() {
            if (this.str == null) {
                if (this.loggingEvent.getLoggerName().equals("org.apache.http.wire")) {
                    this.str = this.loggingEvent.getMessage().toString();
                } else {
                    StringBuilder builder = new StringBuilder();
                    builder.append(new Date(this.loggingEvent.getTimeMillis()));
                    builder.append(':').append(this.loggingEvent.getLevel()).append(':').append(this.loggingEvent.getMessage());
                    this.str = builder.toString();
                }
            }
            return this.str;
        }
    }
}

