/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.xml.support;

import com.eviware.soapui.impl.wsdl.submit.transports.http.DocumentContent;
import com.eviware.soapui.support.editor.EditorDocument;
import com.eviware.soapui.support.editor.xml.support.AbstractXmlDocument;
import com.eviware.soapui.support.xml.XmlUtils;
import javax.annotation.Nonnull;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;

public class DefaultXmlDocument
extends AbstractXmlDocument {
    private String xml;
    private SchemaTypeSystem typeSystem;

    public DefaultXmlDocument(String xml) {
        this.xml = xml;
    }

    public DefaultXmlDocument() {
    }

    public void setTypeSystem(SchemaTypeSystem typeSystem) {
        this.typeSystem = typeSystem;
    }

    @Override
    public SchemaTypeSystem getTypeSystem() {
        if (this.typeSystem != null) {
            return this.typeSystem;
        }
        try {
            this.typeSystem = XmlUtils.createXmlObject(this.xml).schemaType().getTypeSystem();
            return this.typeSystem;
        }
        catch (Exception e) {
            return XmlBeans.getBuiltinTypeSystem();
        }
    }

    @Override
    public void setDocumentContent(DocumentContent documentContent) {
        this.xml = documentContent.getContentAsString();
        if ("<not-xml/>".equals(documentContent.getContentAsString())) {
            this.fireContentChanged();
        }
        this.fireContentChanged();
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public void release() {
        this.typeSystem = null;
    }

    @Override
    @Nonnull
    public DocumentContent getDocumentContent(EditorDocument.Format format) {
        return new DocumentContent("text/xml", this.xml);
    }
}

