/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.auth;

import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.impl.rest.OAuth1Profile;
import com.eviware.soapui.impl.rest.OAuth1ProfileContainer;
import com.eviware.soapui.impl.rest.OAuth1ProfileListener;
import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.impl.rest.OAuth2ProfileContainer;
import com.eviware.soapui.impl.rest.OAuth2ProfileListener;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.teststeps.TestRequest;
import com.eviware.soapui.model.support.AbstractModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.inspectors.AbstractXmlInspector;
import com.eviware.soapui.support.editor.inspectors.auth.AbstractAuthenticationForm;
import com.eviware.soapui.support.editor.inspectors.auth.AuthorizationSelectionDialog;
import com.eviware.soapui.support.editor.inspectors.auth.BasicAuthenticationForm;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth1Form;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth2Form;
import com.eviware.soapui.support.editor.inspectors.auth.WSSAuthenticationForm;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ProfileSelectionForm<T extends AbstractHttpRequest>
extends AbstractXmlInspector {
    public static final String PROFILE_COMBO_BOX = "Authorization:";
    public static final String BASIC_FORM_LABEL = "Legacy form";
    public static final String WSS_FORM_LABEL = "WSS form";
    public static final String OPTIONS_SEPARATOR = "------------------";
    public static final String DELETE_PROFILE_DIALOG_TITLE = "Delete Profile";
    public static final String RENAME_PROFILE_DIALOG_TITLE = "Rename Profile";
    public static final String EMPTY_PANEL = "EmptyPanel";
    static final ImageIcon AUTH_ENABLED_ICON = UISupport.createImageIcon("/lock.png");
    private static final String OAUTH_2_FORM_LABEL = "OAuth 2 form";
    private static final String OAUTH_1_FORM_LABEL = "OAuth 1 form";
    private static final ImageIcon AUTH_NOT_ENABLED_ICON = null;
    private static final Map<String, ShowOnlineHelpAction> helpActions = new HashMap<String, ShowOnlineHelpAction>();
    private final JPanel outerPanel = new JPanel(new BorderLayout());
    private final JPanel cardPanel = new JPanel(new CardLayout());
    private T request;
    private JComboBox profileSelectionComboBox;
    private CellConstraints cc = new CellConstraints();
    private BasicAuthenticationForm<T> authenticationForm;
    private OAuth2Form oAuth2Form;
    private OAuth1Form oAuth1Form;
    private JButton helpButton;
    private ProfileListener profileListener;
    private WSSAuthenticationForm wssAuthenticationForm;

    protected ProfileSelectionForm(T request) {
        super("Auth", "Authentication and Security-related settings", true, "Auth");
        this.request = request;
        this.buildUI();
        this.profileListener = new ProfileListener();
        this.getOAuth2ProfileContainer().addOAuth2ProfileListener(this.profileListener);
        this.getOAuth1ProfileContainer().addOAuth1ProfileListener(this.profileListener);
    }

    protected static boolean isReservedProfileName(String newName) {
        return ProfileSelectionForm.getBasicAuthenticationTypes().contains(newName) || newName.equals(OPTIONS_SEPARATOR);
    }

    protected static ArrayList<String> getBasicAuthenticationTypes() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("Basic");
        options.add(CredentialsConfig.AuthType.NTLM.toString());
        options.add(CredentialsConfig.AuthType.SPNEGO_KERBEROS.toString());
        return options;
    }

    @Override
    public JComponent getComponent() {
        this.profileSelectionComboBox.setSelectedItem(((AbstractHttpRequest)this.request).getSelectedAuthProfile());
        return this.outerPanel;
    }

    @Override
    public boolean isEnabledFor(EditorView<XmlDocument> view) {
        return !view.getViewId().equals("Raw");
    }

    @Override
    public void release() {
        super.release();
        if (this.oAuth2Form != null) {
            this.oAuth2Form.release();
        }
        if (this.oAuth1Form != null) {
            this.oAuth1Form.release();
        }
        this.getOAuth2ProfileContainer().removeOAuth2ProfileListener(this.profileListener);
        this.getOAuth1ProfileContainer().removeOAuth1ProfileListener(this.profileListener);
    }

    protected void buildUI() {
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel comboBoxPanel = this.createAuthorizationLabelAndComboBox();
        innerPanel.add((Component)comboBoxPanel, "First");
        this.cardPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.cardPanel.add((Component)this.createEmptyPanel(), EMPTY_PANEL);
        innerPanel.add((Component)this.cardPanel, "Center");
        this.authenticationForm = new BasicAuthenticationForm<T>(this.request);
        this.cardPanel.add((Component)this.authenticationForm.getComponent(), BASIC_FORM_LABEL);
        if (this.isSoapRequest(this.request)) {
            this.wssAuthenticationForm = new WSSAuthenticationForm((WsdlRequest)this.request);
            this.cardPanel.add((Component)this.wssAuthenticationForm.getComponent(), WSS_FORM_LABEL);
        }
        this.outerPanel.add((Component)new JScrollPane(innerPanel), "Center");
    }

    private JPanel createEmptyPanel() {
        JPanel panelWithText = new JPanel(new BorderLayout());
        String helpText = "<html>\n<body></div><div style=\"text-align:center\"><b>Not Yet Configured</b><br>Authorization has not been set for protected services.<br>Use the <i>Authorization</i> drop down to configure.</div></body></html>";
        JLabel label = new JLabel(helpText);
        label.setHorizontalAlignment(0);
        panelWithText.add((Component)label, "Center");
        panelWithText.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(AbstractAuthenticationForm.CARD_BORDER_COLOR), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        panelWithText.setBackground(AbstractAuthenticationForm.CARD_BACKGROUND_COLOR);
        return panelWithText;
    }

    private boolean isSoapRequest(T request) {
        return request instanceof WsdlRequest;
    }

    private JPanel createAuthorizationLabelAndComboBox() {
        FormLayout formLayout = new FormLayout("5px:none,left:pref,40px,left:default,5px:grow(1.0)");
        JPanel comboBoxPanel = new JPanel((LayoutManager)formLayout);
        comboBoxPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JLabel authorizationLabel = new JLabel(PROFILE_COMBO_BOX);
        authorizationLabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        formLayout.appendRow(new RowSpec("top:pref"));
        comboBoxPanel.add((Component)authorizationLabel, this.cc.xy(2, 1));
        this.createProfileSelectionComboBox();
        comboBoxPanel.add((Component)this.profileSelectionComboBox, this.cc.xy(4, 1));
        JPanel wrapperPanel = new JPanel(new BorderLayout(5, 5));
        wrapperPanel.add((Component)comboBoxPanel, "Before");
        this.helpButton = UISupport.createFormButton(helpActions.get(EMPTY_PANEL));
        wrapperPanel.add((Component)this.helpButton, "After");
        return wrapperPanel;
    }

    private void createProfileSelectionComboBox() {
        String[] existingProfiles = this.createOptionsForAuthorizationCombo(((AbstractHttpRequest)this.request).getSelectedAuthProfile());
        this.profileSelectionComboBox = new JComboBox<String>(existingProfiles);
        this.profileSelectionComboBox.setName(PROFILE_COMBO_BOX);
        this.profileSelectionComboBox.addItemListener(new ProfileSelectionListener());
    }

    private void setAuthenticationTypeAndShowCard(String selectedOption) {
        if (this.getAddEditOptions().contains(selectedOption)) {
            this.performAddEditOperation(((AbstractHttpRequest)this.request).getSelectedAuthProfile(), selectedOption);
            return;
        }
        if (ProfileSelectionForm.getBasicAuthenticationTypes().contains(selectedOption)) {
            this.setIcon(AUTH_ENABLED_ICON);
            this.setTitle("Auth (" + selectedOption + ")");
            ((AbstractHttpRequest)this.request).setSelectedAuthProfileAndAuthType(selectedOption, ((AbstractHttpRequest)this.request).getBasicAuthType(selectedOption));
            if (this.isSoapRequest(this.request)) {
                this.wssAuthenticationForm.setButtonGroupVisibility(selectedOption.equals("Basic"));
                this.changeAuthorizationType(WSS_FORM_LABEL, selectedOption);
                this.trackBasicTypes(selectedOption);
            } else {
                this.authenticationForm.setButtonGroupVisibility(selectedOption.equals("Basic"));
                this.changeAuthorizationType(BASIC_FORM_LABEL, selectedOption);
                this.trackBasicTypes(selectedOption);
            }
        } else if (this.isRestRequest(this.request) && this.getOAuth2ProfileContainer().getOAuth2ProfileNameList().contains(selectedOption)) {
            this.setTitle("Auth (" + selectedOption + ")");
            ((AbstractHttpRequest)this.request).setSelectedAuthProfileAndAuthType(selectedOption, CredentialsConfig.AuthType.O_AUTH_2_0);
            this.oAuth2Form = new OAuth2Form(this.getOAuth2ProfileContainer().getProfileByName(selectedOption), this);
            this.cardPanel.add((Component)this.oAuth2Form.getComponent(), OAUTH_2_FORM_LABEL);
            this.changeAuthorizationType(OAUTH_2_FORM_LABEL, selectedOption);
            if (this.request instanceof TestRequest) {
                Analytics.trackAction(SoapUIActions.ASSIGN_O_AUTH20_FOR_TEST_REQUEST, "OAuth2Flow", this.oAuth2Form.getProfile().getOAuth2Flow().name());
            } else {
                Analytics.trackAction(SoapUIActions.ASSIGN_O_AUTH20, "OAuth2Flow", this.oAuth2Form.getProfile().getOAuth2Flow().name());
            }
        } else if (this.isRestRequest(this.request) && this.getOAuth1ProfileContainer().getOAuth1ProfileNameList().contains(selectedOption)) {
            this.setTitle("Auth (" + selectedOption + ")");
            ((AbstractHttpRequest)this.request).setSelectedAuthProfileAndAuthType(selectedOption, CredentialsConfig.AuthType.O_AUTH_1_0);
            this.oAuth1Form = new OAuth1Form(this.getOAuth1ProfileContainer().getProfileByName(selectedOption), this);
            this.cardPanel.add((Component)this.oAuth1Form.getComponent(), OAUTH_1_FORM_LABEL);
            this.changeAuthorizationType(OAUTH_1_FORM_LABEL, selectedOption);
            if (this.request instanceof TestRequest) {
                Analytics.trackAction(SoapUIActions.ASSIGN_O_AUTH10_FOR_TEST_REQUEST);
            } else {
                Analytics.trackAction(SoapUIActions.ASSIGN_O_AUTH10);
            }
        } else if (selectedOption.equals(OPTIONS_SEPARATOR)) {
            this.profileSelectionComboBox.setSelectedIndex(0);
        } else {
            this.setIcon(AUTH_NOT_ENABLED_ICON);
            this.setTitle("Auth");
            ((AbstractHttpRequest)this.request).setSelectedAuthProfileAndAuthType(selectedOption, CredentialsConfig.AuthType.NO_AUTHORIZATION);
            this.changeAuthorizationType(EMPTY_PANEL, selectedOption);
        }
    }

    private void trackBasicTypes(String selectedOption) {
        if (selectedOption.equals(CredentialsConfig.AuthType.NTLM.toString())) {
            if (this.request instanceof TestRequest) {
                Analytics.trackAction(SoapUIActions.ASSIGN_NTLM_AUTH_FOR_TEST_REQUEST);
            } else {
                Analytics.trackAction(SoapUIActions.ASSIGN_NTLM_AUTH);
            }
        } else if (selectedOption.equals(CredentialsConfig.AuthType.SPNEGO_KERBEROS.toString())) {
            if (this.request instanceof TestRequest) {
                Analytics.trackAction(SoapUIActions.ASSIGN_SPNEGO_KERBEROS_AUTH_FOR_TEST_REQUEST);
            } else {
                Analytics.trackAction(SoapUIActions.ASSIGN_SPNEGO_KERBEROS_AUTH);
            }
        } else if (selectedOption.equals("Basic")) {
            if (this.request instanceof TestRequest) {
                Analytics.trackAction(SoapUIActions.ASSIGN_BASIC_AUTH_FOR_TEST_REQUEST);
            } else {
                Analytics.trackAction(SoapUIActions.ASSIGN_BASIC_AUTH);
            }
        }
    }

    private void performAddEditOperation(final String currentProfile, String selectedOption) {
        AddEditOptions addEditOption = this.getAddEditOptionForDescription(selectedOption);
        switch (addEditOption) {
            case ADD: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new AuthorizationSelectionDialog<AbstractHttpRequest>(ProfileSelectionForm.this.request, ProfileSelectionForm.getBasicAuthenticationTypes());
                        ProfileSelectionForm.this.refreshProfileSelectionComboBox(ProfileSelectionForm.this.request.getSelectedAuthProfile());
                    }
                });
                break;
            }
            case DELETE: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfileSelectionForm.this.deleteCurrentProfile(currentProfile);
                    }
                });
                break;
            }
            case RENAME: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfileSelectionForm.this.renameCurrentProfile(currentProfile);
                    }
                });
                break;
            }
        }
    }

    private void renameCurrentProfile(String profileOldName) {
        String newName = UISupport.prompt("Specify name of Profile", RENAME_PROFILE_DIALOG_TITLE, profileOldName);
        if (newName == null || profileOldName.equals(newName)) {
            this.profileSelectionComboBox.setSelectedItem(profileOldName);
            return;
        }
        if (newName.trim().equals("")) {
            UISupport.showErrorMessage("New name can't be empty.");
            this.profileSelectionComboBox.setSelectedItem(profileOldName);
            return;
        }
        if (ProfileSelectionForm.isReservedProfileName(newName)) {
            UISupport.showErrorMessage("'" + newName + "' is a reserved profile name.");
            this.profileSelectionComboBox.setSelectedItem(profileOldName);
            return;
        }
        if (this.getOAuth2ProfileContainer().getOAuth2ProfileNameList().contains(newName)) {
            UISupport.showErrorMessage("There is already a profile named '" + newName + "'");
            this.profileSelectionComboBox.setSelectedItem(profileOldName);
            return;
        }
        this.getOAuth2ProfileContainer().renameProfile(profileOldName, newName);
    }

    private void deleteCurrentProfile(String profileName) {
        boolean confirmedDeletion = UISupport.confirm("Do you really want to delete profile '" + profileName + "' ?", DELETE_PROFILE_DIALOG_TITLE);
        if (!confirmedDeletion) {
            this.refreshProfileSelectionComboBox(profileName);
            return;
        }
        if (this.isRestRequest(this.request) && this.getOAuth2ProfileContainer().getOAuth2ProfileNameList().contains(profileName)) {
            this.getOAuth2ProfileContainer().removeProfile(profileName);
        } else if (this.isRestRequest(this.request) && this.getOAuth1ProfileContainer().getOAuth1ProfileNameList().contains(profileName)) {
            this.getOAuth1ProfileContainer().removeProfile(profileName);
        } else if (ProfileSelectionForm.getBasicAuthenticationTypes().contains(profileName)) {
            ((AbstractHttpRequest)this.request).removeBasicAuthenticationProfile(profileName);
        }
        this.refreshProfileSelectionComboBox(CredentialsConfig.AuthType.NO_AUTHORIZATION.toString());
    }

    private void refreshProfileSelectionComboBox(String selectedProfile) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(this.createOptionsForAuthorizationCombo(selectedProfile));
        model.setSelectedItem(OPTIONS_SEPARATOR);
        this.profileSelectionComboBox.setModel(model);
        this.profileSelectionComboBox.removeItemListener(this.profileSelectionComboBox.getItemListeners()[0]);
        this.profileSelectionComboBox.addItemListener(new ProfileSelectionListener());
        this.profileSelectionComboBox.setSelectedItem(selectedProfile);
    }

    private void changeAuthorizationType(String cardName, String selectedOption) {
        this.showCard(cardName);
        String helpKey = cardName;
        if (cardName.equals(BASIC_FORM_LABEL) || cardName.equals(WSS_FORM_LABEL)) {
            helpKey = selectedOption;
        }
        this.helpButton.setAction(helpActions.get(helpKey));
    }

    private void showCard(String cardName) {
        CardLayout layout = (CardLayout)this.cardPanel.getLayout();
        layout.show(this.cardPanel, cardName);
    }

    private OAuth2ProfileContainer getOAuth2ProfileContainer() {
        return ((AbstractModelItem)this.request).getProject().getOAuth2ProfileContainer();
    }

    private OAuth1ProfileContainer getOAuth1ProfileContainer() {
        return ((AbstractModelItem)this.request).getProject().getOAuth1ProfileContainer();
    }

    private String[] createOptionsForAuthorizationCombo(String selectedAuthProfile) {
        ArrayList<String> options = new ArrayList<String>();
        options.add(CredentialsConfig.AuthType.NO_AUTHORIZATION.toString());
        Set<String> basicAuthenticationProfiles = ((AbstractHttpRequest)this.request).getBasicAuthenticationProfiles();
        options.addAll(basicAuthenticationProfiles);
        ArrayList<String> addEditOptions = this.getAddEditOptions();
        ArrayList<String> oAuth2Profiles = null;
        ArrayList<String> oAuth1Profiles = null;
        if (this.isRestRequest(this.request)) {
            oAuth2Profiles = this.getOAuth2ProfileContainer().getOAuth2ProfileNameList();
            oAuth1Profiles = this.getOAuth1ProfileContainer().getOAuth1ProfileNameList();
            options.addAll(oAuth2Profiles);
            options.addAll(oAuth1Profiles);
        }
        if (this.isSoapRequest(this.request) && basicAuthenticationProfiles.size() >= ProfileSelectionForm.getBasicAuthenticationTypes().size()) {
            addEditOptions.remove(AddEditOptions.ADD.getDescription());
        }
        if (oAuth2Profiles == null || !oAuth2Profiles.contains(selectedAuthProfile)) {
            addEditOptions.remove(AddEditOptions.RENAME.getDescription());
        }
        if (options.size() <= 1 || CredentialsConfig.AuthType.NO_AUTHORIZATION.toString().equals(selectedAuthProfile)) {
            addEditOptions.remove(AddEditOptions.DELETE.getDescription());
        }
        if (!addEditOptions.isEmpty()) {
            options.add(OPTIONS_SEPARATOR);
            options.addAll(addEditOptions);
        }
        return options.toArray(new String[options.size()]);
    }

    private boolean isRestRequest(T request) {
        return request instanceof RestRequest;
    }

    private ArrayList<String> getAddEditOptions() {
        ArrayList<String> addEditOptions = new ArrayList<String>();
        addEditOptions.add(AddEditOptions.ADD.getDescription());
        addEditOptions.add(AddEditOptions.RENAME.getDescription());
        addEditOptions.add(AddEditOptions.DELETE.getDescription());
        return addEditOptions;
    }

    private AddEditOptions getAddEditOptionForDescription(String description) {
        for (AddEditOptions option : AddEditOptions.values()) {
            if (!option.getDescription().equals(description)) continue;
            return option;
        }
        return null;
    }

    static {
        helpActions.put(EMPTY_PANEL, new ShowOnlineHelpAction(null, "/OAuth/authorization.html"));
        helpActions.put("Basic", new ShowOnlineHelpAction(null, "/OAuth/Basic.html"));
        helpActions.put(CredentialsConfig.AuthType.NTLM.toString(), new ShowOnlineHelpAction(null, "/OAuth/NTLM.html"));
        helpActions.put(CredentialsConfig.AuthType.SPNEGO_KERBEROS.toString(), new ShowOnlineHelpAction(null, "/OAuth/SPNEGO-Kerberos.html"));
        helpActions.put(OAUTH_2_FORM_LABEL, new ShowOnlineHelpAction(null, "/OAuth/OAuth2.html"));
    }

    private class ProfileListener
    implements OAuth2ProfileListener,
    OAuth1ProfileListener {
        private ProfileListener() {
        }

        @Override
        public void profileAdded(OAuth2Profile profile) {
            ProfileSelectionForm.this.refreshProfileSelectionComboBox(ProfileSelectionForm.this.request.getSelectedAuthProfile());
        }

        @Override
        public void profileRemoved(String profileName) {
            ProfileSelectionForm.this.refreshProfileSelectionComboBox(ProfileSelectionForm.this.request.getSelectedAuthProfile());
        }

        @Override
        public void profileRenamed(String profileOldName, String newName) {
            ProfileSelectionForm.this.refreshProfileSelectionComboBox(ProfileSelectionForm.this.request.getSelectedAuthProfile());
        }

        @Override
        public void profileAdded(OAuth1Profile profile) {
            ProfileSelectionForm.this.refreshProfileSelectionComboBox(ProfileSelectionForm.this.request.getSelectedAuthProfile());
        }
    }

    private class ProfileSelectionListener
    implements ItemListener {
        private ProfileSelectionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                String selectedProfile = (String)e.getItem();
                ProfileSelectionForm.this.setAuthenticationTypeAndShowCard(selectedProfile);
                if (!ProfileSelectionForm.this.getAddEditOptions().contains(selectedProfile) && !selectedProfile.equals(ProfileSelectionForm.OPTIONS_SEPARATOR)) {
                    DefaultComboBoxModel<String> profileComboBoXModel = new DefaultComboBoxModel<String>(ProfileSelectionForm.this.createOptionsForAuthorizationCombo(selectedProfile));
                    profileComboBoXModel.setSelectedItem(selectedProfile);
                    ProfileSelectionForm.this.profileSelectionComboBox.setModel(profileComboBoXModel);
                }
            }
        }
    }

    public static enum AddEditOptions {
        ADD("Add New Authorization..."),
        RENAME("Rename current..."),
        DELETE("Delete current");

        private String description;

        private AddEditOptions(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

