/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.auth;

import com.eviware.soapui.config.TimeUnitConfig;
import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.editor.inspectors.auth.ExpirationTimeChooser;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.form.support.XFormRadioGroup;
import javax.swing.JButton;
import org.apache.commons.lang.StringUtils;

public class OAuth2AdvancedOptionsDialog {
    public static final MessageSupport messages = MessageSupport.getMessages(OAuth2AdvancedOptionsDialog.class);
    private ExpirationTimeChooser expirationTimeComponent;
    private JButton refreshAccessTokenButton;

    public OAuth2AdvancedOptionsDialog(OAuth2Profile profile, JButton refreshAccessTokenButton) {
        this.refreshAccessTokenButton = refreshAccessTokenButton;
        this.expirationTimeComponent = new ExpirationTimeChooser(profile);
        XFormDialog dialog = ADialogBuilder.buildDialog(Form.class);
        dialog.getFormField(Form.ACCESS_TOKEN_EXPIRATION_TIME).setProperty("component", this.expirationTimeComponent);
        this.setAccessTokenOptions(profile, dialog);
        this.setRefreshAccessTokenOptions(profile, dialog);
        if (dialog.show()) {
            String accessTokenPosition = dialog.getValue(Form.ACCESS_TOKEN_POSITION);
            profile.setAccessTokenPosition(OAuth2Profile.AccessTokenPosition.valueOf(accessTokenPosition));
            String refreshAccessTokenMethod = dialog.getValue(Form.AUTOMATIC_ACCESS_TOKEN_REFRESH);
            profile.setRefreshAccessTokenMethod(OAuth2Profile.RefreshAccessTokenMethods.valueOf(refreshAccessTokenMethod.toUpperCase()));
            String manualExpirationTime = this.expirationTimeComponent.getAccessTokenExpirationTime();
            TimeUnitConfig.Enum expirationTimeUnit = this.expirationTimeComponent.getAccessTokenExpirationTimeUnit();
            profile.setManualAccessTokenExpirationTime(manualExpirationTime);
            profile.setManualAccessTokenExpirationTimeUnit(expirationTimeUnit);
            if (this.expirationTimeComponent.manualExpirationTimeIsSelected()) {
                profile.setUseManualAccessTokenExpirationTime(true);
            } else {
                profile.setUseManualAccessTokenExpirationTime(false);
            }
            this.enableRefreshAccessTokenButton(profile);
        }
    }

    private void enableRefreshAccessTokenButton(OAuth2Profile profile) {
        boolean enabled = profile.getRefreshAccessTokenMethod() == OAuth2Profile.RefreshAccessTokenMethods.MANUAL && !StringUtils.isEmpty((String)profile.getRefreshToken());
        this.refreshAccessTokenButton.setEnabled(enabled);
        this.refreshAccessTokenButton.setVisible(enabled);
    }

    private void setRefreshAccessTokenOptions(OAuth2Profile profile, XFormDialog dialog) {
        XFormRadioGroup refreshOptions = (XFormRadioGroup)dialog.getFormField(Form.AUTOMATIC_ACCESS_TOKEN_REFRESH);
        refreshOptions.setOptions((Object[])OAuth2Profile.RefreshAccessTokenMethods.values());
        refreshOptions.setValue(profile.getRefreshAccessTokenMethod().name());
    }

    private void setAccessTokenOptions(OAuth2Profile profile, XFormDialog dialog) {
        XFormRadioGroup accessTokenPositionField = (XFormRadioGroup)dialog.getFormField(Form.ACCESS_TOKEN_POSITION);
        OAuth2Profile.AccessTokenPosition[] accessTokenPositions = new OAuth2Profile.AccessTokenPosition[]{OAuth2Profile.AccessTokenPosition.HEADER, OAuth2Profile.AccessTokenPosition.QUERY};
        accessTokenPositionField.setOptions((Object[])accessTokenPositions);
        dialog.setValue(Form.ACCESS_TOKEN_POSITION, profile.getAccessTokenPosition().name());
    }

    @AForm(name="Form.Title", description="Form.Description", helpUrl="/OAuth/advanced-options.html")
    public static interface Form {
        @AField(description="Form.AccessTokenPosition.Description", type=AField.AFieldType.RADIOGROUP)
        public static final String ACCESS_TOKEN_POSITION = messages.get("Form.AccessTokenPosition.Label");
        @AField(description="Form.AutomaticRefreshAccessToken.Description", type=AField.AFieldType.RADIOGROUP)
        public static final String AUTOMATIC_ACCESS_TOKEN_REFRESH = messages.get("Form.AutomaticRefreshAccessToken.Label");
        @AField(description="Form.AccessTokenExpirationTime.Description", type=AField.AFieldType.COMPONENT)
        public static final String ACCESS_TOKEN_EXPIRATION_TIME = messages.get("Form.AccessTokenExpirationTime.Label");
    }
}

