/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.auth;

import com.eviware.soapui.config.TimeUnitConfig;
import com.eviware.soapui.impl.rest.OAuth2Profile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.commons.lang.WordUtils;

class ExpirationTimeChooser
extends JPanel {
    static final String SERVER_EXPIRATION_RADIO_NAME = "serverExpirationRadio";
    static final String MANUAL_EXPIRATION_RADIO_NAME = "manualExpirationRadio";
    static final String TIME_FIELD_NAME = "timeField";
    static final String TIME_UNIT_COMBO_NAME = "timeUnitCombo";
    private static final String[] TIME_UNIT_OPTIONS = new String[]{"Seconds", "Minutes", "Hours"};
    private static final int TIME_FIELD_CHARACTER_LIMIT = 9;
    private JRadioButton serverExpirationTimeOption;
    private JRadioButton manualExpirationTimeOption;
    private JTextField timeTextField;
    private JComboBox timeUnitCombo;
    private OAuth2Profile profile;

    ExpirationTimeChooser(OAuth2Profile profile) {
        this.profile = profile;
        this.setLayout(new BorderLayout(0, 0));
        this.initializeRadioButtons();
        JPanel timeSelectionPanel = this.createTimeSelectionPanel();
        JPanel northPanel = new JPanel(new GridLayout(3, 1, 0, 0));
        northPanel.add(this.serverExpirationTimeOption);
        northPanel.add(this.manualExpirationTimeOption);
        northPanel.add(timeSelectionPanel);
        this.add((Component)northPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout(0, 0));
        JLabel label = new JLabel("<html>Here you can set an expiry time if the OAuth 2 server doesn't,<br/>so that the token retrieval can be automated.</html>");
        label.setForeground(new Color(143, 143, 143));
        centerPanel.add((Component)label, "North");
        this.add((Component)centerPanel, "Center");
    }

    public String getAccessTokenExpirationTime() {
        return this.timeTextField.getText();
    }

    public TimeUnitConfig.Enum getAccessTokenExpirationTimeUnit() {
        String timeUnitString = this.timeUnitCombo.getSelectedItem().toString().toUpperCase();
        return TimeUnitConfig.Enum.forString(timeUnitString);
    }

    public boolean manualExpirationTimeIsSelected() {
        return this.manualExpirationTimeOption.isSelected();
    }

    private JPanel createTimeSelectionPanel() {
        JPanel timeSelectionPanel = new JPanel(new FlowLayout(0, 3, 0));
        boolean enableManualTimeControls = this.profile.useManualAccessTokenExpirationTime();
        this.timeTextField = this.createTimeTextField(enableManualTimeControls);
        this.timeUnitCombo = this.createTimeUnitCombo(enableManualTimeControls);
        timeSelectionPanel.add(this.timeTextField);
        timeSelectionPanel.add(this.timeUnitCombo);
        return timeSelectionPanel;
    }

    private JTextField createTimeTextField(boolean enableManualTimeControls) {
        JTextField timeTextField = new JTextField(5);
        timeTextField.setName(TIME_FIELD_NAME);
        timeTextField.setHorizontalAlignment(4);
        timeTextField.setEnabled(enableManualTimeControls);
        String manualAccessTokenExpirationTime = this.profile.getManualAccessTokenExpirationTime();
        if (manualAccessTokenExpirationTime == null) {
            timeTextField.setText("");
        } else {
            timeTextField.setText(manualAccessTokenExpirationTime);
        }
        return timeTextField;
    }

    private JComboBox createTimeUnitCombo(boolean enableManualTimeControls) {
        JComboBox<String> timeUnitCombo = new JComboBox<String>(TIME_UNIT_OPTIONS);
        timeUnitCombo.setName(TIME_UNIT_COMBO_NAME);
        timeUnitCombo.setEnabled(enableManualTimeControls);
        TimeUnitConfig.Enum timeUnit = this.profile.getManualAccessTokenExpirationTimeUnit();
        timeUnitCombo.setSelectedItem(WordUtils.capitalize((String)timeUnit.toString().toLowerCase()));
        return timeUnitCombo;
    }

    private void initializeRadioButtons() {
        long serverIssuedExpirationTime = this.profile.getAccessTokenExpirationTime();
        String serverIssuedExpirationTimeLabel = serverIssuedExpirationTime > 0L ? this.getMostLegibleTimeString(serverIssuedExpirationTime) : "No expiration.";
        this.serverExpirationTimeOption = new JRadioButton("Use expiration time from authorization server: " + serverIssuedExpirationTimeLabel);
        this.serverExpirationTimeOption.setName(SERVER_EXPIRATION_RADIO_NAME);
        ActionListener checkBoxMonitor = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpirationTimeChooser.this.timeTextField.setEnabled(ExpirationTimeChooser.this.manualExpirationTimeOption.isSelected());
                ExpirationTimeChooser.this.timeUnitCombo.setEnabled(ExpirationTimeChooser.this.manualExpirationTimeOption.isSelected());
            }
        };
        this.serverExpirationTimeOption.addActionListener(checkBoxMonitor);
        this.manualExpirationTimeOption = new JRadioButton("Custom");
        this.manualExpirationTimeOption.setName(MANUAL_EXPIRATION_RADIO_NAME);
        this.manualExpirationTimeOption.addActionListener(checkBoxMonitor);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.serverExpirationTimeOption);
        buttonGroup.add(this.manualExpirationTimeOption);
        if (this.profile.useManualAccessTokenExpirationTime()) {
            this.manualExpirationTimeOption.setSelected(true);
        } else {
            this.serverExpirationTimeOption.setSelected(true);
        }
    }

    private String getMostLegibleTimeString(long seconds) {
        if (seconds % 3600L == 0L) {
            return seconds / 3600L + " hour(s)";
        }
        if (seconds % 60L == 0L) {
            return seconds / 60L + " minute(s)";
        }
        return seconds + " second(s)";
    }
}

