/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.attachments;

import com.eviware.soapui.impl.wsdl.AttachmentContainer;
import com.eviware.soapui.impl.wsdl.MutableAttachmentContainer;
import com.eviware.soapui.impl.wsdl.support.WsdlAttachment;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.support.editor.inspectors.attachments.AttachmentTableModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;

public class AttachmentsTableModel
extends AbstractTableModel
implements PropertyChangeListener,
AttachmentTableModel {
    private AttachmentContainer container;

    public AttachmentsTableModel(AttachmentContainer request) {
        this.container = request;
        this.container.addAttachmentsChangeListener(this);
    }

    public void release() {
        this.container.removeAttachmentsChangeListener(this);
    }

    @Override
    public void addFile(File file, boolean cacheInRequest) throws IOException {
        if (this.container instanceof MutableAttachmentContainer) {
            ((MutableAttachmentContainer)this.container).attachFile(file, cacheInRequest);
        }
        this.fireTableRowsInserted(this.container.getAttachmentCount(), this.container.getAttachmentCount());
    }

    public void removeAttachment(int[] rowIndexes) {
        Arrays.sort(rowIndexes);
        for (int i = rowIndexes.length - 1; i >= 0; --i) {
            this.removeAttachment(rowIndexes[i]);
        }
    }

    public void removeAttachment(int rowIndex) {
        if (this.container instanceof MutableAttachmentContainer) {
            ((MutableAttachmentContainer)this.container).removeAttachment(this.container.getAttachmentAt(rowIndex));
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    @Override
    public int getRowCount() {
        return this.container.getAttachmentCount();
    }

    @Override
    public int getColumnCount() {
        return this.container instanceof MutableAttachmentContainer ? 7 : 6;
    }

    public Attachment getAttachmentAt(int rowIndex) {
        return this.container.getAttachmentAt(rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount()) {
            return null;
        }
        Attachment att = this.container.getAttachmentAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                return att.isCached() ? att.getName() : att.getUrl();
            }
            case 1: {
                return att.getContentType();
            }
            case 2: {
                return att.getSize();
            }
            case 3: {
                return att.getPart();
            }
            case 4: {
                return att.getAttachmentType();
            }
            case 5: {
                return att.getContentID();
            }
            case 6: {
                return att.isCached();
            }
        }
        return null;
    }

    @Override
    public int findColumn(String columnName) {
        if (columnName.equals("Name")) {
            return 0;
        }
        if (columnName.equals("Content type")) {
            return 1;
        }
        if (columnName.equals("Size")) {
            return 2;
        }
        if (columnName.equals("Part")) {
            return 3;
        }
        if (columnName.equals("Type")) {
            return 4;
        }
        return -1;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Name";
        }
        if (column == 1) {
            return "Content type";
        }
        if (column == 2) {
            return "Size";
        }
        if (column == 3) {
            return "Part";
        }
        if (column == 4) {
            return "Type";
        }
        if (column == 5) {
            return "ContentID";
        }
        if (column == 6) {
            return "Cached";
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 6 ? Boolean.class : super.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.container instanceof MutableAttachmentContainer && (columnIndex == 0 || columnIndex == 1 || columnIndex == 3 || columnIndex == 5);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!(this.container instanceof MutableAttachmentContainer)) {
            return;
        }
        WsdlAttachment att = (WsdlAttachment)this.container.getAttachmentAt(rowIndex);
        if (columnIndex == 0) {
            if (att.isCached()) {
                att.setName((String)aValue);
            } else {
                att.setUrl(aValue.toString());
            }
        } else if (columnIndex == 1) {
            att.setContentType((String)aValue);
        } else if (columnIndex == 3) {
            att.setPart((String)aValue);
        } else if (columnIndex == 5) {
            att.setContentID((String)aValue);
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireTableDataChanged();
    }
}

