/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.dnd.handlers;

import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.support.UISupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class DragAndDropSupport {
    public static boolean copyTestStep(WsdlTestStep source, WsdlTestCase target, int defaultPosition) {
        WsdlProject targetProject;
        String name = UISupport.prompt("Enter name for copied TestStep", "Copy TestStep", (String)(target == source.getTestCase() ? "Copy of " + source.getName() : source.getName()));
        if (name == null) {
            return false;
        }
        WsdlProject sourceProject = source.getTestCase().getTestSuite().getProject();
        if (sourceProject != (targetProject = target.getTestSuite().getProject()) && !DragAndDropSupport.importRequiredInterfaces(targetProject, new HashSet<Interface>(source.getRequiredInterfaces()), "Copy Test Step")) {
            return false;
        }
        target.importTestStep(source, name, defaultPosition, true);
        return true;
    }

    public static boolean importRequiredInterfaces(Project project, Set<Interface> requiredInterfaces, String title) {
        if (requiredInterfaces.size() > 0 && project.getInterfaceCount() > 0) {
            HashMap<String, Interface> bindings = new HashMap<String, Interface>();
            for (Interface iface : requiredInterfaces) {
                bindings.put(iface.getTechnicalId(), iface);
            }
            for (Interface iface : project.getInterfaceList()) {
                bindings.remove(iface.getTechnicalId());
            }
            requiredInterfaces.retainAll(bindings.values());
        }
        if (requiredInterfaces.size() > 0) {
            String msg = "Target project [" + project.getName() + "] is missing required Interfaces;\r\n\r\n";
            for (Interface iface : requiredInterfaces) {
                msg = msg + iface.getName() + " [" + iface.getTechnicalId() + "]\r\n";
            }
            if (!UISupport.confirm(msg = msg + "\r\nThese will be cloned to the target project as well", title)) {
                return false;
            }
            for (Interface iface : requiredInterfaces) {
                ((WsdlProject)project).importInterface((AbstractInterface)iface, true, true);
            }
        }
        return true;
    }

    public static boolean moveTestStep(WsdlTestStep source, WsdlTestCase target, int defaultPosition) {
        if (source.getTestCase() == target) {
            int ix = target.getIndexOfTestStep(source);
            if (defaultPosition == -1) {
                target.moveTestStep(ix, target.getTestStepCount() - ix);
            } else if (ix >= 0 && defaultPosition != ix) {
                int offset = defaultPosition - ix;
                if (offset > 0) {
                    --offset;
                }
                target.moveTestStep(ix, offset);
            }
        } else {
            WsdlProject targetProject;
            String name = UISupport.prompt("Enter name for moved TestStep", "Move TestStep", source.getName());
            if (name == null) {
                return false;
            }
            WsdlProject sourceProject = source.getTestCase().getTestSuite().getProject();
            if (sourceProject != (targetProject = target.getTestSuite().getProject()) && !DragAndDropSupport.importRequiredInterfaces(targetProject, new HashSet<Interface>(source.getRequiredInterfaces()), "Move Test Step")) {
                return false;
            }
            WsdlTestStep result = target.importTestStep(source, name, defaultPosition, false);
            if (result == null) {
                return false;
            }
            source.getTestCase().removeTestStep(source);
        }
        return true;
    }
}

