/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.EnabledWebViewBasedBrowserComponent;
import com.eviware.soapui.support.components.JXToolBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebHistory;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

class WebViewNavigationBar {
    private final JComponent toolbar = this.createNavigationBar();
    private WebEngine webEngine;
    private EnabledWebViewBasedBrowserComponent webViewBasedBrowserComponent;
    private JTextField urlField;
    private ForwardAction forwardAction;
    private BackAction backAction;
    private Color originalFontColor;
    private String hintText = "Enter URL here";

    WebViewNavigationBar() {
    }

    void initialize(final WebEngine webEngine, EnabledWebViewBasedBrowserComponent webViewBasedBrowserComponent) {
        this.webEngine = webEngine;
        this.webViewBasedBrowserComponent = webViewBasedBrowserComponent;
        webEngine.getHistory().currentIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldHistoryIndex, Number newHistoryIndex) {
                if (WebViewNavigationBar.this.backAction != null) {
                    WebViewNavigationBar.this.backAction.setEnabled(((Number)observableValue.getValue()).intValue() > 0);
                }
                if (WebViewNavigationBar.this.forwardAction != null) {
                    WebViewNavigationBar.this.forwardAction.setEnabled(((Number)observableValue.getValue()).intValue() < webEngine.getHistory().getEntries().size() - 1);
                }
            }
        });
        webEngine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String oldLocation, final String newLocation) {
                if (WebViewNavigationBar.this.urlField != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (StringUtils.hasContent(newLocation)) {
                                WebViewNavigationBar.this.urlField.setText(newLocation);
                            }
                            WebViewNavigationBar.this.resetTextFieldDefaults();
                            WebViewNavigationBar.this.urlField.setFocusable(false);
                            WebViewNavigationBar.this.urlField.setFocusable(true);
                        }
                    });
                }
            }
        });
    }

    public void focusUrlField() {
        this.urlField.requestFocus();
    }

    private JComponent createNavigationBar() {
        JXToolBar toolbar = UISupport.createToolbar();
        this.urlField = new JTextField();
        this.backAction = new BackAction();
        this.backAction.setEnabled(false);
        toolbar.add(this.backAction);
        this.forwardAction = new ForwardAction();
        this.forwardAction.setEnabled(false);
        toolbar.add(this.forwardAction);
        toolbar.add(new ReloadAction());
        toolbar.add(this.urlField);
        this.urlField.addActionListener(new UrlEnteredActionListener());
        this.urlField.setText(this.hintText);
        this.urlField.setFont(this.urlField.getFont().deriveFont(2));
        this.originalFontColor = this.urlField.getForeground();
        this.urlField.setForeground(new Color(170, 170, 170));
        this.urlField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                WebViewNavigationBar.this.removeHintText();
                WebViewNavigationBar.this.urlField.getDocument().removeDocumentListener(this);
            }
        });
        this.urlField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WebViewNavigationBar.this.removeHintText();
                WebViewNavigationBar.this.urlField.removeMouseListener(this);
            }
        });
        return toolbar;
    }

    private void removeHintText() {
        String urlFieldText = this.urlField.getText();
        if (urlFieldText.contains(this.hintText)) {
            final String textWithOutHint = urlFieldText.replaceFirst(this.hintText, "");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebViewNavigationBar.this.urlField.setText(textWithOutHint);
                }
            });
        }
        this.resetTextFieldDefaults();
    }

    private void resetTextFieldDefaults() {
        this.urlField.setFont(this.urlField.getFont().deriveFont(0));
        this.urlField.setForeground(this.originalFontColor);
    }

    Component getComponent() {
        return this.toolbar;
    }

    private class ForwardAction
    extends AbstractAction {
        public ForwardAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/arrow_right.png"));
            this.putValue("ShortDescription", "Go forward");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WebViewNavigationBar.this.webEngine == null) {
                return;
            }
            final WebHistory history = WebViewNavigationBar.this.webEngine.getHistory();
            if (history.getCurrentIndex() >= history.getEntries().size() - 1) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        history.go(1);
                    }
                });
            }
        }
    }

    private class BackAction
    extends AbstractAction {
        public BackAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/arrow_left.png"));
            this.putValue("ShortDescription", "Go back");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WebViewNavigationBar.this.webEngine == null) {
                return;
            }
            final WebHistory history = WebViewNavigationBar.this.webEngine.getHistory();
            if (history.getCurrentIndex() == 0) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        history.go(-1);
                    }
                });
            }
        }
    }

    private class ReloadAction
    extends AbstractAction {
        public ReloadAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/reload_properties.gif"));
            this.putValue("ShortDescription", "Reload page");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WebViewNavigationBar.this.webEngine == null) {
                return;
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WebViewNavigationBar.this.webEngine.reload();
                }
            });
        }
    }

    private class UrlEnteredActionListener
    implements ActionListener {
        private UrlEnteredActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String url = WebViewNavigationBar.this.urlField.getText();
            url = HttpUtils.completeUrlWithHttpIfProtocolIsMissing(url);
            WebViewNavigationBar.this.webViewBasedBrowserComponent.navigate(url);
        }
    }
}

