/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JFormComponent;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.soapui.support.components.PropertyComponent;
import com.eviware.soapui.support.swing.JTextComponentPopupMenu;
import com.google.common.base.Preconditions;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class SimpleForm {
    public static final int DEFAULT_COMPONENT_COLUMN = 4;
    public static final int DEFAULT_LABEL_COLUMN = 2;
    public static final int SHORT_TEXT_FIELD_COLUMNS = 20;
    public static final int MEDIUM_TEXT_FIELD_COLUMNS = 30;
    public static final int LONG_TEXT_FIELD_COLUMNS = 50;
    public static final Color HINT_TEXT_COLOR = new Color(113, 102, 102);
    protected static final String DEFAULT_COMPONENT_ALIGNMENT = "left,bottom";
    protected static final int DEFAULT_TEXT_FIELD_COLUMNS = 30;
    protected static final String ENABLED_PROPERTY_NAME = "enabled";
    private static final int DEFAULT_COLUMN_SPAN = 1;
    private static final String DEFAULT_COLUMN_SPECS = "5px:none,left:pref,10px,left:default,5px:grow(1.0)";
    private JPanel panel;
    private CellConstraints cc = new CellConstraints();
    private FormLayout layout;
    private RowSpec rowSpec;
    private int rowSpacing = 5;
    private Map<String, JComponent> components = new HashMap<String, JComponent>();
    private Map<JComboBox, Object[]> comboBoxMaps = new HashMap<JComboBox, Object[]>();
    private String rowAlignment = "top";
    private Map<String, String> hiddenValues;
    private boolean appended;
    private Font labelFont;
    private int defaultTextAreaColumns = 30;
    private int defaultTextAreaRows = 3;
    private int defaultTextFieldColumns = 30;

    public SimpleForm() {
        this(DEFAULT_COLUMN_SPECS);
    }

    public SimpleForm(String columnSpec) {
        this(new FormLayout(columnSpec), BorderFactory.createEmptyBorder());
    }

    public SimpleForm(String columnSpec, Border border) {
        this(new FormLayout(columnSpec), border);
    }

    private SimpleForm(FormLayout layout, Border border) {
        this.layout = layout;
        this.panel = new JPanel((LayoutManager)layout);
        this.panel.setBorder(border);
        this.rowSpec = new RowSpec(this.rowAlignment + ":pref");
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public boolean hasComponents() {
        return !this.components.isEmpty();
    }

    public int getRowCount() {
        return this.layout.getRowCount();
    }

    public String getRowAlignment() {
        return this.rowAlignment;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    public void setRowAlignment(String rowAlignment) {
        this.rowAlignment = rowAlignment;
        this.rowSpec = new RowSpec(rowAlignment + ":pref");
    }

    public void setRowAlignment(String alignment, String size, String resize) {
        this.rowAlignment = alignment + ":" + size + ":" + resize;
        this.rowSpec = new RowSpec(this.rowAlignment);
    }

    public int getRowSpacing() {
        return this.rowSpacing;
    }

    public void setRowSpacing(int rowSpacing) {
        this.rowSpacing = rowSpacing;
    }

    public String getComponentValue(String label) {
        JComboBox comboBox;
        int selectedIndex;
        JComponent component = this.getComponent(label);
        if (component == null) {
            return this.hiddenValues == null ? null : this.hiddenValues.get(label);
        }
        if (component instanceof JTextComponent) {
            return ((JTextComponent)component).getText();
        }
        if (component instanceof JComboBox && (selectedIndex = (comboBox = (JComboBox)component).getSelectedIndex()) != -1) {
            if (this.comboBoxMaps.containsKey(component)) {
                Object[] keys = this.comboBoxMaps.get(comboBox);
                Object value = keys[selectedIndex];
                return (String)value == null ? null : value.toString();
            }
            Object value = comboBox.getSelectedItem();
            return (String)value == null ? null : value.toString();
        }
        if (component instanceof JList) {
            return (String)((JList)component).getSelectedValue();
        }
        if (component instanceof JCheckBox) {
            return String.valueOf(((JCheckBox)component).isSelected());
        }
        if (component instanceof JFormComponent) {
            return ((JFormComponent)((Object)component)).getValue();
        }
        return null;
    }

    public void setComponentValue(String label, String value) {
        JComponent component = this.getComponent(label);
        if (component instanceof JScrollPane) {
            component = (JComponent)((JScrollPane)component).getViewport().getComponent(0);
        }
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setText(value);
        } else if (component instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)component;
            comboBox.setSelectedItem(value);
        } else if (component instanceof JList) {
            ((JList)component).setSelectedValue(value, true);
        } else if (component instanceof JCheckBox) {
            ((JCheckBox)component).setSelected(Boolean.valueOf(value));
        } else if (component instanceof JFormComponent) {
            ((JFormComponent)((Object)component)).setValue(value);
        } else if (component instanceof RSyntaxTextArea) {
            ((RSyntaxTextArea)component).setText(value);
        }
    }

    public void getValues(Map<String, String> values) {
        for (String key : this.components.keySet()) {
            values.put(key, this.getComponentValue(key));
        }
    }

    public void setValues(Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            this.setComponentValue(entry.getKey(), entry.getValue());
        }
    }

    public void setEnabled(boolean b) {
        for (JComponent component : this.components.values()) {
            if (component instanceof JScrollPane) {
                ((JScrollPane)component).getViewport().getView().setEnabled(b);
            }
            component.setEnabled(b);
        }
    }

    public JComponent getComponent(String label) {
        return this.components.get(label);
    }

    public void setBorder(Border border) {
        this.panel.setBorder(border);
    }

    public void addInputFieldHintText(String text) {
        JLabel label = new JLabel(text);
        label.setForeground(HINT_TEXT_COLOR);
        this.addComponentWithoutLabel(label);
    }

    private void setToolTip(JComponent component, String tooltip) {
        component.setToolTipText(StringUtils.defaultIfEmpty((String)tooltip, null));
    }

    public int getDefaultTextAreaColumns() {
        return this.defaultTextAreaColumns;
    }

    public void setDefaultTextFieldColumns(int defaultTextFieldColumns) {
        this.defaultTextFieldColumns = defaultTextFieldColumns;
    }

    public void setDefaultTextAreaColumns(int defaultTextAreaColumns) {
        this.defaultTextAreaColumns = defaultTextAreaColumns;
    }

    public int getDefaultTextAreaRows() {
        return this.defaultTextAreaRows;
    }

    public void setDefaultTextAreaRows(int defaultTextAreaRows) {
        this.defaultTextAreaRows = defaultTextAreaRows;
    }

    public void appendLabelAsLink(String url, String text) {
        JLabel label = UISupport.createLabelLink(url, text);
        this.append(null, null, label, null, 2, this.getColumnSpanToTheEnd(2));
    }

    public void appendHeading(String text) {
        JLabel label = new JLabel(text);
        Font font = label.getFont();
        Font fontBold = new Font(font.getName(), 1, font.getSize());
        label.setFont(fontBold);
        this.append(null, null, label, null, 2, this.getColumnSpanToTheEnd(2));
    }

    public void appendHeadingAndHelpButton(String text, String helpUrl) {
        JLabel label = new JLabel(text);
        Font font = label.getFont();
        Font fontBold = new Font(font.getName(), 1, font.getSize());
        label.setFont(fontBold);
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 0));
        innerPanel.add(label);
        innerPanel.add(Box.createHorizontalGlue());
        innerPanel.add(UISupport.createFormButton(new ShowOnlineHelpAction(helpUrl)));
        this.append(null, null, innerPanel, null, 2, this.getColumnSpanToTheEnd(2));
    }

    public JComboBox appendComboBox(String label, Map<?, ?> values) {
        Object[] valueArray = new Object[values.size()];
        Object[] keyArray = new Object[values.size()];
        int ix = 0;
        Iterator<?> i = values.keySet().iterator();
        while (i.hasNext()) {
            keyArray[ix] = i.next();
            valueArray[ix] = values.get(keyArray[ix]);
            ++ix;
        }
        JComboBox<Object> comboBox = new JComboBox<Object>(valueArray);
        this.comboBoxMaps.put(comboBox, keyArray);
        this.append(label, comboBox);
        return comboBox;
    }

    public JComboBox appendComboBox(String label, Object[] values, String tooltip) {
        JComboBox<Object> comboBox = new JComboBox<Object>(values);
        comboBox.setToolTipText(StringUtils.defaultIfEmpty((String)tooltip, null));
        comboBox.getAccessibleContext().setAccessibleDescription(tooltip);
        this.append(label, comboBox);
        return comboBox;
    }

    public JComboBox appendComboBox(String label, ComboBoxModel model, String tooltip) {
        JComboBox comboBox = new JComboBox(model);
        comboBox.setToolTipText(StringUtils.defaultIfEmpty((String)tooltip, null));
        comboBox.getAccessibleContext().setAccessibleDescription(tooltip);
        this.append(label, comboBox);
        return comboBox;
    }

    public JCheckBox appendCheckBox(String caption, String label, boolean selected) {
        JCheckBox checkBox = new JCheckBox(label, selected);
        checkBox.getAccessibleContext().setAccessibleDescription(caption);
        this.components.put(caption, checkBox);
        this.append(caption, checkBox);
        return checkBox;
    }

    public JRadioButton appendRadioButton(String caption, String label, ButtonGroup group, boolean selected) {
        JRadioButton radioButton = new JRadioButton(label, selected);
        radioButton.getAccessibleContext().setAccessibleDescription(caption);
        if (group != null) {
            group.add(radioButton);
        }
        this.components.put(caption, radioButton);
        this.append(caption, radioButton);
        return radioButton;
    }

    public JButton addRightButton(Action action) {
        if (this.rowSpacing > 0 && !this.components.isEmpty()) {
            this.addSpace(this.rowSpacing);
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        JButton button = new JButton(action);
        this.panel.add((Component)button, this.cc.xy(4, row, "right,bottom"));
        return button;
    }

    public JButton appendButtonWithoutLabel(String text, ActionListener actionListener) {
        JButton button = new JButton(text);
        button.addActionListener(actionListener);
        this.addComponentWithoutLabel(button);
        return button;
    }

    public JButton addButtonWithoutLabelToTheRight(String text, ActionListener actionListener) {
        JButton button = new JButton(text);
        button.addActionListener(actionListener);
        this.addComponentWithoutLabel(button, "right,bottom");
        return button;
    }

    public JButton appendButton(String label, String tooltip) {
        JButton button = new JButton();
        button.setToolTipText(StringUtils.defaultIfEmpty((String)tooltip, null));
        button.getAccessibleContext().setAccessibleDescription(tooltip);
        this.append(label, button);
        return button;
    }

    public JPasswordField appendPasswordField(String label, String tooltip) {
        JPasswordField textField = new JPasswordField();
        textField.setColumns(this.defaultTextFieldColumns);
        textField.setToolTipText(StringUtils.defaultIfEmpty((String)tooltip, null));
        textField.getAccessibleContext().setAccessibleDescription(tooltip);
        this.append(label, textField);
        return textField;
    }

    public JTextArea appendTextArea(String label, String tooltip) {
        JUndoableTextArea textArea = new JUndoableTextArea();
        textArea.setColumns(this.defaultTextAreaColumns);
        textArea.setRows(this.defaultTextAreaRows);
        textArea.setAutoscrolls(true);
        textArea.add(new JScrollPane());
        this.setToolTip(textArea, tooltip);
        textArea.getAccessibleContext().setAccessibleDescription(tooltip);
        JTextComponentPopupMenu.add(textArea);
        this.append(label, new JScrollPane(textArea));
        return textArea;
    }

    public JTextField appendTextField(String label, String tooltip) {
        return this.appendTextField(label, label, tooltip, this.defaultTextFieldColumns);
    }

    public JTextField appendTextField(String label, String name, String tooltip, int textFieldColumns) {
        JUndoableTextField textField = new JUndoableTextField();
        textField.setName(name);
        textField.setColumns(textFieldColumns);
        this.setToolTip(textField, tooltip);
        textField.getAccessibleContext().setAccessibleDescription(tooltip);
        JTextComponentPopupMenu.add(textField);
        this.append(label, textField);
        return textField;
    }

    public void addHiddenValue(String name, String value) {
        if (this.hiddenValues == null) {
            this.hiddenValues = new HashMap<String, String>();
        }
        this.hiddenValues.put(name, value);
    }

    public void addSpace() {
        this.addSpace(this.rowSpacing);
    }

    public void addSpace(int size) {
        if (size > 0) {
            this.layout.appendRow(new RowSpec(size + "px"));
        }
    }

    public void appendSeparator() {
        if (this.appended && this.rowSpacing > 0) {
            this.addSpace(this.rowSpacing);
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        this.panel.add((Component)new JSeparator(), this.cc.xywh(2, row, 4, 1));
        this.appended = true;
    }

    public void addComponentWithoutLabel(JComponent component) {
        this.addComponentWithoutLabel(component, DEFAULT_COMPONENT_ALIGNMENT);
    }

    private void addComponentWithoutLabel(JComponent component, String alignment) {
        if (this.rowSpacing > 0 && !this.components.isEmpty()) {
            this.addSpace(this.rowSpacing);
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        this.panel.add((Component)component, this.cc.xy(4, row, alignment));
    }

    public <T extends JComponent> T addLeftComponent(T component) {
        if (this.rowSpacing > 0 && !this.components.isEmpty()) {
            this.addSpace(this.rowSpacing);
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        this.panel.add(component, this.cc.xy(4, row));
        return component;
    }

    public void addRightComponent(JComponent component) {
        if (this.rowSpacing > 0 && !this.components.isEmpty()) {
            this.addSpace(this.rowSpacing);
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        this.panel.add((Component)component, this.cc.xy(4, row, "right,bottom"));
    }

    public void addComponent(JComponent component) {
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        this.panel.add((Component)component, this.cc.xyw(2, row, 4));
    }

    public void removeComponent(JComponent component) {
        this.panel.remove(component);
    }

    public void appendFixed(String label, JComponent component) {
        this.append(label, component, "left:pref");
    }

    public void append(JComponent component) {
        int spaceRowIndex = -1;
        if (this.rowSpacing > 0 && this.appended) {
            this.addSpace(this.rowSpacing);
            spaceRowIndex = this.layout.getRowCount();
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        this.panel.add((Component)component, this.cc.xyw(2, row, 4));
        component.addComponentListener(new LabelHider(null, spaceRowIndex));
        this.appended = true;
    }

    public void append(String label, JComponent component) {
        this.append(label, component, null);
    }

    public <T extends JComponent> T append(String label, T component, String alignments) {
        JLabel jlabel = null;
        if (label != null) {
            jlabel = new JLabel((String)(label.endsWith(":") || label.isEmpty() ? label : label + ":"));
            jlabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
            if (this.labelFont != null) {
                jlabel.setFont(this.labelFont);
            }
        }
        return this.append(label, jlabel, component, alignments, 4, this.getColumnSpanToTheEnd(4));
    }

    public <T extends JComponent> T append(String name, JLabel label, T field) {
        return this.append(name, label, field, null, 4, this.getColumnSpanToTheEnd(4));
    }

    public void appendInOneRow(PropertyComponent ... propertyComponents) {
        Preconditions.checkArgument((propertyComponents.length * 2 <= this.layout.getColumnCount() - 1 ? 1 : 0) != 0, (Object)"There is not enough room for the components to be added");
        int currentColumn = 4;
        for (int i = 0; i < propertyComponents.length; ++i) {
            PropertyComponent propertyComponent = propertyComponents[i];
            if (i == 0) {
                this.append(null, null, propertyComponent.getComponent(), "left,center", currentColumn, 1);
            } else {
                this.addComponentToRow(null, propertyComponent.getComponent(), "left,center", currentColumn, this.getRowCount(), 1);
            }
            currentColumn += 2;
        }
    }

    private <T extends JComponent> T append(String name, JComponent label, T component, String alignments, int column, int columnSpan) {
        int spaceRowIndex = -1;
        if (this.rowSpacing > 0 && this.appended) {
            this.addSpace(this.rowSpacing);
            spaceRowIndex = this.layout.getRowCount();
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        if (label != null) {
            this.panel.add((Component)label, this.cc.xy(2, row));
            component.addComponentListener(new LabelHider(label, spaceRowIndex));
            component.addPropertyChangeListener(ENABLED_PROPERTY_NAME, new LabelEnabler(label));
            if (label instanceof JLabel) {
                JLabel jl = (JLabel)label;
                jl.setLabelFor(component);
                String text = jl.getText();
                int ix = text.indexOf(38);
                if (ix >= 0) {
                    jl.setText(text.substring(0, ix) + text.substring(ix + 1));
                    jl.setDisplayedMnemonicIndex(ix);
                    jl.setDisplayedMnemonic(text.charAt(ix + 1));
                }
                if (component.getAccessibleContext() != null) {
                    component.getAccessibleContext().setAccessibleName(text);
                }
            }
        } else {
            component.addComponentListener(new LabelHider(null, spaceRowIndex));
        }
        this.addComponentToRow(name, component, alignments, column, row, columnSpan);
        return component;
    }

    private <T extends JComponent> void addComponentToRow(String name, T component, String alignments, int column, int row, int columnSpan) {
        if (alignments == null) {
            this.panel.add(component, this.cc.xyw(column, row, columnSpan));
        } else {
            this.panel.add(component, this.cc.xyw(column, row, columnSpan, alignments));
        }
        this.components.put(name, component);
        this.appended = true;
    }

    private int getColumnSpanToTheEnd(int startingColumn) {
        return this.layout.getColumnCount() - startingColumn;
    }

    private final class LabelHider
    extends ComponentAdapter {
        private final JComponent jlabel;
        private final int rowIndex;

        public LabelHider(JComponent label, int i) {
            this.jlabel = label;
            this.rowIndex = i;
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            if (this.jlabel != null) {
                this.jlabel.setVisible(false);
            }
            if (this.rowIndex >= 0 && this.rowIndex < SimpleForm.this.layout.getRowCount()) {
                SimpleForm.this.layout.setRowSpec(this.rowIndex, new RowSpec("0px"));
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (this.jlabel != null) {
                this.jlabel.setVisible(true);
            }
            if (this.rowIndex >= 0 && this.rowIndex < SimpleForm.this.layout.getRowCount()) {
                SimpleForm.this.layout.setRowSpec(this.rowIndex, new RowSpec(SimpleForm.this.rowSpacing + "px"));
            }
        }
    }

    private static class LabelEnabler
    implements PropertyChangeListener {
        private final JComponent label;

        public LabelEnabler(JComponent label) {
            this.label = label;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.label.setEnabled((Boolean)evt.getNewValue());
        }
    }
}

