/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.support.UISupport;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.MenuSelectionManager;

class PreviewPopup
extends JPopupMenu
implements MouseListener,
MouseMotionListener {
    private JScrollPane _scrollPane;
    private JViewport _viewPort;
    private JLabel _zoomWindow;
    private JPanel _cursorLabel;
    private JLayeredPane _layeredPane;
    private int _iconWidth;
    private int _iconHeight;
    private boolean _doCloseAfterClick;
    float _ratio;
    private static int DELTA = 5;

    public PreviewPopup(JScrollPane scrollPane, boolean doCloseAfterClick) {
        this.setBorder(BorderFactory.createEtchedBorder());
        this._doCloseAfterClick = doCloseAfterClick;
        this._scrollPane = scrollPane;
        this._viewPort = this._scrollPane.getViewport();
        this._zoomWindow = new JLabel();
        this._cursorLabel = this.createCursor();
        this._layeredPane = new JLayeredPane();
        this._layeredPane.add((Component)this._zoomWindow, new Integer(0));
        this._layeredPane.add((Component)this._cursorLabel, new Integer(1));
        BufferedImage bim = new BufferedImage(1, 1, 6);
        this.setCursor(this.getToolkit().createCustomCursor(bim, new Point(0, 0), "PreviewCursor"));
        this.add(this._layeredPane);
        this._layeredPane.addMouseListener(this);
        this._layeredPane.addMouseMotionListener(this);
    }

    public void release() {
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        this._layeredPane.removeMouseListener(this);
        this._layeredPane.removeMouseMotionListener(this);
        this._scrollPane = null;
        this._layeredPane = null;
        this._viewPort = null;
    }

    public void showUpInCorner(Component c, String corner) {
        int zoomWindowImageWidth;
        if (this._viewPort.getComponentCount() == 0) {
            return;
        }
        float scaleFactor = 1.1f;
        this._ratio = (float)this._viewPort.getComponent(0).getHeight() / (float)this._viewPort.getHeight() / scaleFactor;
        if (this._ratio < 2.0f) {
            this._ratio = 2.0f;
        }
        if ((zoomWindowImageWidth = (int)((float)this._viewPort.getComponent(0).getWidth() / this._ratio)) < 10) {
            UISupport.showInfoMessage("Viewport too large for readable image, use scrollbar instead");
            return;
        }
        int zoomWindowImageHeight = (int)((float)this._viewPort.getComponent(0).getHeight() / this._ratio);
        BufferedImage capture = PreviewPopup.captureComponentViewAsBufferedImage(this._viewPort.getComponent(0));
        BufferedImage componentImage = new BufferedImage(zoomWindowImageWidth, zoomWindowImageHeight, 1);
        Graphics2D g2d = (Graphics2D)((Image)componentImage).getGraphics();
        if (zoomWindowImageWidth > 15) {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        g2d.drawImage(capture, 0, 0, zoomWindowImageWidth, zoomWindowImageHeight, null);
        g2d.dispose();
        ImageIcon componentIcon = new ImageIcon(componentImage);
        this._iconWidth = componentIcon.getIconWidth();
        this._iconHeight = componentIcon.getIconHeight();
        this._zoomWindow.setIcon(componentIcon);
        this._zoomWindow.setBounds(0, 0, this._iconWidth, this._iconHeight);
        int cursorWidth = (int)((float)this._viewPort.getWidth() / this._ratio);
        int cursorHeight = (int)((float)this._viewPort.getHeight() / this._ratio);
        this._cursorLabel.setBounds(0, 0, cursorWidth, cursorHeight);
        this._layeredPane.setPreferredSize(new Dimension(this._iconWidth, this._iconHeight));
        int dx = componentIcon.getIconWidth() + DELTA;
        int dy = componentIcon.getIconHeight() + DELTA;
        if (!corner.equals("UPPER_LEFT_CORNER")) {
            if (corner.equals("UPPER_RIGHT_CORNER")) {
                dx = -dx;
            } else if (corner.equals("LOWER_RIGHT_CORNER")) {
                dx = -dx;
                dy = -dy;
            } else if (corner.equals("LOWER_LEFT_CORNER")) {
                dy = -dy;
            }
        }
        if (dy < 0 && Math.abs(dy) > this._viewPort.getHeight()) {
            dy = -this._viewPort.getHeight() - 10;
        }
        this.show(c, dx, dy);
    }

    public JPanel createCursor() {
        JPanel label = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Composite composite = ((Graphics2D)g).getComposite();
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.2f));
                super.paintComponent(g);
                ((Graphics2D)g).setComposite(composite);
            }
        };
        label.setBorder(BorderFactory.createLineBorder(Color.gray));
        label.setVisible(false);
        label.setOpaque(true);
        label.setBackground(Color.orange.darker());
        return label;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this._cursorLabel.setVisible(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this._cursorLabel.setVisible(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._doCloseAfterClick) {
            this.setVisible(false);
            this._cursorLabel.setVisible(false);
            MenuSelectionManager.defaultManager().clearSelectedPath();
            this.setInvoker(null);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.moveCursor(e.getX(), e.getY());
        this.scrollViewPort();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.moveCursor(e.getX(), e.getY());
        this.scrollViewPort();
    }

    private void moveCursor(int x, int y) {
        int dx = x - this._cursorLabel.getWidth() / 2;
        int dy = y - this._cursorLabel.getHeight() / 2;
        this._cursorLabel.setLocation(dx, dy);
    }

    private void scrollViewPort() {
        Point cursorLocation = this._cursorLabel.getLocation();
        int dx = (int)Math.max(cursorLocation.getX(), 0.0);
        int dy = (int)Math.max(cursorLocation.getY(), 0.0);
        dx = (int)((float)dx * this._ratio);
        dy = (int)((float)dy * this._ratio);
        ((JComponent)this._viewPort.getComponent(0)).scrollRectToVisible(new Rectangle(dx, dy, this._viewPort.getWidth(), this._viewPort.getHeight()));
    }

    public static BufferedImage captureComponentViewAsBufferedImage(Component c) {
        Dimension size = c.getSize();
        BufferedImage bufferedImage = new BufferedImage(size.width, size.height, 1);
        Graphics2D bufferedGraphics = bufferedImage.createGraphics();
        c.paint(bufferedGraphics);
        return bufferedImage;
    }
}

