/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.support.components.Inspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.VTextIcon;
import com.jgoodies.looks.HeaderStyle;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class JInspectorPanelImpl
extends JPanel
implements PropertyChangeListener,
JInspectorPanel {
    private float defaultDividerLocation = 0.65f;
    private final JSplitPane mainSplit;
    private JPanel inspectorPanel;
    private int lastDividerLocation = 0;
    private JXToolBar inspectToolbar;
    private List<Inspector> inspectors = new ArrayList<Inspector>();
    private Map<Inspector, JToggleButton> inspectorButtons = new HashMap<Inspector, JToggleButton>();
    public Inspector currentInspector;
    private final int orientation;

    public JInspectorPanelImpl(JComponent contentComponent) {
        this(contentComponent, 3);
    }

    public JInspectorPanelImpl(JComponent contentComponent, int orientation) {
        super(new BorderLayout());
        this.orientation = orientation;
        this.inspectorPanel = new JPanel(new CardLayout());
        this.inspectorPanel.setVisible(false);
        this.mainSplit = new JSplitPane(orientation == 2 || orientation == 4 ? 1 : 0);
        BasicSplitPaneUI basic = (BasicSplitPaneUI)this.mainSplit.getUI();
        basic.getDivider().setBorder(new LineBorder(Color.WHITE, 1){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(c.getWidth() - 1, 0, c.getWidth() - 1, c.getHeight());
            }
        });
        this.mainSplit.setDividerSize(5);
        this.mainSplit.setBorder(null);
        this.mainSplit.setOneTouchExpandable(false);
        JXToolBar toolbar = this.createInspectButtons();
        if (orientation == 3) {
            this.mainSplit.setTopComponent(contentComponent);
            this.mainSplit.setBottomComponent(this.inspectorPanel);
            this.mainSplit.setResizeWeight(0.8);
            toolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 3, 2));
            this.add((Component)toolbar, "South");
        } else if (orientation == 2) {
            this.mainSplit.setRightComponent(contentComponent);
            JPanel p = new JPanel(new BorderLayout());
            p.add(toolbar);
            p.setBorder(new LineBorder(Color.WHITE, 1){

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    g.setColor(Color.LIGHT_GRAY);
                    g.drawLine(c.getWidth() - 1, 0, c.getWidth() - 1, c.getHeight());
                }
            });
            toolbar.setBorder(BorderFactory.createEmptyBorder(2, 3, 0, 4));
            this.mainSplit.setLeftComponent(this.inspectorPanel);
            this.mainSplit.setResizeWeight(0.2);
            toolbar.setOrientation(1);
            this.add((Component)p, "West");
        } else if (orientation == 4) {
            this.mainSplit.setLeftComponent(contentComponent);
            JPanel p = new JPanel(new BorderLayout());
            p.add(toolbar);
            toolbar.setBorder(BorderFactory.createEmptyBorder(2, 1, 0, 3));
            this.mainSplit.setRightComponent(this.inspectorPanel);
            this.mainSplit.setResizeWeight(0.8);
            toolbar.setOrientation(1);
            this.add((Component)p, "East");
        }
        this.add((Component)this.mainSplit, "Center");
    }

    private JXToolBar createInspectButtons() {
        this.inspectToolbar = new JXToolBar(){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(10, 10);
            }
        };
        this.inspectToolbar.setFloatable(false);
        this.inspectToolbar.setRollover(true);
        this.inspectToolbar.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        this.inspectToolbar.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        if (this.orientation == 1 || this.orientation == 3) {
            this.inspectToolbar.addSpace(10);
        }
        this.inspectToolbar.setBackground(Color.WHITE);
        this.inspectToolbar.setOpaque(true);
        return this.inspectToolbar;
    }

    public float getDefaultDividerLocation() {
        return this.defaultDividerLocation;
    }

    @Override
    public void setDefaultDividerLocation(float defaultDividerLocation) {
        this.defaultDividerLocation = defaultDividerLocation;
        this.setResetDividerLocation();
    }

    @Override
    public <T extends Inspector> T addInspector(T inspector) {
        if (this.inspectors.size() > 0) {
            this.inspectToolbar.addSpace(5);
        }
        this.inspectors.add(inspector);
        inspector.addPropertyChangeListener(this);
        this.inspectorPanel.add((Component)inspector.getComponent(), inspector.getInspectorId());
        JToggleButton button = new JToggleButton(new SelectInspectorAction(inspector));
        button.setName(inspector.getInspectorId());
        this.inspectorButtons.put(inspector, button);
        if (this.orientation == 2) {
            String text = button.getText();
            button.setText(null);
            button.setPreferredSize(new Dimension(17, 10));
            button.setIcon(new VTextIcon(this.inspectToolbar, text, 2));
            this.inspectToolbar.add(button);
        } else if (this.orientation == 4) {
            String text = button.getText();
            button.setText(null);
            button.setPreferredSize(new Dimension(17, 10));
            button.setIcon(new VTextIcon(this.inspectToolbar, text, 4));
            this.inspectToolbar.add(button);
        } else {
            this.inspectToolbar.add(button);
        }
        button.setMinimumSize(new Dimension(10, 10));
        this.inspectToolbar.invalidate();
        this.repaint();
        return inspector;
    }

    @Override
    public Inspector getInspector(String inspectorId) {
        for (Inspector inspector : this.inspectors) {
            if (!inspector.getInspectorId().equals(inspectorId)) continue;
            return inspector;
        }
        return null;
    }

    @Override
    public Inspector getInspectorByTitle(String title) {
        for (Inspector inspector : this.inspectors) {
            if (!inspector.getTitle().equals(title)) continue;
            return inspector;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JToggleButton toggleButton;
        if (evt.getPropertyName().equals(Inspector.ENABLED_PROPERTY) && (toggleButton = this.inspectorButtons.get(evt.getSource())) != null) {
            toggleButton.setEnabled((Boolean)evt.getNewValue());
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void release() {
        for (Inspector inspector : this.inspectors) {
            inspector.removePropertyChangeListener(this);
            inspector.release();
        }
        this.inspectors.clear();
        this.inspectorPanel.removeAll();
        this.mainSplit.removeAll();
    }

    @Override
    public List<Inspector> getInspectors() {
        return this.inspectors;
    }

    @Override
    public Inspector getCurrentInspector() {
        return this.currentInspector;
    }

    public void setInspectorsVisible(boolean b) {
        this.inspectorPanel.setVisible(b);
    }

    @Override
    public void setInspectorVisible(Inspector inspector, boolean b) {
        if (this.inspectorButtons.containsKey(inspector)) {
            if (!b && inspector == this.currentInspector) {
                this.activate(null);
            }
            this.inspectorButtons.get(inspector).setVisible(b);
        }
    }

    public void setToolbarVisible(boolean b) {
        this.inspectToolbar.setVisible(b);
    }

    public double getResizeWeight() {
        return this.mainSplit.getResizeWeight();
    }

    @Override
    public void setResizeWeight(double value) {
        this.mainSplit.setResizeWeight(value);
    }

    @Override
    public int getDividerLocation() {
        return this.mainSplit.getDividerLocation();
    }

    @Override
    public void setResetDividerLocation() {
        this.mainSplit.setDividerLocation(this.defaultDividerLocation);
    }

    @Override
    public void setDividerLocation(int dividerLocation) {
        this.mainSplit.setDividerLocation(dividerLocation);
    }

    @Override
    public void setCurrentInspector(String string) {
        for (Inspector inspector : this.inspectors) {
            if (!inspector.getTitle().equals(string)) continue;
            this.activate(inspector);
            break;
        }
    }

    @Override
    public void deactivate() {
        this.activate(null);
    }

    @Override
    public void activate(Inspector inspector) {
        if (inspector == this.currentInspector) {
            return;
        }
        if (this.currentInspector != null) {
            this.inspectorButtons.get(this.currentInspector).setSelected(false);
            this.currentInspector.deactivate();
        }
        if (inspector == null) {
            this.currentInspector = null;
            this.inspectorPanel.setVisible(false);
        } else {
            JToggleButton button = this.inspectorButtons.get(inspector);
            this.currentInspector = inspector;
            button.setSelected(true);
            button.setBackground(Color.WHITE);
            if (!this.inspectorPanel.isVisible()) {
                this.inspectorPanel.setVisible(true);
                if (this.lastDividerLocation == 0) {
                    this.mainSplit.setDividerLocation(this.defaultDividerLocation);
                } else {
                    this.mainSplit.setDividerLocation(this.lastDividerLocation);
                }
            }
            CardLayout cards = (CardLayout)this.inspectorPanel.getLayout();
            cards.show(this.inspectorPanel, inspector.getInspectorId());
            this.currentInspector.activate();
        }
    }

    @Override
    public void setContentComponent(JComponent content) {
        this.mainSplit.setTopComponent(content);
    }

    @Override
    public void removeInspector(Inspector inspector) {
        if (this.currentInspector == inspector) {
            this.deactivate();
        }
        inspector.release();
        this.inspectors.remove(inspector);
        JToggleButton toggleButton = this.inspectorButtons.get(inspector);
        int ix = this.inspectToolbar.getComponentIndex(toggleButton);
        if (ix > 1) {
            this.inspectToolbar.remove(ix - 1);
        }
        this.inspectToolbar.remove(toggleButton);
        this.inspectorPanel.remove(inspector.getComponent());
        this.inspectToolbar.repaint();
        this.inspectorButtons.remove(inspector);
    }

    public class SelectInspectorAction
    extends AbstractAction
    implements PropertyChangeListener {
        private final Inspector inspector;

        public SelectInspectorAction(Inspector inspector) {
            super(inspector.getTitle());
            this.inspector = inspector;
            this.putValue("ShortDescription", inspector.getDescription());
            this.putValue("SmallIcon", inspector.getIcon());
            this.setEnabled(inspector.isEnabled());
            inspector.addPropertyChangeListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JToggleButton button = (JToggleButton)JInspectorPanelImpl.this.inspectorButtons.get(this.inspector);
            if (!button.isSelected()) {
                JInspectorPanelImpl.this.deactivate();
            } else {
                JInspectorPanelImpl.this.activate(this.inspector);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(Inspector.TITLE_PROPERTY)) {
                this.putValue("Name", evt.getNewValue());
            } else if (evt.getPropertyName().equals(Inspector.ICON_PROPERTY)) {
                this.putValue("SmallIcon", evt.getNewValue());
            } else if (evt.getPropertyName().equals(Inspector.DESCRIPTION_PROPERTY)) {
                this.putValue("ShortDescription", evt.getNewValue());
            } else if (evt.getPropertyName().equals(Inspector.ENABLED_PROPERTY)) {
                boolean enable = (Boolean)evt.getNewValue();
                this.setEnabled(enable);
                if (!enable && JInspectorPanelImpl.this.currentInspector == this.inspector) {
                    ((JToggleButton)JInspectorPanelImpl.this.inspectorButtons.get(JInspectorPanelImpl.this.currentInspector)).setSelected(false);
                }
            }
        }
    }
}

