/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.support.components.Inspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class JComponentInspector<T extends JComponent>
implements Inspector {
    private final T component;
    private String title;
    private String description;
    private boolean enabled;
    private PropertyChangeSupport propertyChangeSupport;
    private ImageIcon imageIcon;
    private String id;

    public JComponentInspector(T component, String title, String description, boolean enabled) {
        this.component = component;
        this.title = title;
        this.id = title;
        this.description = description;
        this.enabled = enabled;
    }

    @Override
    public void activate() {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public T getComponent() {
        return this.component;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getInspectorId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void release() {
    }

    public void setDescription(String description) {
        String old = this.description;
        this.description = description;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(Inspector.DESCRIPTION_PROPERTY, old, description);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            return;
        }
        this.enabled = enabled;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(Inspector.ENABLED_PROPERTY, !enabled, enabled);
        }
    }

    public void setTitle(String title) {
        String old = this.title;
        this.title = title;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(Inspector.TITLE_PROPERTY, old, title);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    @Override
    public ImageIcon getIcon() {
        return this.imageIcon;
    }

    public void setIcon(ImageIcon imageIcon) {
        ImageIcon old = this.imageIcon;
        this.imageIcon = imageIcon;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(Inspector.ICON_PROPERTY, old, imageIcon);
        }
    }

    @Override
    public void deactivate() {
    }
}

