/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JCollapsiblePanel
extends JPanel {
    private static final String HIGHLIGHT_SIGN = "* ";
    private ImageIcon minusIcon;
    private ImageIcon plusIcon;
    private JPanel contentPanel;
    private JXToolBar toolbar;
    private ToggleAction toggleAction;
    private JLabel titleLabel;
    private String nonHighlightedTitle;

    public JCollapsiblePanel(JPanel contentPanel, String title) {
        super(new BorderLayout());
        this.contentPanel = contentPanel;
        this.minusIcon = UISupport.createImageIcon("/button1.gif");
        this.plusIcon = UISupport.createImageIcon("/button2.gif");
        this.add((Component)contentPanel, "Center");
        this.add((Component)this.startToolbar(title), "North");
    }

    public JCollapsiblePanel(String title) {
        this(new JPanel(), title);
    }

    private JXToolBar startToolbar(String title) {
        this.toolbar = UISupport.createToolbar();
        this.toolbar.setBorder(null);
        this.toolbar.setPreferredSize(new Dimension(22, 22));
        this.toggleAction = new ToggleAction();
        JButton toggleButton = new JButton(this.toggleAction);
        toggleButton.setBorder(null);
        toggleButton.setPreferredSize(new Dimension(15, 15));
        this.toolbar.addSpace(3);
        this.toolbar.addFixed(toggleButton);
        this.toolbar.addSpace(3);
        if (title != null) {
            this.nonHighlightedTitle = title;
            this.titleLabel = new JLabel(title);
            this.titleLabel.setPreferredSize(new Dimension(500, 0));
            this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
            this.toolbar.addFixed(this.titleLabel);
            this.toolbar.addSpace(3);
        }
        return this.toolbar;
    }

    public boolean isExpanded() {
        return this.toggleAction.getValue("SmallIcon") == this.getMinusIcon();
    }

    public void setExpanded(boolean expanded) {
        if (!expanded) {
            this.toggleAction.setShow();
        } else {
            this.toggleAction.setHide();
        }
        this.contentPanel.setVisible(expanded);
        this.refresh();
    }

    private void refresh() {
        this.contentPanel.revalidate();
        if (this.contentPanel.getParent() instanceof JComponent) {
            ((JComponent)this.contentPanel.getParent()).revalidate();
        }
    }

    public void setContentPanel(JPanel panel) {
        this.remove(this.contentPanel);
        this.add((Component)panel, "Center");
        this.contentPanel = panel;
        this.refresh();
    }

    public JXToolBar getToolbar() {
        return this.toolbar;
    }

    public ImageIcon getMinusIcon() {
        return this.minusIcon;
    }

    public void setMinusIcon(ImageIcon minusIcon) {
        this.minusIcon = minusIcon;
    }

    public ImageIcon getPlusIcon() {
        return this.plusIcon;
    }

    public void setPlusIcon(ImageIcon plusIcon) {
        this.plusIcon = plusIcon;
    }

    public void setHighlightedTitle(boolean highlightedTitle) {
        if (highlightedTitle) {
            if (!this.titleLabel.getText().startsWith(HIGHLIGHT_SIGN)) {
                this.titleLabel.setText(HIGHLIGHT_SIGN + this.nonHighlightedTitle);
            }
        } else {
            this.titleLabel.setText(this.nonHighlightedTitle);
        }
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    private class ToggleAction
    extends AbstractAction {
        public ToggleAction() {
            this.setHide();
        }

        public void setHide() {
            this.putValue("SmallIcon", JCollapsiblePanel.this.getMinusIcon());
            this.putValue("ShortDescription", "Hides the content of this block");
        }

        public void setShow() {
            this.putValue("SmallIcon", JCollapsiblePanel.this.getPlusIcon());
            this.putValue("ShortDescription", "Shows the content of this block");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCollapsiblePanel.this.setExpanded(!JCollapsiblePanel.this.isExpanded());
        }
    }
}

