/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.actions.oauth.BrowserListener;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.components.PagePropertyMapper;
import com.eviware.soapui.support.components.WebViewBasedBrowserComponent;
import com.eviware.soapui.support.components.WebViewNavigationBar;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.HeadlessException;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import netscape.javascript.JSObject;
import org.apache.commons.lang.StringUtils;

class EnabledWebViewBasedBrowserComponent
implements WebViewBasedBrowserComponent {
    public static final String CHARSET_PATTERN = "(.+)(;\\s*charset=)(.+)";
    public static final String DEFAULT_ERROR_PAGE = "<html><body><h1>The page could not be loaded</h1></body></html>";
    private Pattern charsetFinderPattern = Pattern.compile("(.+)(;\\s*charset=)(.+)");
    private JPanel panel = new JPanel(new BorderLayout());
    private String errorPage;
    private boolean showingErrorPage;
    public String url;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private List<BrowserListener> listeners = new ArrayList<BrowserListener>();
    public WebView webView;
    private WebViewNavigationBar navigationBar;
    private String lastLocation;
    private Set<BrowserWindow> browserWindows = new HashSet<BrowserWindow>();
    private JFXPanel browserPanel;
    private WebViewBasedBrowserComponent.PopupStrategy popupStrategy;

    EnabledWebViewBasedBrowserComponent(boolean addNavigationBar, WebViewBasedBrowserComponent.PopupStrategy popupStrategy) {
        this.popupStrategy = popupStrategy;
        this.initializeWebView(addNavigationBar);
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    private void initializeWebView(boolean addNavigationBar) {
        if (addNavigationBar) {
            this.navigationBar = new WebViewNavigationBar();
            this.panel.add(this.navigationBar.getComponent(), "North");
        }
        JFXPanel browserPanel = new JFXPanel();
        this.panel.add((Component)browserPanel, "Center");
        WebViewInitialization webViewInitialization = new WebViewInitialization(browserPanel);
        if (Platform.isFxApplicationThread()) {
            webViewInitialization.run();
        } else {
            Platform.runLater((Runnable)webViewInitialization);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (EnabledWebViewBasedBrowserComponent.this.navigationBar != null) {
                    EnabledWebViewBasedBrowserComponent.this.navigationBar.focusUrlField();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private String readDocumentAsString() throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(this.getWebEngine().getDocument()), new StreamResult(stringWriter));
        return stringWriter.getBuffer().toString().replaceAll("\n|\r", "");
    }

    private void addKeyboardFocusManager(final JFXPanel browserPanel) {
        KeyboardFocusManager kfm = DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == browserPanel && e.getID() == 400 && e.getKeyChar() == '\n') {
                    e.setKeyChar('\r');
                }
                return false;
            }
        });
    }

    @Override
    public void executeJavaScript(final String script) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    EnabledWebViewBasedBrowserComponent.this.webView.getEngine().executeScript(script);
                    for (BrowserListener listener : EnabledWebViewBasedBrowserComponent.this.listeners) {
                        listener.javaScriptExecuted(script, null, null);
                    }
                }
                catch (Exception e) {
                    SoapUI.log.warn("Error executing JavaScript [" + script + "]", (Throwable)e);
                    for (BrowserListener listener : EnabledWebViewBasedBrowserComponent.this.listeners) {
                        listener.javaScriptExecuted(script, EnabledWebViewBasedBrowserComponent.this.lastLocation, e);
                    }
                }
            }
        });
    }

    @Override
    public void addJavaScriptEventHandler(final String memberName, final Object eventHandler) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EnabledWebViewBasedBrowserComponent.this.getWebEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                    public void changed(ObservableValue observableValue, Worker.State oldState, Worker.State newState) {
                        if (newState == Worker.State.SUCCEEDED) {
                            JSObject window = (JSObject)EnabledWebViewBasedBrowserComponent.this.getWebEngine().executeScript("window");
                            window.setMember(memberName, eventHandler);
                        }
                    }
                });
            }
        });
    }

    @Override
    public PagePropertyMapper getPagePropertyMapper() {
        return new PagePropertyMapper(){

            @Override
            public void update(final String name, final Object newValue) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Object o = EnabledWebViewBasedBrowserComponent.this.getWebEngine().executeScript("window.propertyUpdater");
                        if (!(o instanceof JSObject)) {
                            Platform.runLater((Runnable)this);
                            return;
                        }
                        JSObject updater = (JSObject)o;
                        updater.call("update", name, newValue);
                    }
                });
            }
        };
    }

    @Override
    public void close(boolean cascade) {
        if (cascade) {
            Iterator<BrowserWindow> iterator = this.browserWindows.iterator();
            while (iterator.hasNext()) {
                iterator.next().close();
                iterator.remove();
            }
        }
        for (BrowserListener listener : this.listeners) {
            listener.browserClosed();
        }
        this.release();
    }

    private void release() {
        this.setContent("");
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EnabledWebViewBasedBrowserComponent.this.browserPanel.setScene(null);
            }
        });
    }

    @Override
    public void setContent(final String contentAsString, final String contentType) {
        if (SoapUI.isBrowserDisabled()) {
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EnabledWebViewBasedBrowserComponent.this.getWebEngine().loadContent(contentAsString, EnabledWebViewBasedBrowserComponent.this.removeCharsetFrom(contentType));
            }
        });
    }

    private String removeCharsetFrom(String contentType) {
        Matcher matcher = this.charsetFinderPattern.matcher(contentType);
        return matcher.matches() ? matcher.group(1) : contentType;
    }

    @Override
    public void setContent(final String contentAsString) {
        if (SoapUI.isBrowserDisabled()) {
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EnabledWebViewBasedBrowserComponent.this.getWebEngine().loadContent(contentAsString);
            }
        });
        this.pcs.firePropertyChange("content", null, contentAsString);
    }

    private WebEngine getWebEngine() {
        return this.webView.getEngine();
    }

    public String getContent() {
        return this.webView == null ? null : XmlUtils.serialize(this.getWebEngine().getDocument());
    }

    public String getUrl() {
        return this.url;
    }

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    @Override
    public void navigate(String url) {
        this.navigate(url, DEFAULT_ERROR_PAGE);
    }

    @Override
    public void navigate(final String url, String backupUrl) {
        if (SoapUI.isBrowserDisabled()) {
            return;
        }
        this.loadUrl(url);
        if (StringUtils.isNotBlank((String)backupUrl)) {
            SoapUI.getThreadPool().submit(new BrowserFallbackTask(url, backupUrl));
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EnabledWebViewBasedBrowserComponent.this.getWebEngine().load(url);
            }
        });
    }

    private void loadUrl(String url) {
        Platform.runLater(() -> this.getWebEngine().load(url));
        this.url = url;
    }

    public static boolean verifyReturnCode(String urlString) {
        try {
            URL url;
            URLConnection urlConnection;
            int neededIndex = urlString.indexOf("?");
            if (neededIndex != -1) {
                urlString = urlString.substring(0, neededIndex);
            }
            if ((urlConnection = (url = new URL(urlString)).openConnection()) instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                int statusCode = httpURLConnection.getResponseCode();
                return statusCode == 200;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void addBrowserStateListener(BrowserListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeBrowserStateListener(BrowserListener listener) {
        this.listeners.remove(listener);
    }

    private class WebViewInitialization
    implements Runnable {
        public WebViewInitialization(JFXPanel browserPanel) {
            EnabledWebViewBasedBrowserComponent.this.browserPanel = browserPanel;
        }

        @Override
        public void run() {
            EnabledWebViewBasedBrowserComponent.this.webView = new WebView();
            this.createPopupHandler();
            this.listenForLocationChanges();
            this.listenForStateChanges();
            if (EnabledWebViewBasedBrowserComponent.this.navigationBar != null) {
                EnabledWebViewBasedBrowserComponent.this.navigationBar.initialize(EnabledWebViewBasedBrowserComponent.this.getWebEngine(), EnabledWebViewBasedBrowserComponent.this);
            }
            EnabledWebViewBasedBrowserComponent.this.browserPanel.setScene(this.createJfxScene());
            EnabledWebViewBasedBrowserComponent.this.addKeyboardFocusManager(EnabledWebViewBasedBrowserComponent.this.browserPanel);
        }

        private Scene createJfxScene() {
            Group jfxComponentGroup = new Group();
            Scene scene = new Scene((Parent)jfxComponentGroup);
            EnabledWebViewBasedBrowserComponent.this.webView.prefWidthProperty().bind((ObservableValue)scene.widthProperty());
            EnabledWebViewBasedBrowserComponent.this.webView.prefHeightProperty().bind((ObservableValue)scene.heightProperty());
            jfxComponentGroup.getChildren().add((Object)EnabledWebViewBasedBrowserComponent.this.webView);
            return scene;
        }

        private void createPopupHandler() {
            switch (EnabledWebViewBasedBrowserComponent.this.popupStrategy) {
                case INTERNAL_BROWSER_NEW_WINDOW: {
                    EnabledWebViewBasedBrowserComponent.this.webView.getEngine().setCreatePopupHandler((Callback)new Callback<PopupFeatures, WebEngine>(){

                        public WebEngine call(PopupFeatures pf) {
                            BrowserWindow popupWindow = new BrowserWindow(pf);
                            EnabledWebViewBasedBrowserComponent.this.browserWindows.add(popupWindow);
                            popupWindow.setSize(800, 600);
                            popupWindow.setVisible(true);
                            return popupWindow.browser.getWebEngine();
                        }
                    });
                    break;
                }
                case EXTERNAL_BROWSER: {
                    EnabledWebViewBasedBrowserComponent.this.webView.getEngine().setCreatePopupHandler((Callback)new Callback<PopupFeatures, WebEngine>(){

                        public WebEngine call(PopupFeatures pf) {
                            final WebEngine webEngine = new WebEngine();
                            webEngine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

                                public void changed(ObservableValue<? extends String> observableValue, String oldValue, String newValue) {
                                    observableValue.removeListener((ChangeListener)this);
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            webEngine.loadContent("");
                                        }
                                    });
                                    Tools.openURL(newValue);
                                }
                            });
                            return webEngine;
                        }
                    });
                    break;
                }
                case DISABLED: {
                    EnabledWebViewBasedBrowserComponent.this.webView.getEngine().setCreatePopupHandler((Callback)new Callback<PopupFeatures, WebEngine>(){

                        public WebEngine call(PopupFeatures pf) {
                            return null;
                        }
                    });
                    break;
                }
            }
        }

        private void listenForLocationChanges() {
            EnabledWebViewBasedBrowserComponent.this.webView.getEngine().locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observableValue, String oldLocation, String newLocation) {
                    EnabledWebViewBasedBrowserComponent.this.lastLocation = newLocation;
                    for (BrowserListener listener : EnabledWebViewBasedBrowserComponent.this.listeners) {
                        listener.locationChanged(newLocation);
                    }
                }
            });
        }

        private void listenForStateChanges() {
            EnabledWebViewBasedBrowserComponent.this.webView.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void changed(ObservableValue value, Worker.State oldState, Worker.State newState) {
                    if (newState == Worker.State.SUCCEEDED) {
                        try {
                            if (EnabledWebViewBasedBrowserComponent.this.getWebEngine().getDocument() == null) return;
                            String output = EnabledWebViewBasedBrowserComponent.this.readDocumentAsString();
                            for (BrowserListener listener : EnabledWebViewBasedBrowserComponent.this.listeners) {
                                listener.contentChanged(output);
                            }
                            return;
                        }
                        catch (Exception ex) {
                            SoapUI.logError(ex, "Error processing state change to " + newState);
                            return;
                        }
                    }
                    if (newState != Worker.State.FAILED || EnabledWebViewBasedBrowserComponent.this.showingErrorPage) return;
                    try {
                        EnabledWebViewBasedBrowserComponent.this.showingErrorPage = true;
                        EnabledWebViewBasedBrowserComponent.this.setContent(EnabledWebViewBasedBrowserComponent.this.errorPage == null ? EnabledWebViewBasedBrowserComponent.DEFAULT_ERROR_PAGE : EnabledWebViewBasedBrowserComponent.this.errorPage);
                        return;
                    }
                    finally {
                        EnabledWebViewBasedBrowserComponent.this.showingErrorPage = false;
                    }
                }
            });
        }
    }

    private class BrowserWindow
    extends JFrame {
        private final EnabledWebViewBasedBrowserComponent browser;

        private BrowserWindow(PopupFeatures popupFeatures) throws HeadlessException {
            super("Browser");
            this.setIconImages(SoapUI.getFrameIcons());
            this.browser = new EnabledWebViewBasedBrowserComponent(popupFeatures.hasToolbar(), EnabledWebViewBasedBrowserComponent.this.popupStrategy);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add(this.browser.getComponent());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    BrowserWindow.this.browser.close(false);
                }
            });
        }

        public void close() {
            this.setVisible(false);
            this.dispose();
            this.browser.close(true);
            this.browser.release();
        }
    }

    private class BrowserFallbackTask
    implements Runnable {
        private final String url;
        private final String backupUrl;

        public BrowserFallbackTask(String url, String backupUrl) {
            this.url = url;
            this.backupUrl = backupUrl;
        }

        @Override
        public void run() {
            if (!EnabledWebViewBasedBrowserComponent.verifyReturnCode(this.url)) {
                EnabledWebViewBasedBrowserComponent.this.loadUrl(this.backupUrl);
            }
        }
    }
}

