/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.action;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.ActionMappingPositionTypeConfig;
import com.eviware.soapui.config.SoapUIActionConfig;
import com.eviware.soapui.config.SoapUIActionGroupConfig;
import com.eviware.soapui.config.SoapUIActionMappingConfig;
import com.eviware.soapui.config.SoapUIActionsConfig;
import com.eviware.soapui.config.SoapuiActionsDocumentConfig;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.action.SoapUIAction;
import com.eviware.soapui.support.action.SoapUIActionGroup;
import com.eviware.soapui.support.action.SoapUIActionMapping;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.soapui.support.action.support.DefaultActionMapping;
import com.eviware.soapui.support.action.support.DefaultSoapUIActionGroup;
import com.eviware.soapui.support.action.support.SoapUIActionMappingList;
import com.eviware.soapui.support.action.support.StandaloneActionMapping;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class SoapUIActionRegistry {
    private Map<String, SoapUIAction> actions = new HashMap<String, SoapUIAction>();
    private Map<String, SoapUIActionGroup> actionGroups = new HashMap<String, SoapUIActionGroup>();

    public void addAction(String soapuiActionID, SoapUIAction action) {
        this.actions.put(soapuiActionID, action);
    }

    public SoapUIActionGroup findGroupWithClass(Class<? extends SoapUIActionGroup> aClass) {
        for (SoapUIActionGroup soapUIActionGroup : this.actionGroups.values()) {
            if (!soapUIActionGroup.getClass().equals(aClass)) continue;
            return soapUIActionGroup;
        }
        throw new IllegalArgumentException("Action group not found for class " + aClass);
    }

    public void removeAction(String soapuiActionID) {
        this.actions.remove(soapuiActionID);
    }

    public SoapUIAction getAction(String soapUIActionId) {
        SoapUIAction soapUIAction = this.actions.get(soapUIActionId);
        if (soapUIAction == null) {
            System.err.println("Missing action [" + soapUIActionId + "]");
        }
        return soapUIAction;
    }

    public SoapUIActionRegistry(InputStream config) {
        this.addAction("SeperatorAction", SeperatorAction.INSTANCE);
        if (config != null) {
            this.addConfig(config, SoapUI.class.getClassLoader());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfig(InputStream config, ClassLoader classLoader) {
        try {
            SoapuiActionsDocumentConfig configDocument = SoapuiActionsDocumentConfig.Factory.parse(config);
            SoapUIActionsConfig soapuiActions = configDocument.getSoapuiActions();
            for (SoapUIActionConfig action : soapuiActions.getActionList()) {
                try {
                    String id = action.getId();
                    Class<?> actionClass = Class.forName(action.getActionClass(), true, classLoader);
                    this.addAction(id, (SoapUIAction)actionClass.newInstance());
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                    e.printStackTrace();
                }
            }
            for (SoapUIActionGroupConfig group : soapuiActions.getActionGroupList()) {
                SoapUIActionGroup actionGroup;
                String groupId = group.getId();
                if (this.actionGroups.containsKey(groupId)) {
                    actionGroup = this.actionGroups.get(groupId);
                    if (group.isSetClass1()) {
                        actionGroup = this.createActionGroupClassFromConfig(group);
                        this.addActionGroup(actionGroup, groupId);
                    }
                    this.addMappings(actionGroup, group);
                    continue;
                }
                actionGroup = group.isSetClass1() ? this.createActionGroupClassFromConfig(group) : new DefaultSoapUIActionGroup(groupId, group.getName());
                this.addMappings(actionGroup, group);
                this.addActionGroup(actionGroup, groupId);
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        finally {
            try {
                config.close();
            }
            catch (IOException e) {
                SoapUI.logError(e);
            }
        }
    }

    SoapUIActionGroup addActionGroup(SoapUIActionGroup actionGroup, String groupId) {
        return this.actionGroups.put(groupId, actionGroup);
    }

    private SoapUIActionGroup createActionGroupClassFromConfig(SoapUIActionGroupConfig group) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> actionGroupClass = Class.forName(group.getClass1());
        Constructor<?> constructor = actionGroupClass.getConstructor(String.class, String.class);
        SoapUIActionGroup actionGroup = constructor != null ? (SoapUIActionGroup)constructor.newInstance(group.getId(), group.getName()) : (SoapUIActionGroup)actionGroupClass.newInstance();
        return actionGroup;
    }

    private void addMappings(SoapUIActionGroup actionGroup, SoapUIActionGroupConfig groupConfig) {
        for (SoapUIActionMappingConfig mapping : groupConfig.getActionMappingList()) {
            try {
                int insertIndex = -1;
                if (mapping.isSetPosition() && mapping.isSetPositionRef()) {
                    insertIndex = actionGroup.getMappingIndex(mapping.getPositionRef());
                    if (mapping.getPosition() == ActionMappingPositionTypeConfig.AFTER) {
                        ++insertIndex;
                    }
                }
                if (mapping.isSetGroupId()) {
                    SoapUIActionGroupAction actionListAction = new SoapUIActionGroupAction(mapping.getName(), mapping.getDescription(), mapping.getGroupId());
                    StandaloneActionMapping actionMapping = new StandaloneActionMapping(actionListAction);
                    actionGroup.addMapping(mapping.getGroupId(), insertIndex, actionMapping);
                    if (mapping.isSetName()) {
                        actionMapping.setName(mapping.getName());
                    }
                    if (!mapping.isSetDescription()) continue;
                    actionMapping.setDescription(mapping.getDescription());
                    continue;
                }
                if (mapping.getActionId().equals("SeperatorAction")) {
                    actionGroup.addMapping("SeperatorAction", insertIndex, SeperatorAction.getDefaultMapping());
                    continue;
                }
                DefaultActionMapping actionMapping = new DefaultActionMapping(mapping.getActionId(), mapping.getKeyStroke(), mapping.getIconPath(), mapping.getActionId().equals(groupConfig.getDefault()), mapping.getParam());
                actionGroup.addMapping(mapping.getActionId(), insertIndex, actionMapping);
                if (mapping.isSetName()) {
                    actionMapping.setName(mapping.getName());
                }
                if (!mapping.isSetDescription()) continue;
                actionMapping.setDescription(mapping.getDescription());
            }
            catch (Exception e) {
                System.err.println("Error initializing ActionMapping: " + e);
                SoapUI.logError(e);
            }
        }
    }

    public <T extends ModelItem> SoapUIActionGroup<T> getActionGroup(String groupId) {
        return this.actionGroups.get(groupId);
    }

    public void performAction(String soapUIActionId, ModelItem modelItem, Object param) {
        SoapUIAction action = this.getAction(soapUIActionId);
        if (action != null) {
            action.perform(modelItem, param);
        }
    }

    public SoapUIActionGroup addActionGroup(SoapUIActionGroup actionGroup) {
        return this.addActionGroup(actionGroup, actionGroup.getId());
    }

    public static class SeperatorAction
    extends AbstractSoapUIAction {
        public static final String SOAPUI_ACTION_ID = "SeperatorAction";
        public static SeperatorAction INSTANCE = new SeperatorAction();
        private static SoapUIActionMapping defaultMapping = new DefaultActionMapping("SeperatorAction", null, null, false, null);

        public SeperatorAction() {
            super(null, null);
        }

        @Override
        public void perform(ModelItem target, Object param) {
        }

        public static SoapUIActionMapping getDefaultMapping() {
            return defaultMapping;
        }
    }

    public static class SoapUIActionGroupAction<T extends ModelItem>
    extends AbstractSoapUIAction<T> {
        private SoapUIActionGroup actionGroup;
        private final String actionGroupId;
        private boolean insert;

        public SoapUIActionGroupAction(String name, String description, String actionGroupId) {
            super(name, description);
            this.actionGroupId = actionGroupId;
        }

        public SoapUIActionGroup getActionGroup() {
            if (this.actionGroup == null) {
                this.actionGroup = SoapUI.getActionRegistry().getActionGroup(this.actionGroupId);
            }
            return this.actionGroup;
        }

        @Override
        public void perform(T target, Object param) {
            SoapUIActionGroup group = this.getActionGroup();
            SoapUIActionMappingList<T> mappings = group.getActionMappings(target);
            for (SoapUIActionMapping soapUIActionMapping : mappings) {
                if (!soapUIActionMapping.isDefault()) continue;
                soapUIActionMapping.getAction().perform(target, param);
            }
        }

        public void setInsert(boolean insert) {
            this.insert = insert;
        }

        public boolean isInsert() {
            return this.insert;
        }
    }
}

