/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.support.DateObjectSerializer;
import com.eviware.soapui.support.NullPathNode;
import com.eviware.soapui.support.StringUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.util.Date;
import net.sf.json.JSON;
import net.sf.json.JSONNull;
import net.sf.json.JSONSerializer;
import net.sf.json.groovy.JsonSlurper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonUtil {
    public static boolean REMOVE_D_ELEMENT = true;
    private static final String WHILE_1 = "while(1);";
    private static final String CLOSING_BRACKETS_WITH_COMMA = ")]}',";
    private static final String CLOSING_BRACKETS = ")]}'";
    private static final String EMPTY_FOR = "for(;;);";
    private static final String D_PREFIXED = "{\"d\":";
    private static final String[] VULNERABILITY_TOKENS = new String[]{"while(1);", ")]}',", ")]}'", "for(;;);"};
    private static final String DEFAULT_INDENT = "   ";
    private static final Logger log = LogManager.getLogger(JsonUtil.class);
    private static ObjectMapper mapper;
    private static JacksonJsonNodeJsonProvider defaultNodeProvider;
    private static Configuration configuration;
    private static DefaultPrettyPrinter printer;

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static Configuration getDefaultConfiguration() {
        return configuration;
    }

    private static void initStaticVariables() {
        mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        mapper.setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true));
        SimpleModule module = new SimpleModule();
        module.addSerializer(Date.class, (JsonSerializer)new DateObjectSerializer());
        mapper.registerModule((Module)module);
        defaultNodeProvider = new JacksonJsonProvider(mapper);
        configuration = Configuration.builder().jsonProvider((JsonProvider)defaultNodeProvider).mappingProvider((MappingProvider)new JacksonMappingProvider(mapper)).build();
        DefaultIndenter indenter = new DefaultIndenter(DEFAULT_INDENT, DefaultIndenter.SYS_LF);
        printer = new DefaultPrettyPrinter();
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
    }

    public static boolean isValidJson(String value) {
        try {
            JSON json = new JsonSlurper().parseText(value);
            return json != null && !(json instanceof JSONNull);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean seemsToBeJsonContentType(String contentType) {
        return contentType != null && (contentType.contains("javascript") || contentType.contains("json"));
    }

    public static boolean seemsToBeJson(String content) {
        if (!StringUtils.hasContent(content)) {
            return false;
        }
        try {
            new JsonSlurper().parseText(content);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public JSON parseTrimmedText(String text) {
        if (text == null) {
            return null;
        }
        String trimmedText = text.trim();
        if (trimmedText.startsWith(WHILE_1)) {
            trimmedText = trimmedText.substring(WHILE_1.length()).trim();
        }
        return JSONSerializer.toJSON((Object)trimmedText);
    }

    public static String format(Object json) {
        if (json instanceof JsonNode) {
            try {
                return mapper.writer((PrettyPrinter)printer).writeValueAsString(json);
            }
            catch (JsonProcessingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return json.toString();
    }

    public static JsonNode parseTrimmedTextToJsonNode(String text) throws IOException {
        if (text == null) {
            return null;
        }
        String trimmedText = JsonUtil.removeVulnerabilityTokens(text).trim();
        return JsonUtil.getJson(trimmedText);
    }

    public static String removeVulnerabilityTokens(String inputJsonString) {
        if (inputJsonString == null) {
            return null;
        }
        String outputString = inputJsonString.trim();
        for (String vulnerabilityToken : VULNERABILITY_TOKENS) {
            if (!outputString.startsWith(vulnerabilityToken)) continue;
            outputString = outputString.substring(vulnerabilityToken.length()).trim();
        }
        if (REMOVE_D_ELEMENT && outputString.startsWith(D_PREFIXED) && outputString.endsWith("}")) {
            outputString = outputString.substring(D_PREFIXED.length(), outputString.length() - 1).trim();
        }
        return outputString;
    }

    public static JsonNode getJson(String value) throws IOException {
        return JsonUtil.getJson(value, mapper);
    }

    private static JsonNode getJson(String value, ObjectMapper mapper) throws IOException {
        JsonNode json = mapper.readTree(value);
        return json instanceof NullNode || json instanceof MissingNode ? null : json;
    }

    static {
        JsonUtil.initStaticVariables();
    }

    private static class JacksonJsonProvider
    extends JacksonJsonNodeJsonProvider {
        public JacksonJsonProvider(ObjectMapper objectMapper) {
            super(objectMapper);
        }

        public void setArrayIndex(Object array, int index, Object newValue) {
            if (!this.isArray(array)) {
                throw new UnsupportedOperationException();
            }
            ArrayNode arrayNode = (ArrayNode)array;
            this.removeDefaultNullNode(arrayNode);
            if (index == arrayNode.size()) {
                arrayNode.add(this.createJsonElement(newValue));
            } else {
                arrayNode.set(index, this.createJsonElement(newValue));
            }
        }

        private void removeDefaultNullNode(ArrayNode node) {
            if (node.size() == 1 && node.get(0).getNodeType() == null) {
                node.remove(0);
            }
        }

        public Object createArray() {
            ArrayNode node = JsonNodeFactory.instance.arrayNode();
            node.add((JsonNode)new NullPathNode());
            return node;
        }

        public Object getArrayIndex(Object obj, int idx) {
            Object arrayElement = super.getArrayIndex(obj, idx);
            return arrayElement != null ? arrayElement : new NullPathNode();
        }

        private JsonNode createJsonElement(Object o) {
            if (o != null) {
                return o instanceof JsonNode ? (JsonNode)o : this.objectMapper.valueToTree(o);
            }
            return null;
        }

        public Object unwrap(Object o) {
            if (o == null || o instanceof NullPathNode) {
                return null;
            }
            return super.unwrap(o);
        }
    }
}

