/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.SoapUI;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;

public class ClasspathHacker {
    private static void addFile(String s) throws IOException {
        File f = new File(s);
        ClasspathHacker.addFile(f);
    }

    private static void addFile(File f) throws IOException {
        ClasspathHacker.addURL(f.toURI().toURL());
    }

    private static void addURL(URL u) throws IOException {
        ClassLoader classLoader = SoapUI.class.getClassLoader();
        ClasspathHacker.addUrlToClassLoader(u, classLoader);
    }

    private static void addUrlToClassLoader(URL u, ClassLoader classLoader) throws IOException {
        try {
            Method method = classLoader.getClass().getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, u);
            SoapUI.log.info("Added [" + u.toString() + "] to classpath");
        }
        catch (NoSuchMethodException e) {
            try {
                Method method = classLoader.getClass().getSuperclass().getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)classLoader, u);
                SoapUI.log.info("Added [" + u.toString() + "] to classpath");
            }
            catch (NoSuchMethodException ex) {
                try {
                    Method method = classLoader.getClass().getSuperclass().getSuperclass().getDeclaredMethod("addURL", URL.class);
                    method.setAccessible(true);
                    method.invoke((Object)classLoader, u);
                    SoapUI.log.info("Added [" + u.toString() + "] to classpath");
                }
                catch (Throwable t) {
                    try {
                        if (classLoader.getParent() == null) {
                            throw new IOException("Error, could not add URL to classloader " + classLoader.getClass().getName());
                        }
                        SoapUI.log.info("Failed to add jar to " + classLoader.getClass().getName() + ", trying parent");
                        ClasspathHacker.addUrlToClassLoader(u, classLoader.getParent());
                    }
                    catch (IOException e3) {
                        SoapUI.logError(t);
                        throw e3;
                    }
                }
            }
            catch (Throwable t) {
                SoapUI.logError(t);
                throw new IOException("Error, could not add URL to system classloader " + classLoader.getClass().getName());
            }
        }
        catch (Throwable t) {
            SoapUI.logError(t);
            throw new IOException("Error, could not add URL to system classloader " + classLoader.getClass().getName());
        }
    }
}

