/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.support;

import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.panels.SecurityScanNode;
import com.eviware.soapui.security.result.SecurityResult;
import com.eviware.soapui.security.result.SecurityScanRequestResult;
import com.eviware.soapui.security.result.SecurityScanResult;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.security.support.SecurityTestRunListenerAdapter;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

public class ProgressBarSecurityScanAdapter
extends SecurityTestRunListenerAdapter {
    private static final String SKIPPED_VALUE = "SKIPPED";
    private static final Color OK_COLOR = new Color(0, 204, 102);
    private static final Color FAILED_COLOR = new Color(255, 102, 0);
    private static final Color MISSING_ASSERTION_COLOR = new Color(204, 153, 255);
    private static final String STATE_RUN = "No Alerts";
    private static final String STATE_FAIL = "Alerts";
    private static final String STATE_CANCEL = "Canceled";
    private static final String STATE_MISSING_ASSERTIONS = "Missing Assertions";
    private static final String STATE_MISSING_PARAMETERS = "Missing Parameters";
    private JTree tree;
    private SecurityScanNode node;
    private JProgressBar progressBar;
    private SecurityScan securityCheck;
    private SecurityTest securityTest;
    private int alertsCounter = 0;
    private String prePostFix = " ";
    private JLabel cntLabel;
    private Color defaultBackground;

    public ProgressBarSecurityScanAdapter(JTree tree, SecurityScanNode node, JProgressBar progressBar, SecurityScan securityCheck, SecurityTest securityTest, JLabel cntLabel) {
        this.tree = tree;
        this.node = node;
        this.progressBar = progressBar;
        this.defaultBackground = progressBar.getBackground();
        this.progressBar.setMaximum(100);
        this.securityCheck = securityCheck;
        this.securityTest = securityTest;
        this.securityTest.addSecurityTestRunListener(this);
        this.cntLabel = cntLabel;
        this.cntLabel.setPreferredSize(new Dimension(50, 18));
        this.cntLabel.setHorizontalTextPosition(0);
        this.cntLabel.setHorizontalAlignment(0);
    }

    public void release() {
        this.securityTest.removeSecurityTestRunListener(this);
        this.securityTest = null;
        this.securityCheck = null;
    }

    @Override
    public void afterSecurityScanRequest(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScanRequestResult securityCheckReqResult) {
        if (securityCheckReqResult.getSecurityScan().getTestStep().getId().equals(this.securityCheck.getTestStep().getId()) && this.securityCheck.getName().equals(securityCheckReqResult.getSecurityScan().getName())) {
            if (this.securityCheck.getAssertionCount() == 0) {
                this.progressBar.setForeground(MISSING_ASSERTION_COLOR);
                this.progressBar.setString(STATE_MISSING_ASSERTIONS);
                if ((double)this.progressBar.getValue() >= (double)this.progressBar.getMaximum() * 0.9) {
                    this.progressBar.setMaximum(this.progressBar.getMaximum() + 5);
                }
                this.progressBar.setValue(this.progressBar.getValue() + 1);
            } else if (this.securityCheck instanceof AbstractSecurityScanWithProperties) {
                if (((AbstractSecurityScanWithProperties)this.securityCheck).getParameterHolder() != null && ((AbstractSecurityScanWithProperties)this.securityCheck).getParameterHolder().getParameterList() != null && ((AbstractSecurityScanWithProperties)this.securityCheck).getParameterHolder().getParameterList().size() == 0) {
                    this.progressBar.setForeground(MISSING_ASSERTION_COLOR);
                    this.progressBar.setString(STATE_MISSING_PARAMETERS);
                    this.progressBar.setValue(this.progressBar.getMaximum());
                } else {
                    if (securityCheckReqResult.getStatus() == SecurityResult.ResultStatus.FAILED) {
                        this.progressBar.setForeground(FAILED_COLOR);
                        this.progressBar.setString(STATE_FAIL);
                        ++this.alertsCounter;
                    } else if (securityCheckReqResult.getStatus() == SecurityResult.ResultStatus.OK && !this.progressBar.getForeground().equals(FAILED_COLOR)) {
                        this.progressBar.setForeground(OK_COLOR);
                        this.progressBar.setString(STATE_RUN);
                    }
                    if (this.alertsCounter != 0) {
                        this.cntLabel.setOpaque(true);
                        this.cntLabel.setBackground(FAILED_COLOR);
                        this.cntLabel.setText(this.prePostFix + this.alertsCounter + this.prePostFix);
                    }
                    if ((double)this.progressBar.getValue() >= (double)this.progressBar.getMaximum() * 0.9) {
                        this.progressBar.setMaximum(this.progressBar.getMaximum() + 5);
                    }
                    this.progressBar.setValue(this.progressBar.getValue() + 1);
                }
            }
            ((DefaultTreeModel)this.tree.getModel()).nodeChanged(this.node);
        }
    }

    @Override
    public void beforeRun(TestCaseRunner testRunner, SecurityTestRunContext runContext) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        this.progressBar.setString("");
        this.progressBar.setForeground(OK_COLOR);
        this.cntLabel.setOpaque(false);
        this.cntLabel.setText("");
        this.alertsCounter = 0;
        ((DefaultTreeModel)this.tree.getModel()).nodeChanged(this.node);
    }

    @Override
    public void afterSecurityScan(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScanResult securityCheckResult) {
        if (securityCheckResult.getSecurityScan().getTestStep().getId().equals(this.securityCheck.getTestStep().getId()) && this.securityCheck.getName().equals(securityCheckResult.getSecurityScan().getName())) {
            if (securityCheckResult.getStatus() != SecurityResult.ResultStatus.CANCELED) {
                if (this.securityCheck.getAssertionCount() == 0) {
                    this.progressBar.setForeground(MISSING_ASSERTION_COLOR);
                    this.progressBar.setString(STATE_MISSING_ASSERTIONS);
                } else if (this.securityCheck instanceof AbstractSecurityScanWithProperties) {
                    AbstractSecurityScanWithProperties scanWithProperties = (AbstractSecurityScanWithProperties)this.securityCheck;
                    if (scanWithProperties.getParameterHolder() != null && scanWithProperties.getParameterHolder().getParameterList() != null && scanWithProperties.getParameterHolder().getParameterList().size() == 0) {
                        this.progressBar.setForeground(MISSING_ASSERTION_COLOR);
                        this.progressBar.setString(STATE_MISSING_PARAMETERS);
                    } else if (securityCheckResult.getStatus() == SecurityResult.ResultStatus.SKIPPED) {
                        this.progressBar.setForeground(this.defaultBackground);
                        this.progressBar.setString(SKIPPED_VALUE);
                    }
                } else if (securityCheckResult.getStatus() == SecurityResult.ResultStatus.SKIPPED) {
                    this.progressBar.setForeground(this.defaultBackground);
                    this.progressBar.setString(SKIPPED_VALUE);
                }
                if (this.progressBar.getString().equals(SKIPPED_VALUE)) {
                    this.progressBar.setValue(0);
                } else {
                    this.progressBar.setValue(this.progressBar.getMaximum());
                }
                if (this.progressBar.getString().equals("")) {
                    this.progressBar.setString(STATE_RUN);
                }
            } else {
                this.progressBar.setString(STATE_CANCEL);
            }
            this.progressBar.setBackground(this.defaultBackground);
            ((DefaultTreeModel)this.tree.getModel()).nodeChanged(this.node);
        }
    }

    @Override
    public void beforeSecurityScan(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScan securityCheck) {
        if (securityCheck.getTestStep().getId().equals(this.securityCheck.getTestStep().getId()) && this.securityCheck.getName().equals(securityCheck.getName())) {
            this.progressBar.setString(STATE_RUN);
            this.progressBar.setBackground(Color.white);
        }
    }
}

