/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.boundary;

import com.eviware.soapui.SoapUI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class BoundaryUtils {
    public static String createCharacterArray(String availableValues, Integer size) {
        if (size == null) {
            SoapUI.log.error("size is not specified!");
            return null;
        }
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            sb.append(BoundaryUtils.randomCharacter(availableValues));
        }
        return sb.toString();
    }

    public static String randomCharacter(String availableValues) {
        int position = (int)(Math.random() * (double)availableValues.length());
        return availableValues.substring(position, position + 1);
    }

    public static String createDate(String restrictionDate, int daysOffset, SimpleDateFormat format) {
        try {
            Date date = format.parse(restrictionDate);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(6, daysOffset);
            return format.format(calendar.getTime());
        }
        catch (ParseException e) {
            SoapUI.logError(e, "date : '" + restrictionDate + "' is not in proper format: " + format.toPattern());
            return null;
        }
    }

    public static String createTime(String restrictionTime, int minutesOffset, SimpleDateFormat format) {
        try {
            Date date = format.parse(restrictionTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(12, minutesOffset);
            return format.format(calendar.getTime());
        }
        catch (ParseException e) {
            SoapUI.logError(e, "time : '" + restrictionTime + "' is not in proper format: " + format.toPattern());
            return null;
        }
    }
}

