/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.report;

import com.eviware.soapui.junit.ErrorDocument;
import com.eviware.soapui.junit.FailureDocument;
import com.eviware.soapui.junit.Properties;
import com.eviware.soapui.junit.Property;
import com.eviware.soapui.junit.Testcase;
import com.eviware.soapui.junit.Testsuite;
import com.eviware.soapui.junit.TestsuiteDocument;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlOptions;

public class JUnitReport {
    TestsuiteDocument testsuiteDoc;
    int noofTestCases;
    int noofFailures;
    int noofErrors;
    double totalTime;
    StringBuffer systemOut = new StringBuffer();
    StringBuffer systemErr = new StringBuffer();
    boolean includeTestProperties;

    public JUnitReport() {
        this.testsuiteDoc = TestsuiteDocument.Factory.newInstance();
        Testsuite testsuite = this.testsuiteDoc.addNewTestsuite();
        Properties properties = testsuite.addNewProperties();
        this.setSystemProperties(properties);
    }

    public void setIncludeTestProperties(boolean includeTestProperties) {
        this.includeTestProperties = includeTestProperties;
    }

    public void setTotalTime(double time) {
        this.testsuiteDoc.getTestsuite().setTime(Double.toString(Math.round(time * 1000.0) / 1000L));
    }

    public void setTestSuiteName(String name) {
        this.testsuiteDoc.getTestsuite().setName(name);
    }

    public void setPackage(String pkg) {
        this.testsuiteDoc.getTestsuite().setPackage(pkg);
    }

    public void setNoofErrorsInTestSuite(int errors) {
        this.testsuiteDoc.getTestsuite().setErrors(errors);
    }

    public void setNoofFailuresInTestSuite(int failures) {
        this.testsuiteDoc.getTestsuite().setFailures(failures);
    }

    public void systemOut(String systemout) {
        this.systemOut.append(systemout);
    }

    public void systemErr(String systemerr) {
        this.systemErr.append(systemerr);
    }

    public void setSystemOut(String systemout) {
        this.testsuiteDoc.getTestsuite().setSystemOut(systemout);
    }

    public void setSystemErr(String systemerr) {
        this.testsuiteDoc.getTestsuite().setSystemErr(systemerr);
    }

    public Testcase addTestCase(String name, double time, HashMap<String, String> testProperties) {
        Testcase testcase = this.testsuiteDoc.getTestsuite().addNewTestcase();
        testcase.setName(name);
        testcase.setTime(String.valueOf(time / 1000.0));
        ++this.noofTestCases;
        this.totalTime += time;
        this.setTestProperties(testProperties, testcase);
        return testcase;
    }

    private void setTestProperties(HashMap<String, String> testProperties, Testcase testcase) {
        if (!this.includeTestProperties) {
            return;
        }
        Properties properties = testcase.addNewProperties();
        this.setProperties(properties, testProperties);
    }

    public Testcase addTestCaseWithFailure(String name, double time, String failure, String stacktrace, HashMap<String, String> testProperties) {
        Testcase testcase = this.testsuiteDoc.getTestsuite().addNewTestcase();
        testcase.setName(name);
        testcase.setTime(String.valueOf(time / 1000.0));
        FailureDocument.Failure fail = testcase.addNewFailure();
        fail.setType(failure);
        fail.setMessage(failure);
        fail.setStringValue(stacktrace);
        ++this.noofTestCases;
        ++this.noofFailures;
        this.totalTime += time;
        this.setTestProperties(testProperties, testcase);
        return testcase;
    }

    public Testcase addTestCaseWithError(String name, double time, String error, String stacktrace, HashMap<String, String> testProperties) {
        Testcase testcase = this.testsuiteDoc.getTestsuite().addNewTestcase();
        testcase.setName(name);
        testcase.setTime(String.valueOf(time / 1000.0));
        ErrorDocument.Error err = testcase.addNewError();
        err.setType(error);
        err.setMessage(error);
        err.setStringValue(stacktrace);
        ++this.noofTestCases;
        ++this.noofErrors;
        this.totalTime += time;
        this.setTestProperties(testProperties, testcase);
        return testcase;
    }

    private void setSystemProperties(Properties properties) {
        Set<Object> keys = System.getProperties().keySet();
        for (Object keyO : keys) {
            String key = keyO.toString();
            String value = System.getProperty(key);
            Property prop = properties.addNewProperty();
            prop.setName(key);
            prop.setValue(value);
        }
    }

    private void setProperties(Properties properties, HashMap<String, String> propertiesToSet) {
        for (Map.Entry<String, String> stringStringEntry : propertiesToSet.entrySet()) {
            Property prop = properties.addNewProperty();
            prop.setName(stringStringEntry.getKey());
            prop.setValue(stringStringEntry.getValue());
        }
    }

    public void save(File file) throws IOException {
        this.finishReport();
        HashMap<String, String> prefixes = new HashMap<String, String>();
        prefixes.put("", "http://eviware.com/soapui/junit");
        this.testsuiteDoc.save(file, new XmlOptions().setSaveOuter().setCharacterEncoding("utf-8").setUseDefaultNamespace().setSaveImplicitNamespaces(prefixes));
    }

    public TestsuiteDocument finishReport() {
        this.testsuiteDoc.getTestsuite().setTests(this.noofTestCases);
        this.testsuiteDoc.getTestsuite().setFailures(this.noofFailures);
        this.testsuiteDoc.getTestsuite().setErrors(this.noofErrors);
        this.testsuiteDoc.getTestsuite().setTime(String.valueOf(this.totalTime / 1000.0));
        return this.testsuiteDoc;
    }
}

