/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes;

import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.tree.AbstractModelItemTreeNode;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.nodes.MockResponseTreeNode;
import java.util.ArrayList;
import java.util.List;

public class MockOperationTreeNode
extends AbstractModelItemTreeNode<MockOperation> {
    private List<MockResponseTreeNode> mockResponseNodes = new ArrayList<MockResponseTreeNode>();

    public MockOperationTreeNode(MockOperation mockOperation, SoapUITreeModel treeModel) {
        super(mockOperation, mockOperation.getMockService(), treeModel);
        for (int c = 0; c < mockOperation.getMockResponseCount(); ++c) {
            MockResponse mockResponse = mockOperation.getMockResponseAt(c);
            this.mockResponseNodes.add(new MockResponseTreeNode(mockResponse, this.getTreeModel()));
        }
        treeModel.mapModelItems(this.mockResponseNodes);
    }

    @Override
    public void release() {
        super.release();
        for (MockResponseTreeNode treeNode : this.mockResponseNodes) {
            treeNode.release();
        }
    }

    @Override
    public int getChildCount() {
        return this.mockResponseNodes.size();
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.mockResponseNodes.indexOf(child);
    }

    @Override
    public SoapUITreeNode getChildNode(int index) {
        return this.mockResponseNodes.get(index);
    }

    public void mockResponseAdded(MockResponse mockResponse) {
        MockResponseTreeNode treeNode = new MockResponseTreeNode(mockResponse, this.getTreeModel());
        this.mockResponseNodes.add(treeNode);
        this.getTreeModel().notifyNodeInserted(treeNode);
    }

    public void mockResponseRemoved(MockResponse mockResponse) {
        SoapUITreeNode treeNode = this.getTreeModel().getTreeNode(mockResponse);
        if (!this.mockResponseNodes.contains(treeNode)) {
            throw new RuntimeException("Removing unkown mockResponse; " + mockResponse.getName());
        }
        this.getTreeModel().notifyNodeRemoved(treeNode);
        this.mockResponseNodes.remove(treeNode);
    }
}

