/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.propertyexpansion;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.propertyexpansion.MutablePropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.MutablePropertyExpansionImpl;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.support.SettingsTestPropertyHolder;
import com.eviware.soapui.model.testsuite.RenameableTestProperty;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.settings.GlobalPropertySettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertyExpansionUtils {
    public static final Logger log = LogManager.getLogger(PropertyExpansionUtils.class);
    private static SettingsTestPropertyHolder globalTestPropertyHolder;

    public static String getGlobalProperty(String propertyName) {
        if (globalTestPropertyHolder == null) {
            PropertyExpansionUtils.initGlobalProperties();
        }
        return globalTestPropertyHolder.getPropertyValue(propertyName);
    }

    private static synchronized void initGlobalProperties() {
        globalTestPropertyHolder = new SettingsTestPropertyHolder(SoapUI.getSettings(), null, GlobalPropertySettings.PROPERTIES);
        String propFile = System.getProperty("soapui.properties");
        if (StringUtils.hasContent(propFile)) {
            globalTestPropertyHolder.addPropertiesFromFile(propFile);
        }
    }

    public static void saveGlobalProperties() {
        if (globalTestPropertyHolder != null) {
            globalTestPropertyHolder.saveTo(SoapUI.getSettings());
        }
    }

    public static String shortenXPathForPropertyExpansion(String xpath, String value) {
        if (xpath.length() > 0) {
            StringBuffer buf = new StringBuffer();
            block3: for (int c = 0; c < xpath.length(); ++c) {
                char ch = xpath.charAt(c);
                switch (ch) {
                    case '\n': {
                        buf.append(' ');
                        continue block3;
                    }
                    default: {
                        buf.append(ch);
                    }
                }
            }
            xpath = buf.toString();
        }
        return xpath;
    }

    public static String expandProperties(String content) {
        return PropertyExpander.expandProperties(content);
    }

    public static String expandProperties(PropertyExpansionContext context, String content) {
        return PropertyExpander.expandProperties(context, content);
    }

    public static String expandProperties(PropertyExpansionContext context, String content, boolean entitize) {
        return PropertyExpander.expandProperties(context, content, entitize);
    }

    public static boolean canTransferToProperty(TestProperty source, TestProperty target) {
        return false;
    }

    public static boolean canExpandProperty(ModelItem contextModelItem, TestProperty property) {
        ModelItem propertyModelItem = property.getModelItem();
        if (propertyModelItem == null || propertyModelItem instanceof Project) {
            return true;
        }
        if (contextModelItem instanceof TestSuite) {
            return propertyModelItem == contextModelItem;
        }
        if (contextModelItem instanceof TestCase) {
            return propertyModelItem == contextModelItem || propertyModelItem instanceof TestSuite && ((TestCase)contextModelItem).getTestSuite() == propertyModelItem;
        }
        if (contextModelItem instanceof TestStep) {
            TestStep testStep = (TestStep)contextModelItem;
            return propertyModelItem == contextModelItem || propertyModelItem instanceof TestSuite && testStep.getTestCase().getTestSuite() == propertyModelItem || propertyModelItem instanceof TestCase && testStep.getTestCase() == propertyModelItem || propertyModelItem instanceof TestStep && testStep.getTestCase() == ((TestStep)propertyModelItem).getTestCase();
        }
        if (contextModelItem instanceof MockService) {
            return propertyModelItem == contextModelItem;
        }
        if (contextModelItem instanceof MockOperation) {
            return propertyModelItem == contextModelItem || propertyModelItem instanceof MockService && ((MockOperation)contextModelItem).getMockService() == propertyModelItem;
        }
        if (contextModelItem instanceof MockResponse) {
            MockResponse testStep = (MockResponse)contextModelItem;
            return propertyModelItem == contextModelItem || propertyModelItem instanceof MockService && testStep.getMockOperation().getMockService() == propertyModelItem || propertyModelItem instanceof MockOperation && testStep.getMockOperation() == propertyModelItem || propertyModelItem instanceof MockResponse && testStep.getMockOperation() == ((MockResponse)propertyModelItem).getMockOperation();
        }
        if (contextModelItem instanceof SecurityTest) {
            SecurityTest securityTest = (SecurityTest)contextModelItem;
            return propertyModelItem == contextModelItem || propertyModelItem instanceof TestSuite && securityTest.getTestCase().getTestSuite() == propertyModelItem || propertyModelItem instanceof TestCase && securityTest.getTestCase() == propertyModelItem || propertyModelItem instanceof SecurityTest && securityTest.getTestCase() == ((SecurityTest)propertyModelItem).getTestCase();
        }
        System.out.println("property " + property.getName() + " can not be transferred to " + contextModelItem.getName());
        return false;
    }

    public static MutableTestPropertyHolder getGlobalProperties() {
        if (globalTestPropertyHolder == null) {
            PropertyExpansionUtils.initGlobalProperties();
        }
        return globalTestPropertyHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MutablePropertyExpansion[] renameProperty(RenameableTestProperty property, String newName, ModelItem root) {
        UISupport.setHourglassCursor();
        try {
            ArrayList<MutablePropertyExpansion> result = new ArrayList<MutablePropertyExpansion>();
            ArrayList<MutablePropertyExpansion> properties = new ArrayList<MutablePropertyExpansion>();
            PropertyExpansion[] propertyExpansions = PropertyExpansionUtils.getPropertyExpansions(root, true, true);
            for (PropertyExpansion pe : propertyExpansions) {
                MutablePropertyExpansion mpe = (MutablePropertyExpansion)pe;
                if (!mpe.getProperty().equals(property)) continue;
                mpe.setProperty(property);
                properties.add(mpe);
            }
            property.setName(newName);
            for (MutablePropertyExpansion mpe : properties) {
                try {
                    mpe.update();
                    result.add(mpe);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            MutablePropertyExpansion[] mutablePropertyExpansionArray = result.toArray(new MutablePropertyExpansion[result.size()]);
            return mutablePropertyExpansionArray;
        }
        finally {
            UISupport.resetCursor();
        }
    }

    public static PropertyExpansion[] getPropertyExpansions(ModelItem modelItem, boolean mutableOnly, boolean deep) {
        List<? extends ModelItem> children;
        PropertyExpansion[] pes;
        ArrayList<Object> result = new ArrayList<Object>();
        if (modelItem instanceof PropertyExpansionContainer && (pes = ((PropertyExpansionContainer)((Object)modelItem)).getPropertyExpansions()) != null && pes.length > 0) {
            for (PropertyExpansion pe : pes) {
                if (mutableOnly && !(pe instanceof MutablePropertyExpansion)) continue;
                result.add(pe);
            }
        }
        if (deep && (children = modelItem.getChildren()) != null && children.size() > 0) {
            for (ModelItem modelItem2 : children) {
                result.addAll(Arrays.asList(PropertyExpansionUtils.getPropertyExpansions(modelItem2, mutableOnly, deep)));
            }
        }
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    public static Collection<? extends PropertyExpansion> extractPropertyExpansions(ModelItem modelItem, Object target, String propertyName) {
        ArrayList<MutablePropertyExpansionImpl> result = new ArrayList<MutablePropertyExpansionImpl>();
        HashSet<String> expansions = new HashSet<String>();
        try {
            String str;
            Object property = PropertyUtils.getProperty((Object)target, (String)propertyName);
            if (property instanceof String && PropertyUtils.isWriteable((Object)target, (String)propertyName) && !StringUtils.isNullOrEmpty(str = property.toString())) {
                int ix2;
                int ix = str.indexOf("${");
                while (ix != -1 && (ix2 = str.indexOf(125, ix + 2)) != -1) {
                    MutablePropertyExpansionImpl tp;
                    String expansion = str.substring(ix + 2, ix2);
                    if (!expansions.contains(expansion) && (tp = PropertyExpansionUtils.createMutablePropertyExpansion(expansion, modelItem, target, propertyName)) != null) {
                        result.add(tp);
                        expansions.add(expansion);
                    }
                    str = str.substring(ix2);
                    ix = str.indexOf("${");
                }
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        return result;
    }

    public static MutablePropertyExpansionImpl createMutablePropertyExpansion(String pe, ModelItem modelItem, Object target, String propertyName) {
        TestProperty tp;
        int sepIx;
        WsdlTestStep testStep = null;
        WsdlTestCase testCase = null;
        WsdlTestSuite testSuite = null;
        WsdlProject project = null;
        WsdlMockService mockService = null;
        WsdlMockResponse mockResponse = null;
        TestPropertyHolder holder = null;
        SecurityTest securityTest = null;
        if (modelItem instanceof WsdlTestStep) {
            testStep = (WsdlTestStep)modelItem;
            testCase = testStep.getTestCase();
            testSuite = testCase.getTestSuite();
            project = testSuite.getProject();
        } else if (modelItem instanceof WsdlTestCase) {
            testCase = (WsdlTestCase)modelItem;
            testSuite = testCase.getTestSuite();
            project = testSuite.getProject();
        } else if (modelItem instanceof WsdlTestSuite) {
            testSuite = (WsdlTestSuite)modelItem;
            project = testSuite.getProject();
        } else if (modelItem instanceof WsdlInterface) {
            project = ((WsdlInterface)modelItem).getProject();
        } else if (modelItem instanceof WsdlProject) {
            project = (WsdlProject)modelItem;
        } else if (modelItem instanceof WsdlMockService) {
            mockService = (WsdlMockService)modelItem;
            project = mockService.getProject();
        } else if (modelItem instanceof AbstractHttpRequestInterface) {
            project = ((AbstractInterface)((AbstractHttpRequest)modelItem).getOperation().getInterface()).getProject();
        } else if (modelItem instanceof WsdlMockOperation) {
            mockService = ((WsdlMockOperation)modelItem).getMockService();
            project = mockService.getProject();
        } else if (modelItem instanceof WsdlMockResponse) {
            mockResponse = (WsdlMockResponse)modelItem;
            mockService = mockResponse.getMockOperation().getMockService();
            project = mockService.getProject();
        } else if (modelItem instanceof SecurityTest) {
            securityTest = (SecurityTest)modelItem;
            testCase = securityTest.getTestCase();
            testSuite = testCase.getTestSuite();
            project = testSuite.getProject();
        }
        if (pe.startsWith("#Project#")) {
            holder = project;
            pe = pe.substring("#Project#".length());
        } else if (pe.startsWith("#TestSuite#")) {
            holder = testSuite;
            pe = pe.substring("#TestSuite#".length());
        } else if (pe.startsWith("#TestCase#")) {
            holder = testCase;
            pe = pe.substring("#TestCase#".length());
        } else if (pe.startsWith("#SecurityTest#")) {
            holder = testCase;
            pe = pe.substring("#SecurityTest#".length());
        } else if (pe.startsWith("#MockService#")) {
            holder = mockService;
            pe = pe.substring("#MockService#".length());
        } else if (pe.startsWith("#MockResponse#")) {
            holder = mockResponse;
            pe = pe.substring("#MockResponse#".length());
        } else if (testCase != null && (sepIx = pe.indexOf(35)) > 0 && (holder = testCase.getTestStepByName(pe.substring(0, sepIx))) != null) {
            pe = pe.substring(sepIx + 1);
        }
        sepIx = pe.indexOf(35);
        String xpath = null;
        if (sepIx > 0) {
            xpath = pe.substring(sepIx + 1);
            pe = pe.substring(0, sepIx);
        }
        if (holder == null) {
            holder = PropertyExpansionUtils.getGlobalProperties();
        }
        return (tp = holder.getProperty(pe)) == null ? null : new MutablePropertyExpansionImpl(tp, xpath, target, propertyName);
    }

    public static String expandProperties(ModelItem contextModelItem, String content) {
        return PropertyExpander.expandProperties(contextModelItem, content);
    }

    public static boolean containsPropertyExpansion(String str) {
        return str != null && str.indexOf("${") >= 0 && str.indexOf(125) > 2;
    }

    public static class GlobalPropertyExpansionContext
    implements PropertyExpansionContext {
        @Override
        public Object getProperty(String name) {
            return PropertyExpansionUtils.getGlobalProperties().getProperty(name);
        }

        @Override
        public void setProperty(String name, Object value) {
            PropertyExpansionUtils.getGlobalProperties().setPropertyValue(name, String.valueOf(value));
        }

        @Override
        public boolean hasProperty(String name) {
            return PropertyExpansionUtils.getGlobalProperties().hasProperty(name);
        }

        @Override
        public Object removeProperty(String name) {
            return PropertyExpansionUtils.getGlobalProperties().removeProperty(name);
        }

        @Override
        public String[] getPropertyNames() {
            return PropertyExpansionUtils.getGlobalProperties().getPropertyNames();
        }

        @Override
        public ModelItem getModelItem() {
            return null;
        }

        @Override
        public String expand(String content) {
            return PropertyExpander.expandProperties(this, content);
        }

        @Override
        public StringToObjectMap getProperties() {
            StringToObjectMap result = new StringToObjectMap();
            Map<String, TestProperty> props = PropertyExpansionUtils.getGlobalProperties().getProperties();
            for (Map.Entry<String, TestProperty> entry : props.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }
    }
}

