/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.registry;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.teststeps.registry.AMFRequestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.DelayStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.GotoStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.GraphQLRequestTestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.GroovyScriptStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.HttpRequestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.JdbcRequestTestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.ManualTestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.ProPlaceholderStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.PropertiesStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.PropertyTransfersStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.RestRequestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.RunTestCaseStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlMockResponseStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestRequestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import com.eviware.soapui.support.factory.SoapUIFactoryRegistryListener;
import java.util.ArrayList;
import java.util.List;

public class WsdlTestStepRegistry
implements SoapUIFactoryRegistryListener {
    private static WsdlTestStepRegistry instance;
    private List<WsdlTestStepFactory> factories = new ArrayList<WsdlTestStepFactory>();

    public WsdlTestStepRegistry() {
        this.addFactory(new WsdlTestRequestStepFactory());
        this.addFactory(new RestRequestStepFactory());
        this.addFactory(new HttpRequestStepFactory());
        this.addFactory(new AMFRequestStepFactory());
        this.addFactory(new JdbcRequestTestStepFactory());
        this.addFactory(new GraphQLRequestTestStepFactory());
        this.addFactory(new PropertiesStepFactory());
        this.addFactory(new PropertyTransfersStepFactory());
        this.addFactory(new ProPlaceholderStepFactory("datasource", "SoapUI Pro DataSource", "/datasource_step.png"));
        this.addFactory(new ProPlaceholderStepFactory("datasink", "SoapUI Pro DataSink", "/datasink_step.png"));
        this.addFactory(new ProPlaceholderStepFactory("datagen", "SoapUI Pro DataGen", "/datagen_step.png"));
        this.addFactory(new ProPlaceholderStepFactory("datasourceloop", "SoapUI Pro DataSourceLoop", "/datasource_loop_step.png"));
        this.addFactory(new GotoStepFactory());
        this.addFactory(new RunTestCaseStepFactory());
        this.addFactory(new GroovyScriptStepFactory());
        this.addFactory(new ProPlaceholderStepFactory("assertionteststep", "SoapUI Pro Assertion TestStep", "/assertion_test_step.gif"));
        this.addFactory(new DelayStepFactory());
        this.addFactory(new WsdlMockResponseStepFactory());
        this.addFactory(new ManualTestStepFactory());
        for (WsdlTestStepFactory factory : SoapUI.getFactoryRegistry().getFactories(WsdlTestStepFactory.class)) {
            this.addFactory(factory);
        }
        SoapUI.getFactoryRegistry().addFactoryRegistryListener(this);
    }

    public WsdlTestStepFactory getFactory(String type) {
        for (WsdlTestStepFactory factory : this.factories) {
            if (!factory.getType().equals(type)) continue;
            return factory;
        }
        return null;
    }

    public void addFactory(WsdlTestStepFactory factory) {
        int replaceIndex = this.removeFactory(factory.getType());
        if (replaceIndex == -1) {
            this.factories.add(factory);
        } else {
            this.factories.add(replaceIndex, factory);
        }
    }

    public int removeFactory(String type) {
        int index = 0;
        for (WsdlTestStepFactory factory : this.factories) {
            if (factory.getType().equals(type)) {
                this.factories.remove(factory);
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static synchronized WsdlTestStepRegistry getInstance() {
        if (instance == null) {
            instance = new WsdlTestStepRegistry();
        }
        return instance;
    }

    public WsdlTestStepFactory[] getFactories() {
        return this.factories.toArray(new WsdlTestStepFactory[this.factories.size()]);
    }

    public boolean hasFactory(TestStepConfig config) {
        return this.getFactory(config.getType()) != null;
    }

    @Override
    public void factoryAdded(Class<?> factoryType, Object factory) {
        if (factory instanceof WsdlTestStepFactory) {
            this.addFactory((WsdlTestStepFactory)factory);
        }
    }

    @Override
    public void factoryRemoved(Class<?> factoryType, Object factory) {
        if (factory instanceof WsdlTestStepFactory) {
            this.removeFactory(((WsdlTestStepFactory)factory).getType());
        }
    }
}

