/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.registry;

import com.eviware.soapui.config.RestRequestConfig;
import com.eviware.soapui.config.RestRequestStepConfig;
import com.eviware.soapui.config.StringToStringMapConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.monitor.WsdlMonitorMessageExchange;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.TupleList;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;

public class RestRequestStepFactory
extends WsdlTestStepFactory {
    public static final String RESTREQUEST_TYPE = "restrequest";
    public static final String STEP_NAME = "Name";

    public RestRequestStepFactory() {
        super(RESTREQUEST_TYPE, "REST Request", "Submits a REST-style Request and validates its response", "/rest_request_step.png");
    }

    @Override
    public WsdlTestStep buildTestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        try {
            return new RestTestRequestStep(testCase, config, forLoadTest);
        }
        catch (ItemDeletedException e) {
            return null;
        }
    }

    public static TestStepConfig createConfig(RestRequest request, String stepName) {
        request.beforeSave();
        RestRequestStepConfig requestStepConfig = RestRequestStepConfig.Factory.newInstance();
        requestStepConfig.setService(request.getOperation().getInterface().getName());
        requestStepConfig.setResourcePath(request.getOperation().getFullPath());
        requestStepConfig.setMethodName(request.getRestMethod().getName());
        requestStepConfig.addNewRestRequest().set(((RestRequestConfig)request.getConfig()).copy());
        TestStepConfig testStep = TestStepConfig.Factory.newInstance();
        testStep.setType(RESTREQUEST_TYPE);
        testStep.setConfig(requestStepConfig);
        testStep.setName(stepName);
        return testStep;
    }

    @Override
    public TestStepConfig createNewTestStep(WsdlTestCase testCase, String name) {
        int ix;
        WsdlProject project = testCase.getTestSuite().getProject();
        ArrayList<CallSite> options = new ArrayList<CallSite>();
        TupleList<RestMethod, RestRequest> restMethods = new TupleList<RestMethod, RestRequest>();
        for (int c = 0; c < project.getInterfaceCount(); ++c) {
            Interface iface = project.getInterfaceAt(c);
            if (!(iface instanceof RestService)) continue;
            List<RestResource> resources = ((RestService)iface).getAllResources();
            for (RestResource resource : resources) {
                for (RestMethod method : resource.getRestMethodList()) {
                    String methodStr = iface.getName() + " -> " + resource.getPath() + " -> " + method.getName();
                    restMethods.add(method, null);
                    options.add((CallSite)((Object)methodStr));
                    for (RestRequest request : method.getRequestList()) {
                        restMethods.add(method, request);
                        options.add((CallSite)((Object)(methodStr + " -> " + request.getName())));
                    }
                }
            }
        }
        if (restMethods.size() == 0) {
            UISupport.showErrorMessage("Missing REST Methods in project");
            return null;
        }
        Object op = UISupport.prompt("Select REST method to invoke for request", "New RestRequest", options.toArray());
        if (op != null && (ix = options.indexOf(op)) != -1) {
            TupleList.Tuple tuple = (TupleList.Tuple)restMethods.get(ix);
            return tuple.getValue2() == null ? this.createNewTestStep((RestMethod)tuple.getValue1(), name) : RestRequestStepFactory.createConfig((RestRequest)tuple.getValue2(), name);
        }
        return null;
    }

    public TestStepConfig createNewTestStep(RestMethod restMethod, String name) {
        RestRequestStepConfig requestStepConfig = RestRequestStepConfig.Factory.newInstance();
        RestRequestConfig testRequestConfig = requestStepConfig.addNewRestRequest();
        testRequestConfig.setName(name);
        testRequestConfig.setEncoding("UTF-8");
        if (restMethod != null) {
            requestStepConfig.setService(restMethod.getInterface().getName());
            requestStepConfig.setMethodName(restMethod.getName());
            requestStepConfig.setResourcePath(restMethod.getOperation().getFullPath());
            String[] endpoints = restMethod.getInterface().getEndpoints();
            if (endpoints.length > 0) {
                testRequestConfig.setEndpoint(endpoints[0]);
            }
            testRequestConfig.addNewRequest();
            StringToStringMapConfig parametersConfig = testRequestConfig.addNewParameters();
            for (RestParamProperty property : restMethod.getDefaultParams()) {
                if (!StringUtils.hasContent(property.getDefaultValue())) continue;
                StringToStringMapConfig.Entry entry = parametersConfig.addNewEntry();
                entry.setKey(property.getName());
                entry.setValue(property.getDefaultValue());
            }
        }
        TestStepConfig testStepConfig = TestStepConfig.Factory.newInstance();
        testStepConfig.setType(RESTREQUEST_TYPE);
        testStepConfig.setConfig(requestStepConfig);
        testStepConfig.setName(name);
        return testStepConfig;
    }

    @Override
    public boolean canCreate() {
        return true;
    }

    public TestStepConfig createConfig(WsdlMonitorMessageExchange me, String stepName) {
        RestRequestConfig testRequestConfig = RestRequestConfig.Factory.newInstance();
        testRequestConfig.setName(stepName);
        testRequestConfig.setEncoding("UTF-8");
        testRequestConfig.setEndpoint(me.getEndpoint());
        String requestContent = me.getRequestContent();
        testRequestConfig.addNewRequest().setStringValue(requestContent);
        TestStepConfig testStep = TestStepConfig.Factory.newInstance();
        testStep.setType(RESTREQUEST_TYPE);
        testStep.setConfig(testRequestConfig);
        testStep.setName(stepName);
        return testStep;
    }

    @Override
    public boolean canAddTestStepToTestCase(WsdlTestCase testCase) {
        for (Interface iface : testCase.getTestSuite().getProject().getInterfaceList()) {
            if (!(iface instanceof RestService)) continue;
            for (RestResource resource : ((RestService)iface).getAllResources()) {
                if (resource.getRestMethodCount() <= 0) continue;
                return true;
            }
        }
        UISupport.showErrorMessage("Missing REST Methods in Project");
        return false;
    }

    public static class ItemDeletedException
    extends Exception {
    }
}

