/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.json;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.json.JsonPathAssertionBase;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.json.JsonPathRegExAssertionConfigurationDialog;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextArea;
import junit.framework.Assert;

public class JsonPathRegExAssertion
extends JsonPathAssertionBase
implements RequestAssertion,
ResponseAssertion {
    public static final String ID = "JsonPath RegEx Match";
    public static final String LABEL = "JsonPath RegEx Match";
    public static final String DESCRIPTION = "Uses an JsonPath expression to select content from the target property and compares the result to an specified RegEx. Applicable to any property containing JSON.";
    public static final String REG_EX_PROPERTY_NAME = "regEx";
    private String regularExpression;

    public JsonPathRegExAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.regularExpression = reader.readString(REG_EX_PROPERTY_NAME, null);
    }

    @Override
    public String getHelpURL() {
        return "/functional-testing/validating-messages/validating-json-messages.html";
    }

    @Override
    protected JsonPathRegExAssertion getAssertion() {
        return this;
    }

    @Override
    public String getConfigurationDialogTitle() {
        return "JSONPath RegEx Match Configuration";
    }

    @Override
    protected void addConfigurationValues(XmlObjectConfigurationBuilder builder) {
        super.addConfigurationValues(builder);
        builder.add(REG_EX_PROPERTY_NAME, this.regularExpression);
    }

    @Override
    public boolean configure() {
        if (this.configurationDialog == null) {
            this.configurationDialog = new JsonPathRegExAssertionConfigurationDialog(this.getAssertion());
        }
        return this.configurationDialog.configure();
    }

    @Override
    public void selectFromCurrent() {
        block8: {
            try {
                String stringValue;
                String assertableContent = this.getAssertable().getAssertableContent();
                if (StringUtils.isNullOrEmpty(assertableContent)) {
                    UISupport.showErrorMessage("Missing content to select from");
                    return;
                }
                if (StringUtils.isNullOrEmpty(this.regularExpression)) {
                    UISupport.showErrorMessage("Missing regular expression");
                    return;
                }
                String path = this.getPathString();
                PropertyExpansionContext context = this.getPropertyExpansionContext();
                String expandedPath = PropertyExpander.expandProperties(context, path.trim());
                JTextArea contentArea = this.getContentArea();
                if (contentArea != null && contentArea.isVisible()) {
                    contentArea.setText("");
                }
                if ((stringValue = this.readStringValue(assertableContent, expandedPath)) == null) {
                    this.setExpectedValueFromSelectedNode(contentArea, Boolean.FALSE.toString());
                    break block8;
                }
                try {
                    String matches = String.valueOf(stringValue.matches(this.regularExpression));
                    this.setExpectedValueFromSelectedNode(contentArea, matches);
                }
                catch (PatternSyntaxException pse) {
                    UISupport.showErrorMessage("Invalid regular expression. " + pse.getMessage());
                    return;
                }
            }
            catch (Throwable e) {
                UISupport.showErrorMessage("Invalid JsonPath expression.");
                SoapUI.logError(e);
            }
        }
    }

    @Override
    public void setPath(String path) {
        if (path.indexOf("##") > 0) {
            String[] parts = path.split("##");
            if (parts.length > 2) {
                this.setRegularExpression(parts[2]);
            }
            super.setPath(parts[0]);
        } else {
            super.setPath(path);
        }
    }

    private void setExpectedValueFromSelectedNode(JTextArea contentArea, String stringValue) {
        if (contentArea != null && contentArea.isVisible()) {
            contentArea.setText(stringValue);
        } else {
            this.setExpectedContent(stringValue, false);
        }
    }

    @Override
    public String assertContent(String assertableContent, SubmitContext context, String type) throws AssertionException {
        String path = this.getPath();
        try {
            if (path == null) {
                return "Missing path for JsonPath assertion";
            }
            if (this.getExpectedContent() == null) {
                return "Missing content for JsonPath assertion";
            }
            if (this.regularExpression == null) {
                return "Missing RegEx for JsonPath assertion";
            }
            String expandedPath = PropertyExpander.expandProperties(context, path);
            String result = this.readStringValue(assertableContent, expandedPath);
            Boolean actualValue = Boolean.FALSE;
            if (result != null && result.matches(this.regularExpression)) {
                actualValue = Boolean.TRUE;
            }
            String expandedExpectedValue = PropertyExpander.expandProperties(context, this.getExpectedContent());
            Assert.assertEquals((String)expandedExpectedValue, (String)actualValue.toString());
        }
        catch (Throwable exception) {
            this.throwAssertionException(this.getPath(), exception);
        }
        return type + " matches content for [" + path + "]";
    }

    public void setRegularExpression(String regularExpression) {
        this.regularExpression = regularExpression;
        this.setConfiguration(this.createConfiguration());
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public static class Factory
    extends JsonPathAssertionBase.JsonAssertionFactory {
        public Factory() {
            super("JsonPath RegEx Match", "JsonPath RegEx Match", JsonPathRegExAssertion.DESCRIPTION, JsonPathRegExAssertion.class);
        }
    }
}

