/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.AbstractXmlContainsAssertion;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlUtils;
import javax.swing.JTextArea;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.XMLAssert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XQueryContainsAssertion
extends AbstractXmlContainsAssertion {
    public static final String ID = "XQuery Match";
    public static final String LABEL = "XQuery Match";
    public static final String DESCRIPTION = "Uses an XQuery expression to select content from the target property and compares the result to an expected value. Applicable to any property containing XML.";

    public XQueryContainsAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, true, true, true, true);
    }

    @Override
    public String assertContent(String response, SubmitContext context, String type) throws AssertionException {
        try {
            if (this.path == null) {
                return "Missing path for XQuery Assertion";
            }
            if (this.expectedContent == null) {
                return "Missing content for XQuery Assertion";
            }
            XmlOptions options = new XmlOptions();
            if (this.ignoreComments) {
                options.setLoadStripComments();
            }
            XmlObject xml = XmlUtils.createXmlObject(response, options);
            String expandedPath = PropertyExpander.expandProperties(context, this.path);
            XmlObject[] items = xml.execQuery(expandedPath);
            XmlObject contentObj = null;
            String expandedContent = PropertyExpander.expandProperties(context, this.expectedContent);
            try {
                contentObj = XmlUtils.createXmlObject(expandedContent, options);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (items.length == 0) {
                throw new Exception("Missing content for xquery [" + this.path + "] in " + type);
            }
            options.setSavePrettyPrint();
            options.setSaveOuter();
            for (int c = 0; c < items.length; ++c) {
                try {
                    if (contentObj == null) {
                        if (items[c] instanceof XmlAnySimpleType) {
                            String value = ((XmlAnySimpleType)items[c]).getStringValue();
                            String expandedValue = PropertyExpander.expandProperties(context, value);
                            XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                        } else {
                            Node domNode = items[c].getDomNode();
                            switch (domNode.getNodeType()) {
                                case 1: {
                                    String expandedValue = PropertyExpander.expandProperties(context, XmlUtils.getElementText((Element)domNode));
                                    if (this.allowWildcards) {
                                        Tools.assertSimilar(expandedContent, expandedValue, '*');
                                        break;
                                    }
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                                case 9: {
                                    String expandedValue = PropertyExpander.expandProperties(context, XmlUtils.getElementText(((Document)domNode).getDocumentElement()));
                                    if (this.allowWildcards) {
                                        Tools.assertSimilar(expandedContent, expandedValue, '*');
                                        break;
                                    }
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                                case 2: {
                                    String expandedValue = PropertyExpander.expandProperties(context, domNode.getNodeValue());
                                    if (this.allowWildcards) {
                                        Tools.assertSimilar(expandedContent, expandedValue, '*');
                                        break;
                                    }
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                                default: {
                                    String expandedValue = PropertyExpander.expandProperties(context, domNode.getNodeValue());
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                            }
                        }
                    } else {
                        this.compareValues(contentObj.xmlText(options), items[c].xmlText(options));
                    }
                    break;
                }
                catch (Throwable e) {
                    if (c != items.length - 1) continue;
                    throw e;
                }
            }
        }
        catch (Throwable e) {
            String msg = "XQuery Match Assertion failed for path [" + this.path + "] : " + e.getClass().getSimpleName() + ":" + e.getMessage();
            throw new AssertionException(new AssertionError(msg));
        }
        return type + " matches content for [" + this.path + "]";
    }

    private void compareValues(String expandedContent, String expandedValue) throws Exception {
        Diff diff = new Diff(expandedContent, expandedValue);
        AbstractXmlContainsAssertion.InternalDifferenceListener internalDifferenceListener = new AbstractXmlContainsAssertion.InternalDifferenceListener();
        diff.overrideDifferenceListener((DifferenceListener)internalDifferenceListener);
        if (!diff.identical()) {
            throw new Exception(diff.toString());
        }
    }

    public String getHelpURL() {
        return "/functional-testing/validating-messages/validating-xml-messages.html";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectFromCurrent() {
        block10: {
            try {
                Element elm;
                XmlObject xml;
                XmlObject[] paths;
                String txt;
                XmlOptions options = new XmlOptions();
                options.setSavePrettyPrint();
                options.setSaveAggressiveNamespaces();
                String assertableContent = this.getAssertable().getAssertableContentAsXml();
                if (assertableContent == null || assertableContent.trim().length() == 0) {
                    UISupport.showErrorMessage("Missing content to select from");
                    return;
                }
                JTextArea pathArea = this.getPathArea();
                String string = txt = pathArea == null || !pathArea.isVisible() ? this.getPath() : pathArea.getSelectedText();
                if (txt == null) {
                    txt = pathArea == null ? "" : pathArea.getText();
                }
                WsdlTestRunContext context = new WsdlTestRunContext(this.getAssertable().getTestStep());
                String expandedPath = PropertyExpander.expandProperties(context, txt.trim());
                JTextArea contentArea = this.getContentArea();
                if (contentArea != null && contentArea.isVisible()) {
                    contentArea.setText("");
                }
                if ((paths = (xml = XmlUtils.createXmlObject(assertableContent)).execQuery(expandedPath)).length == 0) {
                    UISupport.showErrorMessage("No match in current response");
                    break block10;
                }
                if (paths.length > 1) {
                    UISupport.showErrorMessage("More than one match in current response");
                    break block10;
                }
                Node domNode = paths[0].getDomNode();
                String stringValue = null;
                stringValue = domNode.getNodeType() == 2 || domNode.getNodeType() == 3 ? domNode.getNodeValue() : (domNode.getNodeType() == 1 ? ((elm = (Element)domNode).getChildNodes().getLength() == 1 && elm.getAttributes().getLength() == 0 ? XmlUtils.getElementText(elm) : paths[0].xmlText(options)) : paths[0].xmlText(options));
                if (contentArea != null && contentArea.isVisible()) {
                    contentArea.setText(stringValue);
                    break block10;
                }
                this.setContent(stringValue);
            }
            catch (Throwable e) {
                UISupport.showErrorMessage("Invalid XQuery expression.");
                SoapUI.logError(e);
            }
        }
    }

    @Override
    protected String getQueryType() {
        return "XQuery";
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super("XQuery Match", "XQuery Match", XQueryContainsAssertion.class);
        }

        @Override
        public String getCategory() {
            return "Property Content";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return XQueryContainsAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry("XQuery Match", "XQuery Match", XQueryContainsAssertion.DESCRIPTION);
        }

        @Override
        public boolean canAssert(TestPropertyHolder modelItem, String property) {
            if (!modelItem.getProperty(property).getSchemaType().isPrimitiveType()) {
                return true;
            }
            String content = modelItem.getPropertyValue(property);
            return XmlUtils.seemsToBeXml(content);
        }
    }
}

