/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.impl.swing.SwingXFormImpl;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import org.apache.xmlbeans.XmlObject;

public class SimpleContainsAssertion
extends WsdlMessageAssertion
implements RequestAssertion,
ResponseAssertion {
    private String token;
    private XFormDialog dialog;
    private boolean ignoreCase;
    private boolean useRegEx;
    public static final String ID = "Simple Contains";
    private static final String CONTENT = "Content";
    private static final String IGNORE_CASE = "Ignore Case";
    private static final String USE_REGEX = "Regular Expression";
    public static final String LABEL = "Contains";
    public static final String DESCRIPTION = "Searches for the existence of a string token in the property value, supports regular expressions. Applicable to any property. ";
    private static CellConstraints cc = new CellConstraints();

    public SimpleContainsAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, true, true, true, true);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.token = reader.readString("token", null);
        this.ignoreCase = reader.readBoolean("ignoreCase", false);
        this.useRegEx = reader.readBoolean("useRegEx", false);
    }

    @Override
    public String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return this.assertContent(context, messageExchange.getResponseContent(), "Response");
    }

    @Override
    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        this.assertContent(context, source.getPropertyValue(propertyName), propertyName);
        return "OK";
    }

    private String assertContent(SubmitContext context, String content, String type) throws AssertionException {
        String replToken;
        if (this.token == null) {
            this.token = "";
        }
        if (content == null) {
            content = "";
        }
        if ((replToken = PropertyExpander.expandProperties(context, this.token)) == null) {
            replToken = "";
        }
        replToken = this.normalize(replToken);
        content = this.normalize(content);
        if (replToken.length() > 0) {
            int ix = -1;
            if (this.useRegEx) {
                Object tokenToUse = this.ignoreCase ? "(?i)" + replToken : replToken;
                Pattern p = Pattern.compile((String)tokenToUse, 32);
                Matcher m = p.matcher(content);
                if (m.find()) {
                    ix = 0;
                }
            } else {
                int n = ix = this.ignoreCase ? content.toUpperCase().indexOf(replToken.toUpperCase()) : content.indexOf(replToken);
            }
            if (ix == -1) {
                throw new AssertionException(new AssertionError("Missing token [" + replToken + "] in " + type));
            }
        }
        return type + " contains token [" + replToken + "]";
    }

    private String normalize(String string) {
        if (!StringUtils.isNullOrEmpty(string)) {
            string = string.replaceAll("\r\n", "\n");
        }
        return string;
    }

    @Override
    public boolean configure() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        StringToStringMap values = new StringToStringMap();
        values.put(CONTENT, this.token);
        values.put(IGNORE_CASE, this.ignoreCase);
        values.put(USE_REGEX, this.useRegEx);
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1) {
            this.token = (String)values.get(CONTENT);
            this.ignoreCase = values.getBoolean(IGNORE_CASE);
            this.useRegEx = values.getBoolean(USE_REGEX);
        }
        this.setConfiguration(this.createConfiguration());
        return true;
    }

    public boolean isUseRegEx() {
        return this.useRegEx;
    }

    public void setUseRegEx(boolean useRegEx) {
        this.useRegEx = useRegEx;
        this.setConfiguration(this.createConfiguration());
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.setConfiguration(this.createConfiguration());
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
        this.setConfiguration(this.createConfiguration());
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("token", this.token);
        builder.add("ignoreCase", this.ignoreCase);
        builder.add("useRegEx", this.useRegEx);
        return builder.finish();
    }

    private void buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Contains Assertion");
        XForm mainForm = builder.createForm("Basic", new FormLayout("5px,left:pref,5px,fill:default:grow(1.0),5px"));
        JPanel mainFormPanel = ((SwingXFormImpl)mainForm).getPanel();
        FormLayout mainFormLayout = (FormLayout)mainFormPanel.getLayout();
        mainForm.addTextField(CONTENT, "Content to check for", XForm.FieldType.TEXTAREA).setWidth(40);
        mainFormLayout.setRowSpec(mainFormLayout.getRowCount(), new RowSpec("top:default:grow(1.0)"));
        mainFormPanel.add(mainFormPanel.getComponent(mainFormPanel.getComponents().length - 1), cc.xy(4, mainFormLayout.getRowCount(), "fill,fill"));
        mainForm.addCheckBox(IGNORE_CASE, "Ignore case in comparison");
        mainForm.addCheckBox(USE_REGEX, "Use token as Regular Expression");
        this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("/functional-testing/validating-messages/getting-started-with-assertions.html"), "Specify options", UISupport.OPTIONS_ICON);
    }

    @Override
    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return this.assertContent(context, messageExchange.getRequestContent(), "Request");
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList<? extends PropertyExpansion> result = new ArrayList<PropertyExpansion>();
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this.getAssertable().getModelItem(), this, "token"));
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super(SimpleContainsAssertion.ID, SimpleContainsAssertion.LABEL, SimpleContainsAssertion.class);
        }

        @Override
        public String getCategory() {
            return "Property Content";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return SimpleContainsAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry(SimpleContainsAssertion.ID, SimpleContainsAssertion.LABEL, SimpleContainsAssertion.DESCRIPTION);
        }

        @Override
        public boolean canAssert(TestPropertyHolder modelItem, String property) {
            String content = modelItem.getPropertyValue(property);
            return true;
        }
    }
}

