/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions;

import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionFactory;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.plugins.SoapUIFactory;
import com.eviware.soapui.support.ClassUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractTestAssertionFactory
implements TestAssertionFactory,
SoapUIFactory {
    private final String id;
    private final String label;
    private final Class<? extends TestAssertion> assertionClass;
    private final List<Class<? extends ModelItem>> targetClasses = new ArrayList<Class<? extends ModelItem>>();

    public AbstractTestAssertionFactory(String id, String label, Class<? extends TestAssertion> assertionClass) {
        this.id = id;
        this.label = label;
        this.assertionClass = assertionClass;
    }

    public AbstractTestAssertionFactory(String id, String label, Class<? extends TestAssertion> assertionClass, Class<? extends ModelItem> targetClass) {
        this(id, label, assertionClass, new Class[]{targetClass});
    }

    public AbstractTestAssertionFactory(String id, String label, Class<? extends TestAssertion> assertionClass, Class<? extends ModelItem>[] targetClasses) {
        this.id = id;
        this.label = label;
        this.assertionClass = assertionClass;
        for (Class<? extends ModelItem> clazz : targetClasses) {
            this.targetClasses.add(clazz);
        }
    }

    @Override
    public String getAssertionId() {
        return this.id;
    }

    @Override
    public String getAssertionLabel() {
        return this.label;
    }

    @Override
    public boolean canAssert(Assertable assertable) {
        List<Class<?>> classes = ClassUtils.getSuperInterfaces(this.assertionClass);
        List<Class<?>> classList = ClassUtils.getImplementedAndExtendedClasses(assertable);
        if (!this.targetClasses.isEmpty() && Collections.disjoint(classList, this.targetClasses)) {
            return false;
        }
        if (assertable.getAssertableType() == TestAssertionRegistry.AssertableType.BOTH) {
            return true;
        }
        if (assertable.getAssertableType() == TestAssertionRegistry.AssertableType.REQUEST && classes.contains(RequestAssertion.class)) {
            return true;
        }
        return assertable.getAssertableType() == TestAssertionRegistry.AssertableType.RESPONSE && classes.contains(ResponseAssertion.class);
    }

    @Override
    public boolean canAssert(TestPropertyHolder modelItem, String property) {
        return false;
    }

    @Override
    public TestAssertion buildAssertion(TestAssertionConfig config, Assertable assertable) {
        try {
            Constructor<? extends TestAssertion> ctor = this.assertionClass.getConstructor(TestAssertionConfig.class, Assertable.class);
            return ctor.newInstance(config, assertable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Class<?> getFactoryType() {
        return TestAssertionFactory.class;
    }
}

