/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AttachmentConfig;
import com.eviware.soapui.config.GraphQLTestRequestConfig;
import com.eviware.soapui.config.RestParametersConfig;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.XmlBeansRestParamsTestPropertyHolder;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractHttpOperation;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.HttpAttachmentPart;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.submit.RequestTransportRegistry;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertableConfig;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertionsSupport;
import com.eviware.soapui.impl.wsdl.support.jms.header.JMSHeaderConfig;
import com.eviware.soapui.impl.wsdl.support.jms.property.JMSPropertiesConfig;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.GraphQLRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.GraphQLTestRequestInterface;
import com.eviware.soapui.impl.wsdl.teststeps.HttpResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestInterface;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import graphql.language.Document;
import graphql.language.OperationDefinition;
import graphql.parser.Parser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class GraphQLTestRequest
extends AbstractHttpRequest<GraphQLTestRequestConfig>
implements GraphQLTestRequestInterface {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String ICON_PATH = "/graphql-request.png";
    private static final String PASS_ICON_PATH = "/graphql-request-pass.png";
    private static final String FAIL_ICON_PATH = "/graphql-request-fail.png";
    private static final String DISABLED_ICON_PATH = "/graphql-request-disabled.png";
    private static final String QUERY = "query";
    private static final String VARIABLES = "variables";
    private static final String OPERATION_NAME = "operationName";
    private ImageIcon validRequestIcon;
    private ImageIcon failedRequestIcon;
    private ImageIcon disabledRequestIcon;
    private ImageIcon unknownRequestIcon;
    private JMSPropertiesConfig jmsPropertiesConfig;
    private final boolean forLoadTest;
    private GraphQLRequestTestStep testStep;
    private PropertyChangeNotifier notifier;
    private AssertionsSupport assertionsSupport;
    private HttpResponseMessageExchange messageExchange;
    private ObjectNode body;
    private XmlBeansRestParamsTestPropertyHolder params;

    public GraphQLTestRequest(GraphQLTestRequestConfig config, GraphQLRequestTestStep testStep, boolean forLoadTest) {
        super(config, null, ICON_PATH, forLoadTest);
        this.forLoadTest = forLoadTest;
        this.setSettings(new XmlBeansSettingsImpl(this, testStep.getSettings(), config.getSettings()));
        this.testStep = testStep;
        this.params = new XmlBeansRestParamsTestPropertyHolder(this, RestParametersConfig.Factory.newInstance());
        this.params.addProperty(QUERY);
        this.params.addProperty(VARIABLES);
        this.params.addProperty(OPERATION_NAME);
        this.initBody();
        this.initAssertions();
        if (!forLoadTest) {
            this.initIcons();
        }
    }

    @Override
    public RestRequestInterface.HttpMethod getMethod() {
        String method = ((GraphQLTestRequestConfig)this.getConfig()).getMethod();
        return method == null ? RestRequestInterface.HttpMethod.POST : RestRequestInterface.HttpMethod.valueOf(method);
    }

    protected void initIcons() {
        this.validRequestIcon = UISupport.createImageIcon(PASS_ICON_PATH);
        this.failedRequestIcon = UISupport.createImageIcon(FAIL_ICON_PATH);
        this.unknownRequestIcon = UISupport.createImageIcon(ICON_PATH);
        this.disabledRequestIcon = UISupport.createImageIcon(DISABLED_ICON_PATH);
    }

    @Override
    protected AbstractHttpRequest.RequestIconAnimator<?> initIconAnimator() {
        return null;
    }

    private void initBody() {
        ObjectMapper mapper = new ObjectMapper();
        this.body = mapper.createObjectNode();
        String nullValue = null;
        this.body.put(QUERY, nullValue);
        this.body.put(OPERATION_NAME, nullValue);
        this.body.put(VARIABLES, nullValue);
        String requestContent = super.getRequestContent();
        this.setBodyRequest(requestContent);
        this.updateParameters();
    }

    private void initAssertions() {
        this.assertionsSupport = new AssertionsSupport(this.testStep, new AssertableConfig(){

            @Override
            public TestAssertionConfig addNewAssertion() {
                return ((GraphQLTestRequestConfig)GraphQLTestRequest.this.getConfig()).addNewAssertion();
            }

            @Override
            public List<TestAssertionConfig> getAssertionList() {
                return ((GraphQLTestRequestConfig)GraphQLTestRequest.this.getConfig()).getAssertionList();
            }

            @Override
            public void removeAssertion(int ix) {
                ((GraphQLTestRequestConfig)GraphQLTestRequest.this.getConfig()).removeAssertion(ix);
            }

            @Override
            public TestAssertionConfig insertAssertion(TestAssertionConfig source, int ix) {
                TestAssertionConfig conf = ((GraphQLTestRequestConfig)GraphQLTestRequest.this.getConfig()).insertNewAssertion(ix);
                conf.set(source);
                return conf;
            }
        });
    }

    @Override
    public ImageIcon getIcon() {
        ImageIcon icon;
        if (this.forLoadTest) {
            return null;
        }
        TestMonitor testMonitor = SoapUI.getTestMonitor();
        if (testMonitor != null && (testMonitor.hasRunningLoadTest(this.getTestStep().getTestCase()) || testMonitor.hasRunningSecurityTest(this.getTestStep().getTestCase()))) {
            return this.disabledRequestIcon;
        }
        AbstractHttpRequest.RequestIconAnimator<?> iconAnimator = this.getIconAnimator();
        if (iconAnimator != null && (icon = iconAnimator.getIcon()) != iconAnimator.getBaseIcon()) {
            return icon;
        }
        Assertable.AssertionStatus status = this.getAssertionStatus();
        if (status == Assertable.AssertionStatus.VALID) {
            return this.validRequestIcon;
        }
        if (status == Assertable.AssertionStatus.FAILED) {
            return this.failedRequestIcon;
        }
        if (status == Assertable.AssertionStatus.UNKNOWN) {
            return this.unknownRequestIcon;
        }
        return this.unknownRequestIcon;
    }

    @Override
    public HttpAttachmentPart getAttachmentPart(String partName) {
        return null;
    }

    @Override
    public MessagePart.AttachmentPart[] getDefinedAttachmentParts() {
        return new MessagePart.AttachmentPart[0];
    }

    @Override
    public ModelItem getModelItem() {
        return this.testStep;
    }

    @Override
    public JMSHeaderConfig getJMSHeaderConfig() {
        return null;
    }

    @Override
    public JMSPropertiesConfig getJMSPropertiesConfig() {
        if (this.jmsPropertiesConfig == null) {
            if (!((GraphQLTestRequestConfig)this.getConfig()).isSetJmsPropertyConfig()) {
                ((GraphQLTestRequestConfig)this.getConfig()).addNewJmsPropertyConfig();
            }
            this.jmsPropertiesConfig = new JMSPropertiesConfig(((GraphQLTestRequestConfig)this.getConfig()).getJmsPropertyConfig(), this);
        }
        return this.jmsPropertiesConfig;
    }

    private String getBodyString(String fieldName) {
        JsonNode node = this.body.get(fieldName);
        if (node == null || node.isNull()) {
            return "";
        }
        if (node.isObject()) {
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
            }
            catch (JsonProcessingException e) {
                return node.toString();
            }
        }
        return node.asText();
    }

    @Override
    public String getVariables() {
        return this.getBodyString(VARIABLES);
    }

    @Override
    public void setVariables(String variables) {
        this.body.set(VARIABLES, this.createVariableNode(variables));
        this.updateRequestContent();
    }

    private JsonNode createVariableNode(String variables) {
        try {
            return mapper.readTree(variables);
        }
        catch (Exception exception) {
            return new TextNode(variables);
        }
    }

    @Override
    public String getQuery() {
        return this.getBodyString(QUERY);
    }

    @Override
    public void setQuery(String query) {
        String processedQuery = this.processBodyParameterValue(query);
        this.body.put(QUERY, processedQuery);
        this.body.put(OPERATION_NAME, processedQuery == null ? null : this.getOperationName(processedQuery));
        this.updateRequestContent();
    }

    public String processBodyParameterValue(String value) {
        return StringUtils.isNullOrEmpty(value) ? null : value;
    }

    private void updateRequestContent() {
        super.setRequestContent(this.body.toString());
        this.updateParameters();
    }

    private String getOperationName(String query) {
        Parser parser = new Parser();
        LinkedHashSet operationList = new LinkedHashSet();
        try {
            Document document = parser.parseDocument(query);
            document.getDefinitions().stream().forEach(def -> {
                String name;
                if (def instanceof OperationDefinition && StringUtils.hasContent(name = ((OperationDefinition)def).getName())) {
                    operationList.add(name);
                }
            });
        }
        catch (Exception document) {
            // empty catch block
        }
        int queryWithFewOperations = 2;
        if (operationList.size() >= 2) {
            return (String)operationList.stream().findFirst().get();
        }
        return null;
    }

    @Override
    public void setRequestContent(String request) {
        this.setBodyRequest(request);
        this.updateRequestContent();
    }

    private void setBodyRequest(String request) {
        ObjectNode bodyNode;
        try {
            JsonNode jsonNode = mapper.readTree(request);
            if (jsonNode == null || !jsonNode.isObject()) {
                return;
            }
            bodyNode = (ObjectNode)jsonNode;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (bodyNode == null) {
            return;
        }
        this.body.set(QUERY, bodyNode.get(QUERY));
        JsonNode variablesNode = bodyNode.get(VARIABLES);
        boolean needUpdateRequestContent = false;
        if (!variablesNode.isObject() && !variablesNode.isNull()) {
            variablesNode = this.createVariableNode(variablesNode.textValue());
            needUpdateRequestContent = true;
        }
        this.body.set(VARIABLES, variablesNode);
        this.body.set(OPERATION_NAME, bodyNode.get(OPERATION_NAME));
        if (needUpdateRequestContent) {
            this.updateRequestContent();
        }
    }

    private void updateParameters() {
        if (this.getMethod() == RestRequestInterface.HttpMethod.GET) {
            String query = StringUtils.emptyIfNull(this.getBodyString(QUERY));
            String operation = StringUtils.emptyIfNull(this.getBodyString(OPERATION_NAME));
            String variables = StringUtils.emptyIfNull(this.getBodyString(VARIABLES));
            this.params.setPropertyValue(QUERY, query);
            this.params.setPropertyValue(OPERATION_NAME, operation);
            this.params.setPropertyValue(VARIABLES, variables);
        } else {
            this.params.setPropertyValue(QUERY, "");
            this.params.setPropertyValue(OPERATION_NAME, "");
            this.params.setPropertyValue(VARIABLES, "");
        }
    }

    @Override
    public WsdlSubmit<GraphQLTestRequest> submit(SubmitContext submitContext, boolean async) throws Request.SubmitException {
        String endpoint = PropertyExpander.expandProperties(submitContext, this.getEndpoint());
        try {
            WsdlSubmit<GraphQLTestRequest> submitter = new WsdlSubmit<GraphQLTestRequest>(this, this.getSubmitListeners(), RequestTransportRegistry.getTransport(endpoint, submitContext));
            submitter.submitRequest(submitContext, async);
            return submitter;
        }
        catch (Exception e) {
            throw new Request.SubmitException(e.toString());
        }
    }

    @Override
    public MessagePart[] getRequestParts() {
        return new MessagePart[0];
    }

    @Override
    public MessagePart[] getResponseParts() {
        return new MessagePart[0];
    }

    @Override
    public void setMethod(RestRequestInterface.HttpMethod method) {
        RestRequestInterface.HttpMethod oldMethod = this.getMethod();
        if (oldMethod == method) {
            return;
        }
        if (method != RestRequestInterface.HttpMethod.GET && method != RestRequestInterface.HttpMethod.POST) {
            throw new IllegalArgumentException(String.format("The method %s is not allowed", method.toString()));
        }
        ((GraphQLTestRequestConfig)this.getConfig()).setMethod(method.toString());
        this.notifyPropertyChanged("method", (Object)oldMethod, (Object)method);
        this.updateParameters();
    }

    @Override
    public boolean hasRequestBody() {
        return this.getMethod() == RestRequestInterface.HttpMethod.POST;
    }

    @Override
    public RestParamsPropertyHolder getParams() {
        return this.params;
    }

    @Override
    public boolean isPostQueryString() {
        return false;
    }

    @Override
    public void setPostQueryString(boolean b) {
    }

    @Override
    public String getResponseContentAsXml() {
        Response response = this.getResponse();
        if (response == null) {
            return null;
        }
        return response.getContentAsXml();
    }

    @Override
    public void updateConfig(GraphQLTestRequestConfig request) {
        this.setConfig(request);
        List<AttachmentConfig> attachmentConfigs = ((GraphQLTestRequestConfig)this.getConfig()).getAttachmentList();
        for (int i = 0; i < attachmentConfigs.size(); ++i) {
            AttachmentConfig config = attachmentConfigs.get(i);
            this.getAttachmentsList().get(i).updateConfig(config);
        }
        if (this.jmsPropertiesConfig != null) {
            this.jmsPropertiesConfig.setJmsPropertyConfConfig(request.getJmsPropertyConfig());
        }
        this.assertionsSupport.refresh();
    }

    @Override
    public String getPath() {
        return this.getEndpoint();
    }

    @Override
    public String getMultiValueDelimiter() {
        return null;
    }

    @Override
    public String getMediaType() {
        return "application/json";
    }

    @Override
    public void setMediaType(String mediaType) {
    }

    @Override
    public TestProperty addProperty(String name) {
        return null;
    }

    @Override
    public TestProperty removeProperty(String propertyName) {
        return null;
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        return false;
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
    }

    @Override
    public String[] getPropertyNames() {
        return new String[0];
    }

    @Override
    public void setPropertyValue(String name, String value) {
    }

    @Override
    public String getPropertyValue(String name) {
        return this.params.getPropertyValue(name);
    }

    @Override
    public TestProperty getProperty(String name) {
        return this.params.getProperty(name);
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        return this.params.getProperties();
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
    }

    @Override
    public boolean hasProperty(String name) {
        return this.params.hasProperty(name);
    }

    @Override
    public int getPropertyCount() {
        return this.params.getPropertyCount();
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.params.getPropertyList();
    }

    @Override
    public TestProperty getPropertyAt(int index) {
        return this.params.getPropertyAt(index);
    }

    @Override
    public String getPropertiesLabel() {
        return "GraphQL Params";
    }

    @Override
    public void setResponse(HttpResponse response, SubmitContext context) {
        super.setResponse(response, context);
        this.assertResponse(context);
    }

    @Override
    public void assertResponse(SubmitContext context) {
        if (this.notifier == null) {
            this.notifier = new PropertyChangeNotifier();
        }
        HttpResponseMessageExchange httpResponseMessageExchange = this.messageExchange = this.getResponse() == null ? null : new HttpResponseMessageExchange(this);
        if (this.messageExchange != null) {
            for (WsdlMessageAssertion assertion : this.assertionsSupport.getAssertionList()) {
                assertion.assertResponse(this.messageExchange, context);
            }
        }
        this.notifier.notifyChange();
    }

    @Override
    public String getResponseContentAsString() {
        return this.getResponse() == null ? null : this.getResponse().getContentAsString();
    }

    @Override
    public WsdlTestStep getTestStep() {
        return this.testStep;
    }

    @Override
    public ModelItem getParent() {
        return this.getTestStep();
    }

    @Override
    public WsdlTestCase getTestCase() {
        return this.testStep.getTestCase();
    }

    @Override
    public AbstractHttpOperation getOperation() {
        return null;
    }

    @Override
    public WsdlMessageAssertion importAssertion(WsdlMessageAssertion source, boolean overwrite2, boolean createCopy, String newName) {
        return this.assertionsSupport.importAssertion(source, overwrite2, createCopy, newName);
    }

    @Override
    public boolean isDiscardResponse() {
        return this.getSettings().getBoolean("discardResponse");
    }

    public void setDiscardResponse(boolean discardResponse) {
        this.getSettings().setBoolean("discardResponse", discardResponse);
    }

    @Override
    public TestAssertion addAssertion(String selection) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            WsdlMessageAssertion assertion = this.assertionsSupport.addWsdlAssertion(selection);
            if (assertion == null) {
                return null;
            }
            if (this.getResponse() != null) {
                assertion.assertResponse(new HttpResponseMessageExchange(this), new WsdlTestRunContext(this.testStep));
                notifier.notifyChange();
            }
            return assertion;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    @Override
    public void addAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.addAssertionsListener(listener);
    }

    @Override
    public int getAssertionCount() {
        return this.assertionsSupport.getAssertionCount();
    }

    @Override
    public WsdlMessageAssertion getAssertionAt(int index) {
        return this.assertionsSupport.getAssertionAt(index);
    }

    @Override
    public void removeAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.removeAssertionsListener(listener);
    }

    @Override
    public void removeAssertion(TestAssertion assertion) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            this.assertionsSupport.removeAssertion((WsdlMessageAssertion)assertion);
        }
        finally {
            ((WsdlMessageAssertion)assertion).release();
            notifier.notifyChange();
        }
    }

    @Override
    public Assertable.AssertionStatus getAssertionStatus() {
        if (this.messageExchange == null) {
            return Assertable.AssertionStatus.UNKNOWN;
        }
        if (!this.messageExchange.hasResponse() && this.getOperation() != null && this.getOperation().isBidirectional()) {
            return Assertable.AssertionStatus.FAILED;
        }
        return this.assertionsSupport.getAssertionStatus();
    }

    @Override
    public String getAssertableContentAsXml() {
        return this.getResponseContentAsXml();
    }

    @Override
    public String getAssertableContent() {
        return this.getResponseContentAsString();
    }

    @Override
    public String getDefaultAssertableContent() {
        return "";
    }

    @Override
    public TestAssertionRegistry.AssertableType getAssertableType() {
        return TestAssertionRegistry.AssertableType.RESPONSE;
    }

    @Override
    public List<TestAssertion> getAssertionList() {
        return new ArrayList<TestAssertion>(this.assertionsSupport.getAssertionList());
    }

    @Override
    public TestAssertion getAssertionByName(String name) {
        return this.assertionsSupport.getAssertionByName(name);
    }

    @Override
    public Interface getInterface() {
        return null;
    }

    @Override
    public TestAssertion cloneAssertion(TestAssertion source, String name) {
        return this.assertionsSupport.cloneAssertion(source, name);
    }

    @Override
    public Map<String, TestAssertion> getAssertions() {
        return this.assertionsSupport.getAssertions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestAssertion moveAssertion(int ix, int offset) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        WsdlMessageAssertion assertion = this.getAssertionAt(ix);
        try {
            WsdlMessageAssertion wsdlMessageAssertion = this.assertionsSupport.moveAssertion(ix, offset);
            return wsdlMessageAssertion;
        }
        finally {
            assertion.release();
            notifier.notifyChange();
        }
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        this.assertionsSupport.resolve(context);
    }

    private class PropertyChangeNotifier {
        private Assertable.AssertionStatus oldStatus;
        private ImageIcon oldIcon;

        public PropertyChangeNotifier() {
            this.oldStatus = GraphQLTestRequest.this.getAssertionStatus();
            this.oldIcon = GraphQLTestRequest.this.getIcon();
        }

        public void notifyChange() {
            Assertable.AssertionStatus newStatus = GraphQLTestRequest.this.getAssertionStatus();
            ImageIcon newIcon = GraphQLTestRequest.this.getIcon();
            if (this.oldStatus != newStatus) {
                GraphQLTestRequest.this.notifyPropertyChanged(HttpTestRequestInterface.STATUS_PROPERTY, (Object)this.oldStatus, (Object)newStatus);
            }
            if (this.oldIcon != newIcon) {
                GraphQLTestRequest.this.notifyPropertyChanged(ModelItem.ICON_PROPERTY, this.oldIcon, GraphQLTestRequest.this.getIcon());
            }
            this.oldStatus = newStatus;
            this.oldIcon = newIcon;
        }
    }
}

