/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStepInterface;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.actions.ShowMessageExchangeAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.testsuite.AssertedXPath;
import com.eviware.soapui.model.testsuite.MessageExchangeTestStepResult;
import com.eviware.soapui.model.testsuite.ResponseAssertedMessageExchange;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.soapui.support.xml.XmlUtils;

public class GraphQLRequestTestStepResult
extends WsdlTestStepResult
implements ResponseAssertedMessageExchange,
MessageExchangeTestStepResult {
    private String requestContent;
    private HttpResponse response;
    private StringToStringMap properties;
    private boolean addedAction;
    private String endpoint;
    private String encoding;
    private WsdlSubmit submit;

    public GraphQLRequestTestStepResult(HttpTestRequestStepInterface step) {
        super((WsdlTestStep)((Object)step));
    }

    @Override
    public Operation getOperation() {
        if (this.response == null) {
            this.response = null;
        }
        return this.response == null ? null : this.response.getRequest().getOperation();
    }

    @Override
    public ModelItem getModelItem() {
        if (this.response != null) {
            return this.response.getRequest();
        }
        return null;
    }

    @Override
    public String getRequestContent() {
        if (this.isDiscarded()) {
            return "<discarded>";
        }
        return this.requestContent;
    }

    public void setRequestContent(String requestContent) {
        this.requestContent = requestContent;
    }

    public void setSubmit(WsdlSubmit submit) {
        this.submit = submit;
    }

    @Override
    public HttpResponse getResponse() {
        return this.response;
    }

    @Override
    public ActionList getActions() {
        if (!this.addedAction) {
            this.addAction(new ShowMessageExchangeAction(this, "TestStep"), true);
            this.addedAction = true;
        }
        return super.getActions();
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    public void addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new StringToStringMap();
        }
        this.properties.put(key, value);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.addProperty("Encoding", encoding);
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        this.addProperty("Endpoint", endpoint);
    }

    @Override
    public void discard() {
        super.discard();
        this.requestContent = null;
        this.response = null;
        this.properties = null;
    }

    @Override
    public StringToStringMap getProperties() {
        return this.properties;
    }

    @Override
    public String getProperty(String name) {
        return this.properties == null ? null : (String)this.properties.get(name);
    }

    @Override
    public Attachment[] getRequestAttachments() {
        if (this.response == null || this.response.getRequest() == null) {
            return new Attachment[0];
        }
        return this.response.getRequest().getAttachments();
    }

    @Override
    public StringToStringsMap getRequestHeaders() {
        if (this.response == null) {
            return null;
        }
        return this.response.getRequestHeaders();
    }

    @Override
    public Attachment[] getResponseAttachments() {
        return new Attachment[0];
    }

    @Override
    public String getResponseContent() {
        if (this.isDiscarded()) {
            return "<discarded>";
        }
        if (this.response == null) {
            return "<missing response>";
        }
        return this.response.getContentAsString();
    }

    @Override
    public String getRequestContentAsXml() {
        return XmlUtils.seemsToBeXml(this.requestContent) ? this.requestContent : "<not-xml/>";
    }

    @Override
    public String getResponseContentAsXml() {
        if (this.response == null) {
            return null;
        }
        return this.response.getContentAsXml();
    }

    @Override
    public StringToStringsMap getResponseHeaders() {
        if (this.response == null) {
            return new StringToStringsMap();
        }
        return this.response.getResponseHeaders();
    }

    @Override
    public long getTimestamp() {
        if (this.isDiscarded() || this.response == null) {
            return -1L;
        }
        return this.response.getTimestamp();
    }

    @Override
    public MessageExchange[] getMessageExchanges() {
        return new MessageExchange[]{this};
    }

    @Override
    public byte[] getRawRequestData() {
        if (this.response == null && this.submit != null && this.submit.getResponse() != null) {
            return this.submit.getResponse().getRawRequestData();
        }
        if (this.response != null) {
            return this.response.getRawRequestData();
        }
        return null;
    }

    @Override
    public byte[] getRawResponseData() {
        if (this.response != null) {
            return this.response.getRawResponseData();
        }
        return null;
    }

    @Override
    public Attachment[] getRequestAttachmentsForPart(String partName) {
        return null;
    }

    @Override
    public Attachment[] getResponseAttachmentsForPart(String partName) {
        return null;
    }

    @Override
    public boolean hasRawData() {
        return this.getRawResponseData() != null || this.getRawRequestData() != null;
    }

    @Override
    public boolean hasRequest(boolean b) {
        return true;
    }

    @Override
    public boolean hasResponse() {
        return this.response != null;
    }

    @Override
    public AssertedXPath[] getAssertedXPathsForResponse() {
        return new AssertedXPath[0];
    }
}

