/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.GraphQLTestRequestConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SinglePartHttpResponse;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.GraphQLRequestTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.GraphQLTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.GraphQLTestRequestStepInterface;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.support.DefaultTestStepProperty;
import com.eviware.soapui.model.support.TestStepBeanProperty;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.security.Securable;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class GraphQLRequestTestStep
extends WsdlTestStepWithProperties
implements GraphQLTestRequestStepInterface,
Securable {
    public static final String ICON_NAME = "/graphql-request.png";
    private GraphQLTestRequestConfig graphQLRequestConfig;
    private GraphQLTestRequest graphQLTestRequest;
    private WsdlSubmit<GraphQLTestRequest> submit;

    public GraphQLRequestTestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        super(testCase, config, true, forLoadTest);
        this.setIcon(UISupport.createImageIcon(ICON_NAME));
        if (((TestStepConfig)this.getConfig()).getConfig() != null) {
            this.graphQLRequestConfig = (GraphQLTestRequestConfig)((TestStepConfig)this.getConfig()).getConfig().changeType(GraphQLTestRequestConfig.type);
            this.graphQLTestRequest = new GraphQLTestRequest(this.graphQLRequestConfig, this, forLoadTest);
            this.graphQLTestRequest.addPropertyChangeListener(this);
            if (config.isSetName()) {
                this.graphQLTestRequest.setName(config.getName());
            } else {
                config.setName(this.graphQLTestRequest.getName());
            }
        } else {
            this.graphQLRequestConfig = (GraphQLTestRequestConfig)((TestStepConfig)this.getConfig()).addNewConfig().changeType(GraphQLTestRequestConfig.type);
        }
        this.initProperties();
    }

    private void initProperties() {
        this.addProperty(new TestStepBeanProperty(WsdlTestStepWithProperties.RESPONSE_AS_XML, true, this.graphQLTestRequest, "responseContentAsXml", this){

            @Override
            public String getDefaultValue() {
                return "";
            }
        });
        this.addProperty(new TestStepBeanProperty("Response", true, this.graphQLTestRequest, "responseContentAsString", this){

            @Override
            public String getDefaultValue() {
                return "";
            }
        });
        this.addProperty(new DefaultTestStepProperty("RawRequest", true, (WsdlTestStep)this){

            @Override
            public String getValue() {
                Response response = GraphQLRequestTestStep.this.graphQLTestRequest.getResponse();
                return response == null ? null : response.getRequestContent();
            }
        });
        this.addProperty(new DefaultTestStepProperty("RawResponse", true, (WsdlTestStep)this){

            @Override
            public String getValue() {
                Response response = GraphQLRequestTestStep.this.graphQLTestRequest.getResponse();
                return response == null ? null : new String(response.getRawResponseData());
            }
        });
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        return new PropertyExpansion[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestStepResult run(TestCaseRunner testRunner, TestCaseRunContext testRunContext) {
        GraphQLRequestTestStepResult testStepResult = new GraphQLRequestTestStepResult(this);
        try {
            this.submit = this.graphQLTestRequest.submit(testRunContext, false);
            HttpResponse response = (HttpResponse)this.submit.getResponse();
            Submit.Status currentStatus = this.submit.getStatus();
            if (currentStatus == Submit.Status.ERROR) {
                testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                testStepResult.addMessage(this.submit.getError().toString());
                testStepResult.setSubmit(this.submit);
                this.graphQLTestRequest.setResponse(null, testRunContext);
            } else if (currentStatus == Submit.Status.CANCELED) {
                testStepResult.setStatus(TestStepResult.TestStepStatus.CANCELED);
                testStepResult.addMessage("Request was canceled");
            } else if (response == null) {
                testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                testStepResult.addMessage("Request is missing response");
                this.graphQLTestRequest.setResponse(null, testRunContext);
            } else {
                this.graphQLTestRequest.setResponse(response, testRunContext);
                testStepResult.setTimeTaken(response.getTimeTaken());
                testStepResult.setSize(response.getContentLength());
                testStepResult.setResponse(response);
                switch (this.graphQLTestRequest.getAssertionStatus()) {
                    case FAILED: {
                        testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                        break;
                    }
                    case VALID: {
                        testStepResult.setStatus(TestStepResult.TestStepStatus.OK);
                        break;
                    }
                    case UNKNOWN: {
                        testStepResult.setStatus(TestStepResult.TestStepStatus.UNKNOWN);
                    }
                }
            }
            if (response != null) {
                testStepResult.setRequestContent(response.getRequestContent());
                testStepResult.addProperty("URL", response.getURL() == null ? "<missing>" : response.getURL().toString());
                testStepResult.addProperty("Method", String.valueOf(response.getMethod()));
                testStepResult.addProperty("StatusCode", String.valueOf(response.getStatusCode()));
                testStepResult.addProperty("HTTP Version", response.getHttpVersion());
            } else {
                testStepResult.setRequestContent(this.graphQLTestRequest.getRequestContent());
            }
        }
        catch (Request.SubmitException e) {
            testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
            testStepResult.addMessage("SubmitException: " + e);
        }
        finally {
            this.submit = null;
        }
        testStepResult.setEndpoint(PropertyExpander.expandProperties(testRunContext, this.graphQLTestRequest.getEndpoint()));
        testStepResult.setEncoding(PropertyExpander.expandProperties(testRunContext, this.graphQLTestRequest.getEncoding()));
        if (testStepResult.getStatus() != TestStepResult.TestStepStatus.CANCELED) {
            Assertable.AssertionStatus assertionStatus = this.graphQLTestRequest.getAssertionStatus();
            switch (assertionStatus) {
                case FAILED: {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    if (this.getAssertionCount() == 0) {
                        testStepResult.addMessage("Invalid/empty response");
                        break;
                    }
                    for (int i = 0; i < this.getAssertionCount(); ++i) {
                        WsdlMessageAssertion assertion = this.getAssertionAt(i);
                        AssertionError[] errors = assertion.getErrors();
                        if (errors == null) continue;
                        for (AssertionError error : errors) {
                            testStepResult.addMessage("[" + assertion.getName() + "] " + error.getMessage());
                        }
                    }
                    break;
                }
            }
        }
        if (this.graphQLTestRequest.isDiscardResponse() && !SoapUI.getDesktop().hasDesktopPanel(this)) {
            this.graphQLTestRequest.setResponse(null, testRunContext);
            testRunContext.removeProperty("httpResponse");
        }
        return testStepResult;
    }

    @Override
    public GraphQLTestRequest getTestRequest() {
        return this.graphQLTestRequest;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.graphQLTestRequest.setName(name);
    }

    @Override
    public AbstractHttpRequest<?> getHttpRequest() {
        return this.graphQLTestRequest;
    }

    @Override
    public TestAssertion addAssertion(String type) {
        return this.graphQLTestRequest.addAssertion(type);
    }

    @Override
    public void addAssertionsListener(AssertionsListener listener) {
        this.graphQLTestRequest.addAssertionsListener(listener);
    }

    @Override
    public void removeAssertionsListener(AssertionsListener listener) {
        this.graphQLTestRequest.removeAssertionsListener(listener);
    }

    @Override
    public int getAssertionCount() {
        return this.graphQLTestRequest.getAssertionCount();
    }

    @Override
    public WsdlMessageAssertion getAssertionAt(int index) {
        return this.graphQLTestRequest.getAssertionAt(index);
    }

    @Override
    public void removeAssertion(TestAssertion assertion) {
        this.graphQLTestRequest.removeAssertion(assertion);
    }

    @Override
    public Assertable.AssertionStatus getAssertionStatus() {
        return this.graphQLTestRequest.getAssertionStatus();
    }

    @Override
    public String getAssertableContentAsXml() {
        return this.graphQLTestRequest.getAssertableContentAsXml();
    }

    @Override
    public String getAssertableContent() {
        return this.graphQLTestRequest.getAssertableContent();
    }

    @Override
    public String getDefaultAssertableContent() {
        return this.graphQLTestRequest.getDefaultAssertableContent();
    }

    @Override
    public TestAssertionRegistry.AssertableType getAssertableType() {
        return this.graphQLTestRequest.getAssertableType();
    }

    @Override
    public List<TestAssertion> getAssertionList() {
        return this.graphQLTestRequest.getAssertionList();
    }

    @Override
    public TestAssertion getAssertionByName(String name) {
        return this.graphQLTestRequest.getAssertionByName(name);
    }

    @Override
    public TestStep getTestStep() {
        return this;
    }

    @Override
    public Interface getInterface() {
        return null;
    }

    @Override
    public TestAssertion cloneAssertion(TestAssertion source, String name) {
        return this.graphQLTestRequest.cloneAssertion(source, name);
    }

    @Override
    public Map<String, TestAssertion> getAssertions() {
        return this.graphQLTestRequest.getAssertions();
    }

    @Override
    public TestAssertion moveAssertion(int ix, int offset) {
        return this.graphQLTestRequest.moveAssertion(ix, offset);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.graphQLTestRequest && event.getNewValue() instanceof SinglePartHttpResponse) {
            SinglePartHttpResponse response = (SinglePartHttpResponse)event.getNewValue();
            this.firePropertyValueChanged("Response", String.valueOf(response), null);
            String XMLCOntent = response.getContentAsXml();
            this.firePropertyValueChanged("ResponseAsXml", String.valueOf(XMLCOntent), null);
        }
        if (event.getPropertyName().equals(TestAssertion.CONFIGURATION_PROPERTY) || event.getPropertyName().equals(TestAssertion.DISABLED_PROPERTY)) {
            if (this.getTestRequest().getResponse() != null) {
                this.getTestRequest().assertResponse(new WsdlTestRunContext(this));
            }
        } else {
            if (event.getSource() == this.graphQLTestRequest && event.getPropertyName().equals(WsdlTestRequest.NAME_PROPERTY) && !super.getName().equals(event.getNewValue())) {
                super.setName((String)event.getNewValue());
            }
            this.notifyPropertyChanged(event.getPropertyName(), event.getOldValue(), event.getNewValue());
        }
    }

    @Override
    public void release() {
        super.release();
        if (this.graphQLTestRequest != null) {
            this.graphQLTestRequest.removePropertyChangeListener(this);
            this.graphQLTestRequest.release();
        }
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        this.graphQLTestRequest.resolve(context);
    }

    @Override
    public void beforeSave() {
        super.beforeSave();
        if (this.graphQLTestRequest != null) {
            this.graphQLTestRequest.beforeSave();
        }
    }

    @Override
    public ImageIcon getIcon() {
        return this.graphQLTestRequest == null ? null : this.graphQLTestRequest.getIcon();
    }

    @Override
    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.graphQLRequestConfig = (GraphQLTestRequestConfig)config.getConfig().changeType(GraphQLTestRequestConfig.type);
        this.graphQLTestRequest.updateConfig(this.graphQLRequestConfig);
    }
}

