/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.SSLUtils;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.support.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoapUISSLSocketFactory
extends SSLConnectionSocketFactory {
    public static final String SSL_CONFIG_FOR_LAYERED_SOCKET_PARAM = "soapui.layered.socket.ssl.config";
    private static final Logger log = LogManager.getLogger(SoapUISSLSocketFactory.class);
    private static final Map<String, SSLConnectionSocketFactory> factoryMap = new ConcurrentHashMap<String, SSLConnectionSocketFactory>();
    private final SSLContext sslContext;

    public static SoapUISSLSocketFactory create(KeyStore keyStore, String keystorePassword) throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        String sslContextAlgorithm = System.getProperty("soapui.sslcontext.algorithm", "TLS");
        SSLContext sslContext = SSLContext.getInstance(sslContextAlgorithm);
        X509ExtendedTrustManager tm = SSLUtils.getTrustAllManager();
        if (keyStore != null) {
            KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmfactory.init(keyStore, keystorePassword != null ? keystorePassword.toCharArray() : null);
            KeyManager[] keymanagers = kmfactory.getKeyManagers();
            sslContext.init(keymanagers, new TrustManager[]{tm}, null);
        } else {
            sslContext.init(null, new TrustManager[]{tm}, null);
        }
        return new SoapUISSLSocketFactory(sslContext);
    }

    private SoapUISSLSocketFactory(SSLContext sslContext) throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        super(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        this.sslContext = sslContext;
    }

    private static Socket enableSocket(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            String invalidateSession = System.getProperty("soapui.https.session.invalidate");
            String protocols = System.getProperty("soapui.https.protocols");
            String ciphers = System.getProperty("soapui.https.ciphers");
            if (StringUtils.hasContent(invalidateSession)) {
                sslSocket.getSession().invalidate();
            }
            if (StringUtils.hasContent(protocols)) {
                sslSocket.setEnabledProtocols(protocols.split(","));
            }
            if (StringUtils.hasContent(ciphers)) {
                sslSocket.setEnabledCipherSuites(ciphers.split(","));
            }
        }
        return socket;
    }

    private String getSSLConfig(HttpContext context) {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        if (request == null) {
            return "";
        }
        Object result = request.getParams().getParameter("soapui.sslConfig");
        if (result == null) {
            result = request.getParams().getParameter("testserver.sslConfig");
        }
        if (result != null) {
            return (String)result;
        }
        return null;
    }

    public Socket createSocket(HttpContext context) throws IOException {
        String sslConfig = this.getSSLConfig(context);
        if (StringUtils.isNullOrEmpty(sslConfig)) {
            return SoapUISSLSocketFactory.enableSocket(this.createSocketWithProxy(context));
        }
        SSLConnectionSocketFactory factory = factoryMap.get(sslConfig);
        if (factory != null) {
            if (factory == this) {
                return SoapUISSLSocketFactory.enableSocket(this.createSslSocketWithProxy(context));
            }
            return SoapUISSLSocketFactory.enableSocket(factory.createSocket(context));
        }
        try {
            factory = SoapUISSLSocketFactory.create(this.getKeyAndPassword(sslConfig).getKey(), this.getKeyAndPassword(sslConfig).getPassword());
            factoryMap.put(sslConfig, factory);
            return SoapUISSLSocketFactory.enableSocket(factory.createSocket(context));
        }
        catch (Exception gse) {
            return SoapUISSLSocketFactory.enableSocket(this.createSocketWithProxy(context));
        }
    }

    private Socket createSocketWithProxy(HttpContext context) throws IOException {
        Proxy proxy;
        Settings settings = SoapUI.getSettings();
        if (ProxyUtils.isProxyEnabled() && !ProxyUtils.isAutoProxy() && ProxyUtils.getProxyType(settings) == Proxy.Type.SOCKS && (proxy = ProxyUtils.getProxy(settings)) != null) {
            return new Socket(proxy);
        }
        return super.createSocket(context);
    }

    private Socket createSslSocketWithProxy(HttpContext context) throws IOException {
        Proxy proxy;
        Settings settings = SoapUI.getSettings();
        if (ProxyUtils.isProxyEnabled() && !ProxyUtils.isAutoProxy() && ProxyUtils.getProxyType(settings) == Proxy.Type.SOCKS && (proxy = ProxyUtils.getProxy(settings)) != null) {
            Socket socket = new Socket(proxy);
            HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            RequestConfig requestConfig = clientContext.getRequestConfig();
            int connectionTimeout = requestConfig.getConnectTimeout();
            int soTimeout = requestConfig.getSocketTimeout();
            connectionTimeout = connectionTimeout < 0 ? 0 : connectionTimeout;
            soTimeout = soTimeout < 0 ? 0 : soTimeout;
            socket.setSoTimeout(soTimeout);
            socket.connect(new InetSocketAddress(targetHost.getHostName(), targetHost.getPort()), connectionTimeout);
            InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
            return this.sslContext.getSocketFactory().createSocket(socket, proxyAddress.getHostName(), proxyAddress.getPort(), true);
        }
        return this.sslContext.getSocketFactory().createSocket();
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLSocket sslsock;
        Socket sock;
        if (remoteAddress == null) {
            throw new IllegalArgumentException("Remote address may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context  may not be null");
        }
        Socket socket2 = sock = socket != null ? socket : new Socket();
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        RequestConfig cfg = clientContext.getRequestConfig();
        int connTimeout = cfg.getConnectTimeout();
        int soTimeout = cfg.getSocketTimeout();
        connTimeout = connTimeout < 0 ? 0 : connTimeout;
        soTimeout = soTimeout < 0 ? 0 : soTimeout;
        try {
            sock.setSoTimeout(soTimeout);
            if (!sock.isConnected()) {
                sock.connect(remoteAddress, connTimeout);
            }
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException("Connect to " + remoteAddress.getHostName() + "/" + remoteAddress.getAddress() + " timed out");
        }
        if (sock instanceof SSLSocket) {
            sslsock = (SSLSocket)sock;
        } else {
            sslsock = (SSLSocket)this.sslContext.getSocketFactory().createSocket(sock, remoteAddress.getHostName(), remoteAddress.getPort(), true);
            sslsock = (SSLSocket)SoapUISSLSocketFactory.enableSocket(sslsock);
        }
        return sslsock;
    }

    public Socket createLayeredSocket(Socket socket, String host, int port, HttpContext context) throws IOException {
        Socket sslSocket;
        String sslConfigForLayeredSocket = (String)context.getAttribute(SSL_CONFIG_FOR_LAYERED_SOCKET_PARAM);
        if (StringUtils.isNullOrEmpty(sslConfigForLayeredSocket)) {
            sslSocket = this.sslContext.getSocketFactory().createSocket(socket, host, port, true);
            sslSocket = SoapUISSLSocketFactory.enableSocket(sslSocket);
        } else {
            try {
                SoapUISSLSocketFactory factory = SoapUISSLSocketFactory.create(this.getKeyAndPassword(sslConfigForLayeredSocket).getKey(), this.getKeyAndPassword(sslConfigForLayeredSocket).getPassword());
                SSLContext sslContext = factory.getSSLContext();
                sslSocket = SoapUISSLSocketFactory.enableSocket(sslContext.getSocketFactory().createSocket(socket, host, port, true));
            }
            catch (Exception gse) {
                sslSocket = SoapUISSLSocketFactory.enableSocket(this.sslContext.getSocketFactory().createSocket(socket, host, port, true));
            }
        }
        return sslSocket;
    }

    private SSLContext getSSLContext() {
        return this.sslContext;
    }

    private KeyAndPassword getKeyAndPassword(String sslConfig) throws KeyStoreException {
        File f;
        int ix = sslConfig.lastIndexOf(32);
        String keyStore = sslConfig.substring(0, ix);
        String pwd = sslConfig.substring(ix + 1);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        if (keyStore.trim().length() > 0 && (f = new File(keyStore)).exists()) {
            log.info("Initializing Keystore from [" + keyStore + "]");
            try {
                KeyMaterial km = new KeyMaterial(f, pwd.toCharArray());
                ks = km.getKeyStore();
            }
            catch (Exception e) {
                pwd = null;
            }
        }
        return new KeyAndPassword(ks, pwd);
    }

    private final class KeyAndPassword {
        private final KeyStore key;
        private final String password;

        protected KeyAndPassword(KeyStore key, String password) {
            this.key = key;
            this.password = password;
        }

        protected KeyStore getKey() {
            return this.key;
        }

        protected String getPassword() {
            return this.password;
        }
    }
}

