/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.support.http.SoapUIManagedHttpClientConnectionFactory;
import com.eviware.soapui.impl.wsdl.support.http.SoapUiHttpClientConnectionOperator;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpClientConnection;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoapUIMultiThreadedHttpConnectionManager
extends PoolingHttpClientConnectionManager {
    private Object SSLState;
    private static final Logger log = LogManager.getLogger(SoapUIMultiThreadedHttpConnectionManager.class);
    IdleConnectionMonitorThread idleConnectionHandler = new IdleConnectionMonitorThread((HttpClientConnectionManager)this);

    public SoapUIMultiThreadedHttpConnectionManager(Registry<ConnectionSocketFactory> registry) {
        this(registry, new SoapUIManagedHttpClientConnectionFactory(), null);
        this.idleConnectionHandler.start();
    }

    public SoapUIMultiThreadedHttpConnectionManager(Registry<ConnectionSocketFactory> socketFactoryRegistry, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, DnsResolver dnsResolver) {
        this(socketFactoryRegistry, connFactory, null, dnsResolver, -1L, TimeUnit.MILLISECONDS);
    }

    public SoapUIMultiThreadedHttpConnectionManager(Registry<ConnectionSocketFactory> socketFactoryRegistry, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, long timeToLive, TimeUnit tunit) {
        super((HttpClientConnectionOperator)new SoapUiHttpClientConnectionOperator((Lookup<ConnectionSocketFactory>)socketFactoryRegistry, schemePortResolver, dnsResolver), connFactory, timeToLive, tunit);
    }

    public void setSSLState(Object SSLState) {
        this.SSLState = SSLState;
    }

    public void shutdown() {
        super.shutdown();
        this.idleConnectionHandler.shutdown();
    }

    public ConnectionRequest requestConnection(HttpRoute route, Object state) {
        if (this.SSLState != null) {
            return super.requestConnection(route, this.SSLState);
        }
        return super.requestConnection(route, state);
    }

    protected HttpClientConnection leaseConnection(Future future, long timeout, TimeUnit tunit) throws InterruptedException, ExecutionException, ConnectionPoolTimeoutException {
        HttpClientConnection httpClientConnection = null;
        while ((httpClientConnection = super.leaseConnection(future, timeout, tunit)).isOpen()) {
            if (httpClientConnection.isOpen() && AbstractHttpRequest.EMPTY_SSLSTATE.equals(this.SSLState)) {
                try {
                    httpClientConnection.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (AbstractHttpRequest.EMPTY_SSLSTATE.equals(this.SSLState)) continue;
        }
        return httpClientConnection;
    }

    public void releaseConnection(HttpClientConnection managedConn, Object state, long keepalive, TimeUnit tunit) {
        Object curState = state;
        SSLSession sslSession = ((ManagedHttpClientConnection)managedConn).getSSLSession();
        if (sslSession != null) {
            curState = sslSession.getLocalPrincipal();
        }
        super.releaseConnection(managedConn, curState, keepalive, tunit);
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

