/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.support.http.HttpCredentialsProvider;
import com.eviware.soapui.settings.ProxySettings;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class OverridableProxySelectorRoutePlanner
extends DefaultRoutePlanner {
    private static final String FORCE_DIRECT_CONNECTION = "FORCE_DIRECT_CONNECTION";
    private final ProxySelector proxySelector;

    @Deprecated
    static void setForceDirectConnection(HttpParams params) {
        params.setBooleanParameter(FORCE_DIRECT_CONNECTION, true);
    }

    public OverridableProxySelectorRoutePlanner(SchemePortResolver schemePortResolver, ProxySelector proxySelector) {
        super(schemePortResolver);
        this.proxySelector = proxySelector;
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        boolean autoProxy;
        CredentialsProvider credentialsProvider;
        if (request.getParams().getBooleanParameter(FORCE_DIRECT_CONNECTION, false)) {
            return null;
        }
        HttpHost proxy = ConnRouteParams.getDefaultProxy((HttpParams)request.getParams());
        if (this.proxySelector != null) {
            proxy = this.determineProxyThroughProxySelector(target);
        }
        if (proxy != null && context != null && (credentialsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider")) != null && credentialsProvider instanceof HttpCredentialsProvider && (autoProxy = SoapUI.getSettings().getBoolean(ProxySettings.AUTO_PROXY))) {
            HttpCredentialsProvider httpCredentialsProvider = (HttpCredentialsProvider)credentialsProvider;
            httpCredentialsProvider.setProxy(proxy.getHostName(), String.valueOf(proxy.getPort()));
        }
        return proxy;
    }

    protected HttpHost determineProxyThroughProxySelector(HttpHost target) throws HttpException {
        if (this.proxySelector == null) {
            return null;
        }
        URI targetURI = null;
        try {
            targetURI = new URI(target.toURI());
        }
        catch (URISyntaxException var10) {
            throw new HttpException("Cannot convert host to URI: " + target, (Throwable)var10);
        }
        List<Proxy> proxies = this.proxySelector.select(targetURI);
        Proxy proxy = this.chooseProxy(proxies);
        HttpHost result = null;
        if (proxy != null && proxy.type() == Proxy.Type.HTTP) {
            if (!(proxy.address() instanceof InetSocketAddress)) {
                throw new HttpException("Unable to handle non-Inet proxy address: " + proxy.address());
            }
            InetSocketAddress isa = (InetSocketAddress)proxy.address();
            String host = isa.isUnresolved() ? isa.getHostName() : isa.getAddress().getHostAddress();
            result = new HttpHost(host, isa.getPort());
        }
        return result;
    }

    protected Proxy chooseProxy(List<Proxy> proxies) {
        for (Proxy p : proxies) {
            if (p.type() != Proxy.Type.HTTP) continue;
            return p;
        }
        return null;
    }
}

