/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import java.lang.reflect.Field;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.impl.auth.GGSSchemeBase;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosProtocolFixer {
    public static byte[] generateFixedToken(GGSSchemeBase overridenClass, Oid oid, byte[] input, String authServer, Credentials credentials) throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        String service = "HTTP";
        try {
            Field serviceField = GGSSchemeBase.class.getDeclaredField("service");
            serviceField.setAccessible(true);
            service = (String)serviceField.get(overridenClass);
        }
        catch (NoSuchFieldException serviceField) {
        }
        catch (IllegalAccessException serviceField) {
            // empty catch block
        }
        if (service.equals("HTTPS")) {
            service = "HTTP";
        }
        GSSName serverName = manager.createName(service + "@" + authServer, GSSName.NT_HOSTBASED_SERVICE);
        GSSCredential gssCredential = credentials instanceof KerberosCredentials ? ((KerberosCredentials)credentials).getGSSCredential() : null;
        GSSContext gssContext = manager.createContext(serverName.canonicalize(oid), oid, gssCredential, 0);
        gssContext.requestMutualAuth(true);
        gssContext.requestCredDeleg(true);
        byte[] inputBuff = input;
        if (inputBuff == null) {
            inputBuff = new byte[]{};
        }
        return gssContext.initSecContext(inputBuff, 0, inputBuff.length);
    }
}

