/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.SSLUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.metrics.SoapUIMetrics;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.http.FixedDigestSchemeFactory;
import com.eviware.soapui.impl.wsdl.support.http.FixedKerberosSchemeFactory;
import com.eviware.soapui.impl.wsdl.support.http.FixedSPNegoSchemeFactory;
import com.eviware.soapui.impl.wsdl.support.http.HeaderRequestInterceptor;
import com.eviware.soapui.impl.wsdl.support.http.OverridableProxySelectorRoutePlanner;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.impl.wsdl.support.http.RequestContentWrapper;
import com.eviware.soapui.impl.wsdl.support.http.SoapUIMultiThreadedHttpConnectionManager;
import com.eviware.soapui.impl.wsdl.support.http.SoapUIPlainSocketFactory;
import com.eviware.soapui.impl.wsdl.support.http.SoapUISSLSocketFactory;
import com.eviware.soapui.impl.wsdl.support.wsdl.UrlWsdlLoader;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.settings.SSLSettings;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.StringUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.RequestAddCookies;
import org.apache.http.client.protocol.RequestAuthCache;
import org.apache.http.client.protocol.RequestClientConnControl;
import org.apache.http.client.protocol.RequestDefaultHeaders;
import org.apache.http.client.protocol.RequestExpectContinue;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.client.protocol.ResponseProcessCookies;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.UnsupportedSchemeException;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.CookieSpecRegistries;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.DefaultCookieSpecProvider;
import org.apache.http.impl.cookie.RFC6265CookieSpecProvider;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.VersionInfo;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientSupport {
    private static final org.apache.logging.log4j.Logger log = LogManager.getLogger(HttpClientSupport.class);
    private static final Helper helper = new Helper();

    public static SoapUIHttpClient getHttpClient() {
        return helper.getHttpClient();
    }

    public static AuthScheme getAuthScheme(String schemeName) {
        return HttpClientSupport.getHttpClient().getAuthScheme(schemeName);
    }

    public static int getDefaultPort(ExtendedHttpMethod httpMethod, HttpClient httpClient) {
        return HttpClientSupport.getHttpClient().getDefaultPort(httpMethod.getURI().getScheme());
    }

    public static void setProxy(ProxySelector proxySelector, CredentialsProvider credential) {
        HttpClientSupport.getHttpClient().setProxy(proxySelector, credential);
    }

    public static HttpResponse execute(ExtendedHttpMethod method, HttpContext httpContext) throws ClientProtocolException, IOException {
        return helper.execute(method, httpContext);
    }

    public static HttpResponse execute(ExtendedHttpMethod method) throws ClientProtocolException, IOException {
        return helper.execute(method);
    }

    public static void applyHttpSettings(HttpRequest httpMethod, Settings settings) {
        String userAgent = settings.getString(HttpSettings.USER_AGENT, null);
        if (userAgent != null && userAgent.length() > 0) {
            httpMethod.setHeader("User-Agent", userAgent);
        }
        long timeout = settings.getLong(HttpSettings.SOCKET_TIMEOUT, 60000L);
        httpMethod.getParams().setParameter("http.socket.timeout", (Object)((int)timeout));
    }

    public static String getResponseCompressionType(HttpResponse httpResponse) {
        Header contentType = null;
        if (httpResponse.getEntity() != null) {
            contentType = httpResponse.getEntity().getContentType();
        }
        Header contentEncoding = null;
        if (httpResponse.getEntity() != null) {
            contentEncoding = httpResponse.getEntity().getContentEncoding();
        }
        return HttpClientSupport.getCompressionType(contentType == null ? null : contentType.getValue(), contentEncoding == null ? null : contentEncoding.getValue());
    }

    public static String getCompressionType(String contentType, String contentEncoding) {
        String compressionAlg;
        String string = compressionAlg = contentType == null ? null : CompressionSupport.getAvailableAlgorithm(contentType);
        if (compressionAlg != null) {
            return compressionAlg;
        }
        if (contentEncoding == null) {
            return null;
        }
        return CompressionSupport.getAvailableAlgorithm(contentEncoding);
    }

    public static void addSSLListener(Settings settings) {
        settings.addSettingsListener(helper.new Helper.SSLSettingsListener());
    }

    public static BasicHttpContext createEmptyContext() {
        BasicHttpContext httpContext = new BasicHttpContext();
        BasicCookieStore cookieStore = new BasicCookieStore();
        httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
        return httpContext;
    }

    static {
        if (PropertyExpander.getDefaultExpander() == null) {
            SoapUI.log.warn("Default property expander was null - will set global proxy later");
        } else {
            ProxyUtils.setGlobalProxy(SoapUI.getSettings());
        }
    }

    private static class Helper {
        private final SoapUIHttpClient httpClient;
        private static final org.apache.logging.log4j.Logger log = LogManager.getLogger(Helper.class);

        public Helper() {
            Settings settings = SoapUI.getSettings();
            this.httpClient = new SoapUIHttpClient(settings);
            settings.addSettingsListener(new SSLSettingsListener());
        }

        public SoapUIHttpClient getHttpClient() {
            return this.httpClient;
        }

        public HttpResponse execute(ExtendedHttpMethod method, HttpContext httpContext) throws ClientProtocolException, IOException {
            method.afterWriteRequest();
            if (method.getMetrics() != null) {
                method.getMetrics().getConnectTimer().start();
            }
            CloseableHttpResponse httpResponse = this.httpClient.execute(method, httpContext);
            method.setHttpResponse((HttpResponse)httpResponse);
            return httpResponse;
        }

        public HttpResponse execute(ExtendedHttpMethod method) throws ClientProtocolException, IOException {
            method.afterWriteRequest();
            if (method.getMetrics() != null) {
                method.getMetrics().getConnectTimer().start();
            }
            CloseableHttpResponse httpResponse = this.httpClient.execute(method);
            method.setHttpResponse((HttpResponse)httpResponse);
            return httpResponse;
        }

        public final class SSLSettingsListener
        implements SettingsListener {
            private void updateSSLSocketFactory() {
                try {
                    log.info("Updating keyStore...");
                    Helper.this.httpClient.updateSSLSocketFactory();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void settingChanged(String name, String newValue, String oldValue) {
                if (name.equals(SSLSettings.KEYSTORE) || name.equals(SSLSettings.KEYSTORE_PASSWORD)) {
                    this.updateSSLSocketFactory();
                } else if (name.equals(HttpSettings.MAX_CONNECTIONS_PER_HOST)) {
                    log.info("Updating max connections per host to " + newValue);
                    Helper.this.httpClient.setDefaultMaxPerRoute(Integer.parseInt(newValue));
                } else if (name.equals(HttpSettings.MAX_TOTAL_CONNECTIONS)) {
                    log.info("Updating max total connections host to " + newValue);
                    Helper.this.httpClient.setMaxTotal(Integer.parseInt(newValue));
                }
            }

            @Override
            public void settingsReloaded() {
                this.updateSSLSocketFactory();
            }
        }
    }

    public static class SoapUIHttpClient
    extends CloseableHttpClient {
        private CloseableHttpClient realClient;
        private PoolingHttpClientConnectionManager connectionManager;
        private SoapUISchemePortResolver schemePortResolver = new SoapUISchemePortResolver();
        private HttpRoutePlanner routePlanner = new DefaultRoutePlanner((SchemePortResolver)this.schemePortResolver);
        Lookup<AuthSchemeProvider> authProviders = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).register("Digest", (Object)new FixedDigestSchemeFactory()).register("NTLM", (Object)new NTLMSchemeFactory()).register("Negotiate", (Object)new FixedSPNegoSchemeFactory()).register("Kerberos", (Object)new FixedKerberosSchemeFactory()).build();
        private CredentialsProvider credential;
        private HttpClientBuilder builder;
        private static final MessageSupport messages = MessageSupport.getMessages(SoapUIHttpClient.class);
        private final int MAX_TOTAL_CONNECTIONS_DEFAULT = 2000;
        private final int MAX_CONNECTIONS_PER_HOST_DEFAULT = 500;
        private final String CURRENT_VALUE_MESSAGE = "The current value is {0}";
        private final String DEFAULT_VALUE_MESSAGE = "The value has been set to default: {0}";

        public static SSLConnectionSocketFactory initSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
            KeyStore keyStore = SSLUtils.getReadyApiKeystore(log);
            String password = SSLUtils.getKeyStorePassword();
            return SoapUISSLSocketFactory.create(keyStore, password);
        }

        private SoapUIMultiThreadedHttpConnectionManager buildConnectionManager() {
            RegistryBuilder registryBuilder = RegistryBuilder.create();
            registryBuilder.register("http", (Object)new SoapUIPlainSocketFactory());
            try {
                SSLConnectionSocketFactory socketFactory = SoapUIHttpClient.initSSLSocketFactory();
                registryBuilder.register("https", (Object)socketFactory);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new SoapUIMultiThreadedHttpConnectionManager((Registry<ConnectionSocketFactory>)registryBuilder.build());
        }

        protected HttpProcessor createHttpProcessor(Settings settings) {
            ArrayList<Object> requestInterceptors = new ArrayList<Object>();
            requestInterceptors.add(new RequestDefaultHeaders());
            requestInterceptors.add(new HeaderChecker());
            requestInterceptors.add(new RequestContentWrapper(true));
            requestInterceptors.add(new RequestTargetHost());
            requestInterceptors.add(new RequestClientConnControl());
            requestInterceptors.add(new RequestUserAgent(VersionInfo.getUserAgent((String)"Apache-HttpClient", (String)"org.apache.http.client", HttpClientBuilder.class)));
            requestInterceptors.add(new RequestExpectContinue());
            requestInterceptors.add(new RequestAddCookies());
            if (settings.getBoolean(HttpSettings.RESPONSE_COMPRESSION)) {
                requestInterceptors.add(new RequestAcceptEncoding());
            }
            requestInterceptors.add(new RequestAuthCache());
            requestInterceptors.add(new HeaderRequestInterceptor());
            ArrayList<Object> responseInterceptors = new ArrayList<Object>();
            responseInterceptors.add(new ResponseProcessCookies());
            if (!settings.getBoolean(HttpSettings.DISABLE_RESPONSE_DECOMPRESSION)) {
                responseInterceptors.add(new ResponseContentEncoding());
            }
            return new ImmutableHttpProcessor(requestInterceptors, responseInterceptors);
        }

        public SoapUIHttpClient(Settings settings) {
            int maxConnectionsPerHost;
            this.connectionManager = this.buildConnectionManager();
            this.builder = HttpClientBuilder.create();
            this.builder.setConnectionManager((HttpClientConnectionManager)this.connectionManager);
            this.builder.setRequestExecutor((HttpRequestExecutor)new SoapUIHttpRequestExecutor());
            this.builder.setSchemePortResolver((SchemePortResolver)this.schemePortResolver);
            this.builder.setRoutePlanner(this.routePlanner);
            this.builder.setDefaultAuthSchemeRegistry(this.authProviders);
            this.builder.setHttpProcessor(this.createHttpProcessor(settings));
            int maxTotalConnections = (int)settings.getLong(HttpSettings.MAX_TOTAL_CONNECTIONS, 2000L);
            if (maxTotalConnections < 1) {
                settings.setLong(HttpSettings.MAX_TOTAL_CONNECTIONS, 2000L);
                log.warn("The value of Max total connections must be greater than 0." + messages.get("The current value is {0}", maxTotalConnections));
                log.warn(messages.get("The value has been set to default: {0}", 2000));
                maxTotalConnections = 2000;
            }
            if ((maxConnectionsPerHost = (int)settings.getLong(HttpSettings.MAX_CONNECTIONS_PER_HOST, 500L)) < 1) {
                settings.setLong(HttpSettings.MAX_CONNECTIONS_PER_HOST, 500L);
                log.warn("The value of Max connections per host must be greater than 0." + messages.get("The current value is {0}", maxConnectionsPerHost));
                log.warn(messages.get("The value has been set to default: {0}", 500));
                maxConnectionsPerHost = 500;
            }
            this.connectionManager.setMaxTotal(maxTotalConnections);
            this.connectionManager.setDefaultMaxPerRoute(maxConnectionsPerHost);
            PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.getDefault();
            DefaultCookieSpecProvider defaultCookieSpecProvider = new DefaultCookieSpecProvider(DefaultCookieSpecProvider.CompatibilityLevel.IE_MEDIUM_SECURITY, publicSuffixMatcher);
            RFC6265CookieSpecProvider standardCookieSpecProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.IE_MEDIUM_SECURITY, publicSuffixMatcher);
            Registry cookieSpecProviderRegistry = CookieSpecRegistries.createDefaultBuilder((PublicSuffixMatcher)publicSuffixMatcher).register("default", (Object)defaultCookieSpecProvider).register("standard", (Object)standardCookieSpecProvider).build();
            this.builder.setDefaultCookieSpecRegistry((Lookup)cookieSpecProviderRegistry);
            this.realClient = this.builder.build();
        }

        private HttpRequest tuneRequest(HttpRequest httpRequest) {
            Object version = httpRequest.getParams().getParameter("http.protocol.version");
            if (version != null && httpRequest.getProtocolVersion() != version) {
                return RequestBuilder.copy((HttpRequest)httpRequest).setVersion((ProtocolVersion)version).build();
            }
            return httpRequest;
        }

        private HttpClientContext tuneContext(HttpRequest httpRequest, HttpContext httpContext) {
            if (httpContext == null) {
                httpContext = new BasicHttpContext();
            }
            CredentialsProvider credentialsProvider = (CredentialsProvider)httpContext.getAttribute("http.auth.credentials-provider");
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)httpContext);
            if (credentialsProvider != null) {
                clientContext.setCredentialsProvider(credentialsProvider);
            } else if (ProxyUtils.isProxyEnabled()) {
                clientContext.setCredentialsProvider(this.credential);
            }
            Object socketTimeout = httpRequest.getParams().getParameter("http.socket.timeout");
            Object redirect = httpRequest.getParams().getParameter("http.protocol.handle-redirects");
            Object expectContinue = httpRequest.getParams().getParameter("http.protocol.expect-continue");
            Object localAddress = httpRequest.getParams().getParameter("http.route.local-address");
            if (socketTimeout != null || redirect != null || localAddress != null || expectContinue != null) {
                RequestConfig.Builder cfgBuilder = RequestConfig.copy((RequestConfig)clientContext.getRequestConfig());
                if (socketTimeout != null) {
                    cfgBuilder.setSocketTimeout(((Integer)socketTimeout).intValue());
                }
                if (redirect != null) {
                    cfgBuilder.setRedirectsEnabled(((Boolean)redirect).booleanValue());
                }
                if (expectContinue != null) {
                    cfgBuilder.setExpectContinueEnabled(((Boolean)expectContinue).booleanValue());
                }
                if (localAddress != null) {
                    cfgBuilder.setLocalAddress((InetAddress)localAddress);
                }
                clientContext.setRequestConfig(cfgBuilder.build());
            }
            httpRequest.getParams().setParameter("http.protocol.cookie-policy", (Object)"standard");
            Object reguestSSLState = clientContext.getAttribute("http.user-token-ssl");
            ((SoapUIMultiThreadedHttpConnectionManager)this.connectionManager).setSSLState(reguestSSLState);
            clientContext.setAttribute("http.auth.target-scope", (Object)new AuthState());
            return clientContext;
        }

        protected CloseableHttpResponse doExecute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException {
            HttpClientContext clientContext = this.tuneContext(httpRequest, httpContext);
            HttpRequest request = this.tuneRequest(httpRequest);
            return this.realClient.execute(httpHost, request, (HttpContext)clientContext);
        }

        public void close() throws IOException {
            this.realClient.close();
        }

        public HttpParams getParams() {
            return this.realClient.getParams();
        }

        public ClientConnectionManager getConnectionManager() {
            return this.realClient.getConnectionManager();
        }

        public int getDefaultPort(String schemeName) {
            try {
                return this.schemePortResolver.resolve(schemeName);
            }
            catch (UnsupportedSchemeException ex) {
                return 0;
            }
        }

        public void setMaxTotal(int value) {
            this.connectionManager.setMaxTotal(value);
        }

        public void setDefaultMaxPerRoute(int value) {
            this.connectionManager.setDefaultMaxPerRoute(value);
        }

        public void updateSSLSocketFactory() {
            PoolingHttpClientConnectionManager old = this.connectionManager;
            this.connectionManager = this.buildConnectionManager();
            this.connectionManager.setMaxTotal(old.getMaxTotal());
            this.connectionManager.setDefaultMaxPerRoute(old.getDefaultMaxPerRoute());
            this.builder.setConnectionManager((HttpClientConnectionManager)this.connectionManager);
            this.realClient = this.builder.build();
        }

        public void setProxy(ProxySelector proxySelector, CredentialsProvider credential) {
            this.credential = credential;
            if (credential != null && ProxyUtils.isProxyEnabled()) {
                UrlWsdlLoader.setProxyCredentials(credential.getCredentials(AuthScope.ANY));
            } else {
                UrlWsdlLoader.setProxyCredentials(null);
            }
            this.routePlanner = new OverridableProxySelectorRoutePlanner(this.schemePortResolver, proxySelector);
            this.builder.setRoutePlanner(this.routePlanner);
            this.realClient = this.builder.build();
        }

        public HttpRoutePlanner getRoutePlanner() {
            return this.routePlanner;
        }

        public AuthScheme getAuthScheme(String schemeName) {
            AuthSchemeProvider provider = (AuthSchemeProvider)this.authProviders.lookup(schemeName);
            if (provider != null) {
                return provider.create(null);
            }
            throw new IllegalStateException("Unsupported authentication scheme: " + schemeName);
        }
    }

    private static class HeaderChecker
    implements HttpRequestInterceptor {
        private static final Logger log = LoggerFactory.getLogger(HeaderChecker.class);
        private static final MessageSupport message = MessageSupport.getMessages(HeaderChecker.class);

        private HeaderChecker() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            List<String> overriddenHeaders = Arrays.asList("Transfer-Encoding", "Content-Length");
            for (Header header : request.getAllHeaders()) {
                String name = header.getName();
                if (overriddenHeaders.contains(name)) {
                    log.warn(String.format(message.get("HeaderChecker.log.warn.header.ignored"), name));
                    continue;
                }
                if (!StringUtils.isNullOrEmpty(name)) continue;
                log.warn(String.format(message.get("HeaderChecker.log.warn.header.ignored"), name));
                request.removeHeader(header);
            }
        }
    }

    public static class SoapUIHttpRequestExecutor
    extends HttpRequestExecutor {
        public void preProcess(HttpRequest request, HttpProcessor processor, HttpContext context) throws HttpException, IOException {
            HttpRequest original = request;
            if (original instanceof RequestWrapper) {
                RequestWrapper w = (RequestWrapper)request;
                original = w.getOriginal();
            }
            if (original instanceof ExtendedHttpMethod) {
                SoapUIMetrics metrics = ((ExtendedHttpMethod)original).getMetrics();
                metrics.getConnectTimer().stop();
                metrics.getTimeToFirstByteTimer().start();
            }
            super.preProcess(request, processor, context);
        }

        protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
            HttpResponse response = super.doSendRequest(request, conn, context);
            return response;
        }

        protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
            if (request == null) {
                throw new IllegalArgumentException("HTTP request may not be null");
            }
            if (conn == null) {
                throw new IllegalArgumentException("HTTP connection may not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("HTTP context may not be null");
            }
            HttpResponse response = null;
            int statuscode = 0;
            HttpRequest original = request;
            if (original instanceof HttpRequestWrapper) {
                HttpRequestWrapper w = (HttpRequestWrapper)request;
                original = w.getOriginal();
            }
            while (response == null || statuscode < 200) {
                response = conn.receiveResponseHeader();
                SoapUIMetrics metrics = null;
                if (original instanceof ExtendedHttpMethod) {
                    metrics = ((ExtendedHttpMethod)original).getMetrics();
                    metrics.getTimeToFirstByteTimer().stop();
                    metrics.getReadTimer().start();
                }
                if (this.canResponseHaveBody(request, response)) {
                    conn.receiveResponseEntity(response);
                }
                statuscode = response.getStatusLine().getStatusCode();
                if (!(conn.getMetrics() instanceof SoapUIMetrics)) continue;
                SoapUIMetrics connectionMetrics = (SoapUIMetrics)conn.getMetrics();
                if (metrics == null || connectionMetrics == null || connectionMetrics.isDone()) continue;
                metrics.getDNSTimer().set(connectionMetrics.getDNSTimer().getStart(), connectionMetrics.getDNSTimer().getStop());
                connectionMetrics.reset();
            }
            if (original instanceof ExtendedHttpMethod) {
                ExtendedHttpMethod extendedHttpMethod = (ExtendedHttpMethod)original;
                extendedHttpMethod.afterReadResponse(((ManagedHttpClientConnection)conn).getSSLSession());
            }
            return response;
        }
    }

    private static class SoapUISchemePortResolver
    implements SchemePortResolver {
        private SoapUISchemePortResolver() {
        }

        public int resolve(HttpHost httpHost) throws UnsupportedSchemeException {
            int port = httpHost.getPort();
            return port > 0 ? port : this.resolve(httpHost.getSchemeName());
        }

        public int resolve(String schemeName) throws UnsupportedSchemeException {
            if (StringUtils.isNullOrEmpty(schemeName)) {
                throw new NullArgumentException("schemeName");
            }
            if (schemeName.equalsIgnoreCase("http")) {
                return 80;
            }
            if (schemeName.equalsIgnoreCase("https")) {
                return 443;
            }
            throw new UnsupportedSchemeException(schemeName + " protocol is not supported");
        }
    }
}

